/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.net.Inet4Address;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.phantomjs.InetUtil;
import net.sf.jasperreports.phantomjs.PhantomJSProcess;
import net.sf.jasperreports.phantomjs.ProcessFactory;
import net.sf.jasperreports.phantomjs.RequestTimeoutException;
import net.sf.jasperreports.phantomjs.ScriptManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class ProcessDirector {
    private static final Log log = LogFactory.getLog(ProcessDirector.class);
    private String phantomjsExecutablePath;
    private int processStartTimeout;
    private int idlePingInterval;
    private int requestTimeout;
    private List<JRPropertiesUtil.PropertySuffix> options;
    private ScriptManager scriptManager;
    private Inet4Address listenAddress;
    private GenericObjectPool<PhantomJSProcess> processPool;

    public ProcessDirector(JasperReportsContext jasperReportsContext, ScriptManager scriptManager) {
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.phantomjsExecutablePath = properties.getProperty("net.sf.jasperreports.phantomjs.executable.path");
        this.processStartTimeout = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.start.timeout", 10000);
        this.idlePingInterval = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.idle.ping.interval", 40000);
        this.requestTimeout = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.request.timeout", 60000);
        this.scriptManager = scriptManager;
        if (this.phantomjsExecutablePath != null) {
            this.listenAddress = InetUtil.getIPv4Loopback();
            if (this.listenAddress == null) {
                log.error("Unable to determine an IPv4 loopback address");
            }
        }
        this.options = properties.getProperties("net.sf.jasperreports.phantomjs.options.");
        this.processPool = this.createProcessPool(properties);
    }

    private GenericObjectPool<PhantomJSProcess> createProcessPool(JRPropertiesUtil properties) {
        ProcessFactory processFactory = new ProcessFactory(this, properties);
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)processFactory);
        pool.setLifo(true);
        int maxProcessCount = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.max.process.count", 8);
        pool.setMaxTotal(maxProcessCount);
        pool.setMaxIdle(maxProcessCount);
        int borrowTimeout = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.pool.borrow.timeout", 120000);
        pool.setMaxWaitMillis((long)borrowTimeout);
        int idleTimeout = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.idle.timeout", 300000);
        pool.setMinEvictableIdleTimeMillis((long)idleTimeout);
        pool.setTimeBetweenEvictionRunsMillis((long)this.idlePingInterval);
        pool.setTestWhileIdle(true);
        pool.setNumTestsPerEvictionRun(Integer.MAX_VALUE);
        pool.setSwallowedExceptionListener(new SwallowedExceptionListener(){

            public void onSwallowException(Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Pool exception", e);
                }
            }
        });
        return pool;
    }

    public String getPhantomjsExecutablePath() {
        return this.phantomjsExecutablePath;
    }

    public int getProcessStartTimeout() {
        return this.processStartTimeout;
    }

    protected int getProcessIdleTimeout() {
        return this.idlePingInterval * 5 / 2;
    }

    protected int getRequestTimeout() {
        return this.requestTimeout;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public Inet4Address getListenAddress() {
        return this.listenAddress;
    }

    public List<JRPropertiesUtil.PropertySuffix> getOptions() {
        return this.options;
    }

    public String runRequest(String data) {
        PhantomJSProcess process = null;
        boolean invalidate = false;
        try {
            process = (PhantomJSProcess)this.processPool.borrowObject();
            String string = process.getProcessConnection().runRequest(data);
            return string;
        }
        catch (RequestTimeoutException e) {
            invalidate = true;
            throw e;
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (process != null) {
                if (invalidate) {
                    try {
                        this.processPool.invalidateObject((Object)process);
                    }
                    catch (Exception e) {
                        log.error("Failed to invalidate PhantomJS process " + process.getId());
                    }
                } else {
                    this.processPool.returnObject((Object)process);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProcessDirector processDirector = this;
        synchronized (processDirector) {
            this.processPool.close();
        }
    }
}

