/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.phantomjs.ProcessDirector;
import net.sf.jasperreports.phantomjs.ScriptManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhantomJS {
    private static final Log log = LogFactory.getLog(PhantomJS.class);
    public static final String PROPERTY_PHANTOMJS_EXECUTABLE_PATH = "net.sf.jasperreports.phantomjs.executable.path";
    public static final String PROPERTY_PHANTOMJS_TEMPDIR_PATH = "net.sf.jasperreports.phantomjs.tempdir.path";
    public static final String PROPERTY_PHANTOMJS_START_TIMEOUT = "net.sf.jasperreports.phantomjs.start.timeout";
    public static final int DEFAULT_PHANTOMJS_START_TIMEOUT = 10000;
    public static final String PROPERTY_PHANTOMJS_MAX_PROCESS_COUNT = "net.sf.jasperreports.phantomjs.max.process.count";
    public static final int DEFAULT_PHANTOMJS_MAX_PROCESS_COUNT = 8;
    public static final String PROPERTY_PHANTOMJS_POOL_BORROW_TIMEOUT = "net.sf.jasperreports.phantomjs.pool.borrow.timeout";
    public static final int DEFAULT_PHANTOMJS_POOL_BORROW_TIMEOUT = 120000;
    public static final String PROPERTY_PHANTOMJS_IDLE_TIMEOUT = "net.sf.jasperreports.phantomjs.idle.timeout";
    public static final int DEFAULT_PHANTOMJS_IDLE_TIMEOUT = 300000;
    public static final String PROPERTY_PHANTOMJS_IDLE_PING_INTERVAL = "net.sf.jasperreports.phantomjs.idle.ping.interval";
    public static final int DEFAULT_PHANTOMJS_IDLE_PING_INTERVAL = 40000;
    public static final String PROPERTY_PHANTOMJS_EXPIRATION_COUNT = "net.sf.jasperreports.phantomjs.expiration.count";
    public static final int DEFAULT_PHANTOMJS_EXPIRATION_COUNT = 1000;
    public static final String PROPERTY_PHANTOMJS_EXPIRATION_TIME = "net.sf.jasperreports.phantomjs.expiration.time";
    public static final int DEFAULT_PHANTOMJS_EXPIRATION_TIME = 1200000;
    public static final String PROPERTY_PHANTOMJS_REQUEST_TIMEOUT = "net.sf.jasperreports.phantomjs.request.timeout";
    public static final int DEFAULT_PHANTOMJS_REQUEST_TIMEOUT = 60000;
    public static final String MAIN_SCRIPT_RESOURCE = "net/sf/jasperreports/phantomjs/process.js";
    public static final String PROPERTY_OPTIONS_PREFIX = "net.sf.jasperreports.phantomjs.options.";
    private static volatile boolean INSTANTIATED = false;
    private final JasperReportsContext jasperReportsContext;
    private final ScriptManager scriptManager;
    private final ProcessDirector processDirector;

    public static boolean isEnabled() {
        String phantomjsExecutablePath = DefaultJasperReportsContext.getInstance().getProperty(PROPERTY_PHANTOMJS_EXECUTABLE_PATH);
        return phantomjsExecutablePath != null;
    }

    public static PhantomJS instance() {
        return PhantomJSInitializer.INSTANCE;
    }

    public static void disposePhantom() {
        if (INSTANTIATED) {
            PhantomJS.instance().dispose();
        }
    }

    private PhantomJS() {
        INSTANTIATED = true;
        this.jasperReportsContext = DefaultJasperReportsContext.getInstance();
        this.scriptManager = new ScriptManager(this.jasperReportsContext);
        this.processDirector = new ProcessDirector(this.jasperReportsContext, this.scriptManager);
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public String runRequest(String data) {
        return this.processDirector.runRequest(data);
    }

    public void dispose() {
        this.processDirector.dispose();
        this.scriptManager.dispose();
    }

    protected void finalize() {
        this.dispose();
    }

    private static class PhantomJSInitializer {
        private static final PhantomJS INSTANCE = new PhantomJS();

        private PhantomJSInitializer() {
        }
    }
}

