/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.export.pdf.FontRecipient;
import net.sf.jasperreports.export.pdf.PdfFontStyle;

public class ClassicFontRecipient
implements FontRecipient {
    private Font font;

    @Override
    public boolean hasFont() {
        return this.font != null;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(String pdfFontName, String pdfEncoding, boolean isPdfEmbedded, float size, PdfFontStyle pdfFontStyle, Color forecolor) {
        Font font = FontFactory.getFont(pdfFontName, pdfEncoding, isPdfEmbedded, size, ClassicFontRecipient.toITextFontStyle(pdfFontStyle), forecolor);
        if (font != null && font.getBaseFont() == null && font.getFamily() == -1) {
            font = null;
        }
        this.font = font;
    }

    @Override
    public void setFont(String pdfFontName, String pdfEncoding, boolean isPdfEmbedded, float size, PdfFontStyle pdfFontStyle, Color forecolor, byte[] fontData) {
        BaseFont baseFont;
        try {
            baseFont = BaseFont.createFont(pdfFontName, pdfEncoding, isPdfEmbedded, true, fontData, null);
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        this.font = new Font(baseFont, size, ClassicFontRecipient.toITextFontStyle(pdfFontStyle), forecolor);
    }

    protected static int toITextFontStyle(PdfFontStyle pdfFontStyle) {
        return (pdfFontStyle.isBold() ? 1 : 0) | (pdfFontStyle.isItalic() ? 2 : 0) | (pdfFontStyle.isUnderline() ? 4 : 0) | (pdfFontStyle.isStrikethrough() ? 8 : 0);
    }
}

