/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.ooxml.XlsxParagraphHelper;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxStyleInfo {
    protected int formatIndex;
    protected int fontIndex;
    protected int borderIndex;
    protected String backcolor;
    protected String horizontalAlign;
    protected String verticalAlign;
    protected boolean isWrapText = true;
    protected boolean isHidden;
    protected boolean isLocked;
    protected boolean isShrinkToFit;
    protected boolean isIgnoreTextFormatting;
    protected int rotation;
    protected boolean whitePageBackground;
    protected boolean ignoreCellBackground;
    protected boolean ignoreCellBorder;
    protected LineDirectionEnum direction;

    public XlsxStyleInfo(int formatIndex, int fontIndex, int borderIndex, JRExporterGridCell gridCell, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting, int rotation, JRXlsAbstractExporter.SheetInfo sheetInfo, LineDirectionEnum direction) {
        JRTextAlignment align;
        this.formatIndex = formatIndex;
        this.fontIndex = isIgnoreTextFormatting ? -1 : fontIndex;
        this.borderIndex = isIgnoreTextFormatting ? -1 : borderIndex;
        JRPrintElement element = gridCell.getElement();
        if (!isIgnoreTextFormatting) {
            if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
                this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
            } else if (gridCell.getBackcolor() != null) {
                this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
            }
        }
        JRTextAlignment jRTextAlignment = align = element instanceof JRTextAlignment ? (JRTextAlignment)((Object)element) : null;
        if (align != null) {
            this.horizontalAlign = this.getHorizontalAlignment(align.getHorizontalTextAlign(), align.getVerticalTextAlign(), rotation);
            this.verticalAlign = this.getVerticalAlignment(align.getHorizontalTextAlign(), align.getVerticalTextAlign(), rotation);
        }
        this.isWrapText = isShrinkToFit ? false : isWrapText;
        this.isHidden = isHidden;
        this.isLocked = isLocked;
        this.isShrinkToFit = isShrinkToFit;
        this.rotation = rotation;
        if (sheetInfo.whitePageBackground != null) {
            this.whitePageBackground = sheetInfo.whitePageBackground;
        }
        if (sheetInfo.ignoreCellBackground != null) {
            this.ignoreCellBackground = sheetInfo.ignoreCellBackground;
        }
        if (sheetInfo.ignoreCellBorder != null) {
            this.ignoreCellBorder = sheetInfo.ignoreCellBorder;
        }
        this.direction = direction;
    }

    protected String getHorizontalAlignment(HorizontalTextAlignEnum hAlign, VerticalTextAlignEnum vAlign, int rotation) {
        block0 : switch (rotation) {
            case 90: {
                switch (vAlign) {
                    case JUSTIFIED: {
                        hAlign = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        hAlign = HorizontalTextAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        hAlign = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                hAlign = HorizontalTextAlignEnum.LEFT;
                break;
            }
            case 180: {
                switch (vAlign) {
                    case JUSTIFIED: {
                        hAlign = HorizontalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case BOTTOM: {
                        hAlign = HorizontalTextAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        hAlign = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                hAlign = HorizontalTextAlignEnum.RIGHT;
                break;
            }
        }
        return XlsxParagraphHelper.getHorizontalAlignment(hAlign);
    }

    protected String getVerticalAlignment(HorizontalTextAlignEnum hAlign, VerticalTextAlignEnum vAlign, int rotation) {
        block0 : switch (rotation) {
            case 90: {
                switch (hAlign) {
                    case JUSTIFIED: {
                        vAlign = VerticalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case RIGHT: {
                        vAlign = VerticalTextAlignEnum.TOP;
                        break block0;
                    }
                    case CENTER: {
                        vAlign = VerticalTextAlignEnum.MIDDLE;
                        break block0;
                    }
                }
                vAlign = VerticalTextAlignEnum.BOTTOM;
                break;
            }
            case 180: {
                switch (hAlign) {
                    case JUSTIFIED: {
                        vAlign = VerticalTextAlignEnum.JUSTIFIED;
                        break block0;
                    }
                    case RIGHT: {
                        vAlign = VerticalTextAlignEnum.BOTTOM;
                        break block0;
                    }
                    case CENTER: {
                        vAlign = VerticalTextAlignEnum.MIDDLE;
                        break block0;
                    }
                }
                vAlign = VerticalTextAlignEnum.TOP;
                break;
            }
        }
        return XlsxParagraphHelper.getVerticalAlignment(vAlign);
    }

    public String getId() {
        return this.formatIndex + "|" + this.fontIndex + "|" + this.borderIndex + "|" + this.backcolor + "|" + this.horizontalAlign + "|" + this.verticalAlign + "|" + this.isWrapText + "|" + this.isHidden + "|" + this.isLocked + "|" + this.isShrinkToFit + "|" + this.rotation + "|" + this.whitePageBackground + "|" + this.ignoreCellBackground + "|" + this.ignoreCellBorder + "|" + this.direction;
    }
}

