/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.export.ElementKeyExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.export.JRExporterContext;

public class ElementKeyExporterFilterFactory
implements ExporterFilterFactory {
    public static final String PROPERTY_EXCLUDED_KEY_PREFIX = "exclude.key.";

    @Override
    public ExporterFilter getFilter(JRExporterContext exporterContext) throws JRException {
        JRAbstractExporter exporter;
        ElementKeyExporterFilter filter = null;
        JRAbstractExporter jRAbstractExporter = exporter = exporterContext.getExporterRef() instanceof JRAbstractExporter ? (JRAbstractExporter)exporterContext.getExporterRef() : null;
        if (exporter != null) {
            String excludeKeyPrefix = exporter.getExporterPropertiesPrefix() + PROPERTY_EXCLUDED_KEY_PREFIX;
            JRPropertiesUtil propsUtil = JRPropertiesUtil.getInstance(exporterContext.getJasperReportsContext());
            List<JRPropertiesUtil.PropertySuffix> props = propsUtil.getAllProperties(exporterContext.getExportedReport(), excludeKeyPrefix);
            if (!props.isEmpty()) {
                HashSet<String> excludedKeys = new HashSet<String>();
                for (JRPropertiesUtil.PropertySuffix prop : props) {
                    String key = prop.getValue();
                    if (key == null || key.length() == 0) {
                        key = prop.getSuffix();
                    }
                    excludedKeys.add(key);
                }
                filter = new ElementKeyExporterFilter(excludedKeys);
            }
        }
        return filter;
    }
}

