/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdk13Compiler
extends JRAbstractMultiClassCompiler {
    static final Log log = LogFactory.getLog(JRJdk13Compiler.class);
    private static final int MODERN_COMPILER_SUCCESS = 0;

    public JRJdk13Compiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public String compileClasses(File[] sourceFiles, String classpath) throws JRException {
        String[] source = new String[sourceFiles.length + 2];
        for (int i = 0; i < sourceFiles.length; ++i) {
            source[i] = sourceFiles[i].getPath();
        }
        source[sourceFiles.length] = "-classpath";
        source[sourceFiles.length + 1] = classpath;
        String errors = null;
        try {
            Class<?> clazz = JRClassLoader.loadClassForRealName("com.sun.tools.javac.Main");
            Object compiler = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                Method compileMethod = clazz.getMethod("compile", String[].class, PrintWriter.class);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int result = (Integer)compileMethod.invoke(compiler, source, new PrintWriter(baos));
                if (result != 0) {
                    errors = baos.toString();
                } else if (log.isInfoEnabled() && baos.size() > 0) {
                    log.info(baos.toString());
                }
            }
            catch (NoSuchMethodException ex) {
                Method compileMethod = clazz.getMethod("compile", String[].class);
                int result = (Integer)compileMethod.invoke(compiler, new Object[]{source});
                if (result != 0) {
                    errors = "See error messages above.";
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            StringBuilder files = new StringBuilder();
            for (int i = 0; i < sourceFiles.length; ++i) {
                files.append(sourceFiles[i].getPath());
                files.append(' ');
            }
            throw new JRException("compilers.java.source.compile.error", new Object[]{files}, e);
        }
        return errors;
    }
}

