/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.compilers.JavaScriptEvaluatorScope;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JasperReportsContextAware;
import net.sf.jasperreports.functions.FunctionsUtil;

public class JavaScriptEvaluator
extends JREvaluator
implements JasperReportsContextAware {
    public static final String PROPERTY_OPTIMIZATION_LEVEL = "net.sf.jasperreports.javascript.evaluator.optimization.level";
    public static final String EXCEPTION_MESSAGE_KEY_EVALUATOR_LOAD_ERROR = "compilers.javascript.evaluator.load.error";
    private final JasperReportsContext jrContext;
    private final JavaScriptCompileData compileData;
    private FunctionsUtil functionsUtil;
    private JavaScriptEvaluatorScope evaluatorScope;

    public JavaScriptEvaluator(JasperReportsContext jrContext, JavaScriptCompileData compileData) {
        this.jrContext = jrContext;
        this.compileData = compileData;
    }

    @Override
    public void setJasperReportsContext(JasperReportsContext context) {
        this.functionsUtil = FunctionsUtil.getInstance(context);
    }

    @Override
    protected void customizedInit(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) throws JRException {
        this.evaluatorScope = new JavaScriptEvaluatorScope(this.jrContext, this, this.functionsUtil);
        this.evaluatorScope.init(parametersMap, fieldsMap, variablesMap);
    }

    @Override
    protected Object evaluate(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getDefaultExpression());
    }

    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getEstimatedExpression());
    }

    @Override
    protected Object evaluateOld(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getOldExpression());
    }

    protected JavaScriptCompileData.Expression getExpression(int id) {
        return this.compileData.getExpression(id);
    }

    protected Object evaluateExpression(String expression) {
        return this.evaluatorScope.evaluateExpression(expression);
    }
}

