/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import net.sf.jasperreports.compilers.JavaScriptCompiledData;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.ProtectionDomainFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.optimizer.Codegen;

public class JavaScriptClassLoader
extends DefiningClassLoader {
    private static final Log log = LogFactory.getLog(JavaScriptClassLoader.class);
    public static final String EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR = "compilers.javascript.instance.error";
    public static final String EXCEPTION_MESSAGE_KEY_LOAD_ERROR = "compilers.javascript.load.error";
    private volatile ProtectionDomain protectionDomain;

    public JavaScriptClassLoader() {
        super(Codegen.class.getClassLoader());
    }

    public Script createScript(int classIndex, JavaScriptCompiledData compiledData) {
        JavaScriptCompiledData.CompiledClass compiledClass = compiledData.getCompiledClass(classIndex);
        Class<? extends Script> scriptClass = this.loadExpressionClass(compiledClass);
        try {
            Script script = scriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return script;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR, new Object[]{compiledClass.getClassName()}, e);
        }
    }

    protected synchronized Class<? extends Script> loadExpressionClass(JavaScriptCompiledData.CompiledClass compiledClass) {
        String className = compiledClass.getClassName();
        Class scriptClass = this.findLoadedClass(className);
        if (scriptClass == null) {
            if (log.isDebugEnabled()) {
                log.debug("loading script class " + className);
            }
            try {
                ProtectionDomain domain = this.getProtectionDomain();
                byte[] classBytes = compiledClass.getClassBytes();
                scriptClass = this.defineClass(className, classBytes, 0, classBytes.length, domain);
                this.linkClass(scriptClass);
            }
            catch (SecurityException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOAD_ERROR, new Object[]{className}, e);
            }
            catch (IllegalArgumentException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOAD_ERROR, new Object[]{className}, e);
            }
        }
        return scriptClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtectionDomain getProtectionDomain() {
        ProtectionDomain domain = this.protectionDomain;
        if (domain == null) {
            JavaScriptClassLoader javaScriptClassLoader = this;
            synchronized (javaScriptClassLoader) {
                domain = this.protectionDomain;
                if (domain == null) {
                    ProtectionDomainFactory protectionDomainFactory = JRClassLoader.getProtectionDomainFactory();
                    domain = this.protectionDomain = protectionDomainFactory.getProtectionDomain((ClassLoader)((Object)this));
                }
            }
        }
        return domain;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + ((Object)((Object)this)).hashCode();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (log.isDebugEnabled()) {
            log.debug("finalized " + (Object)((Object)this));
        }
    }
}

