/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.protocol.commands.Emulation;
import com.github.kklisura.cdt.protocol.commands.Log;
import com.github.kklisura.cdt.protocol.commands.Page;
import com.github.kklisura.cdt.protocol.commands.Runtime;
import com.github.kklisura.cdt.protocol.events.log.EntryAdded;
import com.github.kklisura.cdt.protocol.events.runtime.ConsoleAPICalled;
import com.github.kklisura.cdt.protocol.events.runtime.ExceptionThrown;
import com.github.kklisura.cdt.protocol.types.log.LogEntry;
import com.github.kklisura.cdt.protocol.types.page.Navigate;
import com.github.kklisura.cdt.protocol.types.runtime.ExceptionDetails;
import com.github.kklisura.cdt.protocol.types.runtime.RemoteObject;
import com.github.kklisura.cdt.services.ChromeDevToolsService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.jasperreports.chrome.ChromeInstanceHandle;
import net.sf.jasperreports.chrome.ChromePage;
import net.sf.jasperreports.chrome.ChromePageEvaluation;
import net.sf.jasperreports.chrome.ChromeServiceHandle;
import net.sf.jasperreports.chrome.IsolatedPageCreator;
import net.sf.jasperreports.chrome.PageCreator;
import net.sf.jasperreports.chrome.PageOptions;
import net.sf.jasperreports.chrome.StandardPageCreator;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.logging.LogFactory;

public class BrowserService {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(BrowserService.class);
    public static final String PROPERTY_PAGE_TIMEOUT = "net.sf.jasperreports.chrome.page.timeout";
    public static final String PROPERTY_PAGE_ISOLATE = "net.sf.jasperreports.chrome.page.isolate";
    private JRPropertiesUtil propertiesUtil;
    private ChromeServiceHandle chromeServiceHandle;

    public BrowserService(JasperReportsContext jasperReportsContext, ChromeServiceHandle chromeServiceHandle) {
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.chromeServiceHandle = chromeServiceHandle;
    }

    public <T> T evaluateInPage(String pageURL, PageOptions options, ChromePageEvaluation<T> evaluation) {
        if (log.isDebugEnabled()) {
            log.debug("page evaluation at " + pageURL);
        }
        PageCreator pageCreator = this.isolate(options) ? IsolatedPageCreator.instance() : StandardPageCreator.instance();
        ChromeInstanceHandle chromeInstance = this.chromeServiceHandle.getChromeInstance();
        Object result = pageCreator.runInPage(chromeInstance, devToolsService -> {
            try {
                Log pageLog = devToolsService.getLog();
                pageLog.onEntryAdded(this::pageLogEvent);
                pageLog.enable();
                Runtime runtime = devToolsService.getRuntime();
                runtime.onConsoleAPICalled(this::consoleEvent);
                runtime.onExceptionThrown(this::pageExceptionEvent);
                runtime.enable();
                this.setScreenDimensions(options, (ChromeDevToolsService)devToolsService);
                CompletableFuture resultFuture = new CompletableFuture();
                ChromePage chromePage = new ChromePage((ChromeDevToolsService)devToolsService);
                Page page = devToolsService.getPage();
                page.onLoadEventFired(event -> {
                    try {
                        Object evaluationResult = evaluation.runInPage(chromePage);
                        resultFuture.complete(evaluationResult);
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(e);
                    }
                });
                page.enable();
                Navigate navigate = page.navigate(pageURL);
                if (navigate.getErrorText() != null) {
                    throw new JRRuntimeException("Page failed to load: " + navigate.getErrorText());
                }
                Long timeout = this.pageTimeout(options);
                if (log.isDebugEnabled()) {
                    log.debug("waiting for result, timeout " + timeout);
                }
                Object promiseResult = timeout == null || timeout <= 0L ? resultFuture.get() : resultFuture.get(timeout, TimeUnit.MILLISECONDS);
                return promiseResult;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new JRRuntimeException(e);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("page evaluation done");
        }
        return (T)result;
    }

    protected boolean isolate(PageOptions options) {
        Boolean isolate = options == null ? null : options.getIsolate();
        return isolate == null ? this.propertiesUtil.getBooleanProperty(PROPERTY_PAGE_ISOLATE, false) : isolate.booleanValue();
    }

    protected void setScreenDimensions(PageOptions options, ChromeDevToolsService devToolsService) {
        if (options != null && (options.getScreenWidth() != null || options.getScreenHeight() != null)) {
            Emulation emulation = devToolsService.getEmulation();
            if (emulation.canEmulate().booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("setting screen dimensions " + options.getScreenWidth() + ", " + options.getScreenHeight());
                }
                emulation.setDeviceMetricsOverride(Integer.valueOf(options.getScreenWidth() != null && options.getScreenWidth() > 0 ? options.getScreenWidth() : 0), Integer.valueOf(options.getScreenHeight() != null && options.getScreenHeight() > 0 ? options.getScreenHeight() : 0), Double.valueOf(0.0), Boolean.valueOf(false));
            } else {
                log.warn("Chrome device emulation is not supported, cannot set page width and height");
            }
        }
    }

    protected Long pageTimeout(PageOptions options) {
        String timeoutProp;
        Long timeout;
        Long l = timeout = options == null ? null : options.getTimeout();
        if (timeout == null && (timeoutProp = this.propertiesUtil.getProperty(PROPERTY_PAGE_TIMEOUT)) != null && !timeoutProp.trim().isEmpty()) {
            timeout = JRPropertiesUtil.asLong(timeoutProp);
        }
        return timeout;
    }

    protected void pageLogEvent(EntryAdded event) {
        LogEntry entry = event.getEntry();
        switch (entry.getLevel()) {
            case ERROR: {
                log.error("Page error: " + entry.getText());
                break;
            }
            case WARNING: {
                log.warn("Page warning: " + entry.getText());
                break;
            }
            case INFO: {
                log.info("Page info: " + entry.getText());
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.info("Page message: " + entry.getText());
            }
        }
    }

    protected void consoleEvent(ConsoleAPICalled event) {
        if (log.isDebugEnabled()) {
            StringBuilder eventString = new StringBuilder();
            eventString.append("Page console ");
            eventString.append(event.getType());
            eventString.append(": ");
            List args = event.getArgs();
            if (args != null) {
                for (RemoteObject argObject : args) {
                    eventString.append(argObject.getValue() == null ? argObject.getUnserializableValue() : argObject.getValue());
                    eventString.append(", ");
                }
            }
            log.debug(eventString.substring(0, eventString.length() - 2));
        }
    }

    protected void pageExceptionEvent(ExceptionThrown event) {
        if (log.isWarnEnabled()) {
            ExceptionDetails exceptionDetails = event.getExceptionDetails();
            log.warn("Script exception: " + exceptionDetails.getText());
            if (log.isDebugEnabled()) {
                RemoteObject exception = exceptionDetails.getException();
                String exceptionString = null;
                if (exception != null) {
                    if (exception.getDescription() != null) {
                        exceptionString = exception.getDescription();
                    } else if (exception.getValue() != null) {
                        exceptionString = exception.getValue().toString();
                    }
                }
                if (exceptionString != null) {
                    log.debug("Exception description: " + exceptionString);
                }
            }
        }
    }
}

