/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.impexp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Locale;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public abstract class QIFBankTransaction
extends BankTransactionAbstract {
    public static final String FILE_START = "!Type:";
    public static final String END_LINE = "^";
    public static final String HEAD_TYPE_Cash = "Cash";
    public static final String HEAD_TYPE_Bank = "Bank";
    public static final String HEAD_TYPE_CCard = "CCard";
    public static final String HEAD_TYPE_Invst = "Invst";
    public static final String HEAD_TYPE_Oth_A = "Oth A";
    public static final String HEAD_TYPE_Oth_L = "Oth L";
    public static final String HEAD_TYPE_Invoice = "Invoice";
    public static final String LINE_TYPE_All_Date = "D";
    public static final String LINE_TYPE_All_Amount = "T";
    public static final String LINE_TYPE_All_Amount_U = "U";
    public static final String LINE_TYPE_All_Memo = "M";
    public static final String LINE_TYPE_All_Cleared_Status = "C";
    public static final String LINE_TYPE_Banking_Check_Number = "N";
    public static final String LINE_TYPE_Banking_Payee = "P";
    public static final String LINE_TYPE_Banking_Payee_Address = "A";
    public static final String LINE_TYPE_Banking_Category = "L";
    public static final String LINE_TYPE_Banking_Flag = "F";
    public static final String LINE_TYPE_Splits_Category = "S";
    public static final String LINE_TYPE_Splits_Memo = "E";
    public static final String LINE_TYPE_Splits_Amount = "$";
    public static final String LINE_TYPE_Splits_Percentage = "%";
    public static final String LINE_TYPE_Investment_Action = "N";
    public static final String LINE_TYPE_Investment_Name = "Y";
    public static final String LINE_TYPE_Investment_Price = "I";
    public static final String LINE_TYPE_Investment_Quantity = "Q";
    public static final String LINE_TYPE_Investment_Commission = "O";
    public static final String LINE_TYPE_Investment_Amount = "$";
    public static final String LINE_TYPE_Categories_Budgeted = "B";
    public static final String LINE_TYPE_Invoices_Extended_Data = "X";
    public static final String LINE_TYPE_Invoices_Ship_To = "XA";
    public static final String LINE_TYPE_Invoices_Trx_Type = "XI";
    public static final String LINE_TYPE_Invoices_Due_Date = "XE";
    public static final String LINE_TYPE_Invoices_Tax_Account = "XC";
    public static final String LINE_TYPE_Invoices_Tax_Rate = "XR";
    public static final String LINE_TYPE_Invoices_Tax_Amount = "XT";
    public static final String LINE_TYPE_Invoices_Line_Item_Description = "XS";
    public static final String LINE_TYPE_Invoices_Line_Item_Category = "XN";
    public static final String LINE_TYPE_Invoices_Line_Item_Quantity = "X#";
    public static final String LINE_TYPE_Invoices_Line_Item_Price = "X$";
    public static final String LINE_TYPE_Invoices_Line_Item_Taxable = "XF";
    public static String[] TYPE_AMOUNT = new String[]{"T", "U", "$", "%", "I", "Q", "O", "$", "B", "XR", "XT", "X#", "X$", "XF"};
    public static String[] TYPE_DATE = new String[]{"D", "XE"};
    public static String[] TYPE_STRING = new String[]{"M", "C", "N", "P", "A", "L", "F", "S", "E", "N", "Y", "X", "XA", "XI", "XC", "XS", "XN"};
    private String type;

    public abstract Locale getLocale();

    public abstract String getDatePattern();

    public abstract String getDecimalPattern();

    public abstract String getDecimalSeparator();

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty(line = this.processValue(line))) {
            return;
        }
        int index = 0;
        if (line.startsWith(FILE_START) && this.type != null) {
            index = line.indexOf(FILE_START) + FILE_START.length();
            this.setFileType(line.substring(index));
            return;
        }
        for (String prefix : TYPE_AMOUNT) {
            if (!line.startsWith(prefix)) continue;
            index = line.indexOf(prefix) + prefix.length();
            this.addValue(prefix, this.getNumber(this.getDecimalSeparator().charAt(0), this.getDecimalPattern(), line.substring(index)));
            return;
        }
        for (String prefix : TYPE_DATE) {
            if (!line.startsWith(prefix)) continue;
            index = line.indexOf(prefix) + prefix.length();
            this.addValue(prefix, this.getDate(this.getDatePattern(), line.substring(index)));
            return;
        }
        for (String prefix : TYPE_STRING) {
            if (!line.startsWith(prefix)) continue;
            index = line.indexOf(prefix) + prefix.length();
            this.addValue(prefix, line.substring(index));
            return;
        }
    }

    @Override
    public boolean isEndTransactionLine(String line) {
        if (Util.isEmpty(line)) {
            return false;
        }
        return line.trim().startsWith(END_LINE);
    }

    protected void setFileType(String type) {
        this.type = type;
    }

    protected String getFileType() {
        return this.type;
    }

    @Override
    public Timestamp getTrxDate() {
        return this.getDate(LINE_TYPE_All_Date);
    }

    @Override
    public BigDecimal getAmount() {
        return this.getNumber(LINE_TYPE_All_Amount);
    }

    @Override
    public String getPayeeAccountNo() {
        return this.getString(LINE_TYPE_Banking_Payee);
    }

    @Override
    public String getMemo() {
        return this.getString(LINE_TYPE_All_Memo);
    }

    @Override
    public String getTrxType() {
        return this.getString(LINE_TYPE_Banking_Category);
    }

    @Override
    public String getCheckNo() {
        return this.getReferenceNo();
    }

    @Override
    public String getReferenceNo() {
        return this.getString("N");
    }

    @Override
    protected abstract String processValue(String var1);

    @Override
    public Timestamp getValueDate() {
        return this.getDate(LINE_TYPE_All_Date);
    }

    @Override
    public Timestamp getStatementDate() {
        return this.getDate(LINE_TYPE_All_Date);
    }

    @Override
    public String getCurrency() {
        return null;
    }

    @Override
    public String getTrxCode() {
        return this.getString(LINE_TYPE_Banking_Category);
    }
}

