/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.impexp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class MT940BankTransaction
extends BankTransactionAbstract {
    public static final String HEAD_STATEMENT_DATE = ":20:";
    public static final String HEAD_IBAN = ":25:";
    public static final String HEAD_STATEMENT_NUMBER = ":25C:";
    public static final String HEAD_ACCOUNT_OWNER_NAME = ":NS:22";
    public static final String HEAD_ACCOUNT_NAME = ":NS:23";
    public static final String HEAD_OPENING_BALANCE = ":60F:";
    public static final String HEAD_OPENING_BALANCE_Type = ":60F:T|ype";
    public static final String HEAD_OPENING_BALANCE_Date = ":60F:|Date";
    public static final String HEAD_OPENING_BALANCE_Currency = ":60F:|Currency";
    public static final String HEAD_OPENING_BALANCE_Amount = ":60F:|Amount";
    public static final String LINE_TRANSACTION = ":61:";
    public static final String LINE_TRANSACTION_Value_Date = ":61:|ValueDate";
    public static final String LINE_TRANSACTION_Booking_Date = ":61:|BookingDate";
    public static final String LINE_TRANSACTION_Type = ":61:|Type";
    public static final String LINE_TRANSACTION_Currency_Char = ":61:|CurrencyChar";
    public static final String LINE_TRANSACTION_Amount = ":61:|Amount";
    public static final String LINE_TRANSACTION_Fixed_Value = ":61:|FixedValue";
    public static final String LINE_TRANSACTION_NMSCNONREF = "NMSCNONREF//";
    public static final String LINE_BOOKING_TIME = ":NS:19";
    public static final String LINE_TRANSACTION_DETAIL = ":86:";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Code = ":86:|TransactionCode";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Type = ":86:|TransactionType";
    public static final String LINE_TRANSACTION_DETAIL_Sequence_Number = ":86:|SequenceNumber";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title = ":86:|TransactionTitle";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title1 = ":86:|TransactionTitle1";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title2 = ":86:|TransactionTitle2";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title3 = ":86:|TransactionTitle3";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title4 = ":86:|TransactionTitle4";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title5 = ":86:|TransactionTitle5";
    public static final String LINE_TRANSACTION_DETAIL_Transaction_Title6 = ":86:|TransactionTitle6";
    public static final String LINE_TRANSACTION_DETAIL_Counterparty_Address = ":86:|CounterpartyAddress";
    public static final String LINE_TRANSACTION_DETAIL_Counterparty_Address1 = ":86:|CounterpartyAddress1";
    public static final String LINE_TRANSACTION_DETAIL_Counterparty_Address2 = ":86:|CounterpartyAddress2";
    public static final String LINE_TRANSACTION_DETAIL_Technical_Field = ":86:|TechnicalField";
    public static final String LINE_TRANSACTION_DETAIL_Technical_Field1 = ":86:|TechnicalField1";
    public static final String LINE_TRANSACTION_DETAIL_Technical_Field2 = ":86:|TechnicalField2";
    public static final String LINE_TRANSACTION_DETAIL_Technical_Field3 = ":86:|TechnicalField3";
    public static final String LINE_TRANSACTION_DETAIL_Counterparty_Account = ":86:|CounterpartyAccount";
    public static final String LINE_TRANSACTION_DETAIL_Counterparty_Account1 = ":86:|CounterpartyAccount1";
    public static final String LINE_TRANSACTION_DETAIL_Reconciliation_Code = ":86:|ReconciliationCode";
    public static final String LINE_TRANSACTION_DETAIL_Reconciliation_Code1 = ":86:|ReconciliationCode1";
    public static final String LINE_TRANSACTION_DETAIL_Reference_Number = ":86:|ReferenceNumber";
    public static final String LINE_TRANSACTION_DETAIL_Reconciliation_Code2 = ":86:|ReferenceNumber1";
    public static final String LINE_CLOSING_BALANCE = ":62F:";
    public static final String LINE_CLOSING_BALANCE_Type = ":62F:|Type";
    public static final String LINE_CLOSING_BALANCE_Date = ":62F:|Date";
    public static final String LINE_CLOSING_BALANCE_Currency = ":62F:|Currency";
    public static final String LINE_CLOSING_BALANCE_Amount = ":62F:|Amount";
    public static final String LINE_AVAILABLE_BALANCE = ":64:";
    public static final String LINE_AVAILABLE_BALANCE_Type = ":64:|Type";
    public static final String LINE_AVAILABLE_BALANCE_Date = ":64:|Date";
    public static final String LINE_AVAILABLE_BALANCE_Currency = ":64:|Currency";
    public static final String LINE_AVAILABLE_BALANCE_Amount = ":64:|Amount";
    public static final String LINE_TYPE_ADDITIONAL_INFORMATION = ":86:";
    public static final String DEBT = "D";
    public static final String CREDIT = "C";
    public static String[] TAGS = new String[]{":20:", ":25:", ":25C:", ":NS:22", ":NS:23", ":60F:", ":61:", ":NS:19", ":86:", ":62F:", ":64:", ":86:"};

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty(line = this.processValue(line))) {
            return;
        }
        int index = 0;
        for (String prefix : TAGS) {
            if (!line.startsWith(prefix)) continue;
            index = line.indexOf(prefix) + prefix.length();
            this.setValue(prefix, line.substring(index));
            return;
        }
    }

    protected void setValue(String key, String value) throws ParseException {
        if (!HEAD_STATEMENT_DATE.equals(key)) {
            if (HEAD_IBAN.equals(key)) {
                this.addValue(key, value);
            } else if (HEAD_STATEMENT_NUMBER.equals(key)) {
                this.addValue(key, this.getNumber('.', "#####", value));
            } else if (HEAD_ACCOUNT_OWNER_NAME.equals(key)) {
                this.addValue(key, this.subString(value, 0, 35));
            } else if (HEAD_ACCOUNT_NAME.equals(key)) {
                this.addValue(key, this.subString(value, 0, 35));
            } else if (HEAD_OPENING_BALANCE.equals(key)) {
                int index = 0;
                this.addValue(HEAD_OPENING_BALANCE_Type, this.subString(value, index++, index));
                this.addValue(HEAD_OPENING_BALANCE_Date, this.getDate("yyMMdd", this.subString(value, index, index += 6)));
                this.addValue(HEAD_OPENING_BALANCE_Currency, this.subString(value, index, index += 3));
                this.addValue(HEAD_OPENING_BALANCE_Amount, this.getNumber(',', "########.##", this.subString(value, index, value.length())));
            } else if (LINE_TRANSACTION.equals(key)) {
                int index = 0;
                this.addValue(LINE_TRANSACTION_Value_Date, this.getDate("yyMMdd", this.subString(value, index, index += 6)));
                this.addValue(LINE_TRANSACTION_Booking_Date, this.getDate("MMdd", this.subString(value, index, index += 4)));
                this.addValue(LINE_TRANSACTION_Type, this.subString(value, index++, index));
                this.addValue(LINE_TRANSACTION_Amount, this.getNumber(',', "########.##", this.subString(value, index, index += 10)));
                this.addValue(LINE_TRANSACTION_DETAIL_Reference_Number, this.subString(value, index += 12, index += 11));
            } else if (LINE_BOOKING_TIME.equals(key)) {
                this.addValue(LINE_BOOKING_TIME, this.getDate("hhmm", this.subString(value, 0, 4)));
            } else if (":86:".equals(key)) {
                int index = 0;
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Code, this.subString(value, index, index += 3));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Type, this.subString(value, index++, index));
                this.addValue(LINE_TRANSACTION_DETAIL_Sequence_Number, this.subString(value, index, index += 16));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title, this.subString(value, index += 3, index += 40));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title1, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title2, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title3, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title4, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title5, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Transaction_Title6, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Counterparty_Address, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Counterparty_Address1, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Counterparty_Address2, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Technical_Field, this.subString(value, index, index += 10));
                this.addValue(LINE_TRANSACTION_DETAIL_Technical_Field1, this.subString(value, index, index += 24));
                this.addValue(LINE_TRANSACTION_DETAIL_Technical_Field2, this.subString(value, index, index += 27));
                this.addValue(LINE_TRANSACTION_DETAIL_Technical_Field3, this.subString(value, index, index += 27));
                this.addValue(LINE_TRANSACTION_DETAIL_Counterparty_Account, this.subString(value, index, index += 34));
                this.addValue(LINE_TRANSACTION_DETAIL_Counterparty_Address, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Reconciliation_Code, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Reconciliation_Code1, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Reference_Number, this.subString(value, index, index += 35));
                this.addValue(LINE_TRANSACTION_DETAIL_Reconciliation_Code2, this.subString(value, index, index += 35));
            } else if (LINE_CLOSING_BALANCE.equals(key)) {
                int index = 0;
                this.addValue(LINE_CLOSING_BALANCE_Type, this.subString(value, index++, index));
                this.addValue(LINE_CLOSING_BALANCE_Date, this.getDate("yyMMdd", this.subString(value, index, index += 6)));
                this.addValue(LINE_CLOSING_BALANCE_Currency, this.subString(value, index, index += 3));
                this.addValue(LINE_CLOSING_BALANCE_Amount, this.getNumber(',', "########.##", this.subString(value, index, value.length())));
            } else if (LINE_AVAILABLE_BALANCE.equals(key)) {
                int index = 0;
                this.addValue(LINE_AVAILABLE_BALANCE_Type, this.subString(value, index++, index));
                this.addValue(LINE_AVAILABLE_BALANCE_Date, this.getDate("yyMMdd", this.subString(value, index, index += 6)));
                this.addValue(LINE_AVAILABLE_BALANCE_Currency, this.subString(value, index, index += 3));
                this.addValue(LINE_AVAILABLE_BALANCE_Amount, this.getNumber(',', "########.##", this.subString(value, index, value.length())));
            } else if (":86:".equals(key)) {
                this.addValue(":86:", this.subString(value, 0, 65));
            }
        }
    }

    @Override
    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Value_Date);
    }

    @Override
    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    @Override
    public String getPayeeAccountNo() {
        return this.getString(LINE_TRANSACTION_DETAIL_Counterparty_Account);
    }

    @Override
    public String getMemo() {
        return this.getString(LINE_TRANSACTION_DETAIL_Transaction_Title);
    }

    @Override
    public String getTrxType() {
        return this.getString(LINE_TRANSACTION_Type);
    }

    @Override
    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_DETAIL_Reference_Number);
    }

    @Override
    protected String processValue(String value) {
        return value.replaceAll("[\t+^&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$><]", "");
    }

    @Override
    public boolean isEndTransactionLine(String line) {
        return line.startsWith(":86:");
    }

    @Override
    public boolean isCompleteData() {
        return true;
    }

    @Override
    public String getCurrency() {
        return this.getString(HEAD_OPENING_BALANCE_Currency);
    }

    @Override
    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Value_Date);
    }

    @Override
    public Timestamp getStatementDate() {
        return this.getDate(HEAD_STATEMENT_DATE);
    }

    @Override
    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_DETAIL_Reference_Number);
    }

    @Override
    public String getTrxCode() {
        return this.getString(LINE_TRANSACTION_DETAIL_Transaction_Code);
    }

    @Override
    public String getPayeeName() {
        return this.getString(LINE_TRANSACTION_DETAIL_Counterparty_Address);
    }

    @Override
    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_DETAIL_Counterparty_Address1);
    }
}

