/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.impexp;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.impexp.BankStatementLoaderInterface;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatementLoader;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.util.impexp.BankTransactionAbstract;
import org.spin.util.impexp.GenericQIFBankTransaction;

public class BankStatementHandler
implements BankStatementLoaderInterface {
    private MBankStatementLoader controller = null;
    private List<BankTransactionAbstract> transactionList = new ArrayList<BankTransactionAbstract>();
    private BankTransactionAbstract bankTransaction = null;
    private MBankAccount bankAccount = null;
    private String lastError = null;
    private CLogger log = CLogger.getCLogger(BankStatementHandler.class);

    @Override
    public boolean init(MBankStatementLoader controller) {
        if (controller == null) {
            throw new AdempiereException("@C_BankStatementLoader_ID@ @NotFoud@");
        }
        this.controller = controller;
        this.bankAccount = MBankAccount.get(controller.getCtx(), controller.getC_BankAccount_ID());
        return controller.getLocalFileName() != null;
    }

    @Override
    public boolean isValid() {
        return this.controller.getLocalFileName() != null;
    }

    @Override
    public boolean loadLines() {
        try {
            FileInputStream stream = null;
            if (this.controller.getLocalFileName() != null) {
                stream = new FileInputStream(this.controller.getLocalFileName());
            } else if (this.controller.getFileName() != null) {
                stream = new FileInputStream(this.controller.getFileName());
            }
            return this.readFile(new BufferedReader(new InputStreamReader(stream)));
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    private boolean readFile(BufferedReader reader) {
        try {
            String line = null;
            this.bankTransaction = this.getBankTransactionInstance();
            while ((line = reader.readLine()) != null) {
                this.bankTransaction.parseLine(line, this.bankAccount);
                if (!this.bankTransaction.isEndTransactionLine(line)) continue;
                if (this.bankTransaction.isCompleteData()) {
                    this.transactionList.add(this.bankTransaction);
                    if (!this.controller.saveLine()) {
                        this.log.severe("Bank Statement Loader Error: " + this.controller.getErrorMessage());
                    }
                }
                this.bankTransaction = this.getBankTransactionInstance();
            }
            reader.close();
        }
        catch (Exception e) {
            throw new AdempiereException("@ReadError@: " + e.getLocalizedMessage());
        }
        return this.transactionList.size() > 0;
    }

    protected BankTransactionAbstract getBankTransactionInstance() {
        return new GenericQIFBankTransaction();
    }

    @Override
    public String getLastErrorMessage() {
        return this.lastError;
    }

    @Override
    public String getLastErrorDescription() {
        return null;
    }

    @Override
    public Timestamp getDateLastRun() {
        return new Timestamp(System.currentTimeMillis());
    }

    @Override
    public String getRoutingNo() {
        return this.bankAccount.getC_Bank().getRoutingNo();
    }

    @Override
    public String getBankAccountNo() {
        return this.bankAccount.getAccountNo();
    }

    @Override
    public String getStatementReference() {
        return null;
    }

    @Override
    public Timestamp getStatementDate() {
        return new Timestamp(System.currentTimeMillis());
    }

    @Override
    public String getTrxID() {
        return this.bankTransaction.getCheckNo();
    }

    @Override
    public String getReference() {
        return this.bankTransaction.getCheckNo();
    }

    @Override
    public String getCheckNo() {
        return this.bankTransaction.getCheckNo();
    }

    @Override
    public String getPayeeName() {
        return this.bankTransaction.getPayeeName();
    }

    @Override
    public String getPayeeAccountNo() {
        return this.bankTransaction.getPayeeAccountNo();
    }

    @Override
    public Timestamp getStatementLineDate() {
        return this.bankTransaction.getTrxDate();
    }

    @Override
    public Timestamp getValutaDate() {
        return this.bankTransaction.getValueDate();
    }

    @Override
    public String getTrxType() {
        return this.bankTransaction.getTrxType();
    }

    @Override
    public boolean getIsReversal() {
        return false;
    }

    @Override
    public String getCurrency() {
        return this.bankTransaction.getCurrency();
    }

    @Override
    public BigDecimal getStmtAmt() {
        return this.bankTransaction.getAmount();
    }

    @Override
    public BigDecimal getTrxAmt() {
        return this.bankTransaction.getAmount();
    }

    @Override
    public BigDecimal getInterestAmt() {
        return Env.ZERO;
    }

    @Override
    public String getMemo() {
        return this.bankTransaction.getMemo();
    }

    @Override
    public String getChargeName() {
        return this.bankTransaction.getMemo();
    }

    @Override
    public BigDecimal getChargeAmt() {
        return Env.ZERO;
    }

    @Override
    public String getBPartnerValue() {
        return this.bankTransaction.getBPartnerValue();
    }

    @Override
    public int getBPartnerID() {
        return this.bankTransaction.getBPartnerID();
    }

    @Override
    public String getPayeeDescription() {
        return this.bankTransaction.getPayeeDescription();
    }
}

