/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;
import org.spin.model.MADSetupDefinition;
import org.spin.util.ISetupDefinition;

public class SetupUtil {
    public static ISetupDefinition getSetupHandler(Properties context, int setupDefinitionId, String transactionName) {
        if (setupDefinitionId <= 0) {
            throw new AdempiereException("@AD_SetupDefinition_ID@ @NotFound@");
        }
        MADSetupDefinition definition = new MADSetupDefinition(context, setupDefinitionId, transactionName);
        if (Util.isEmpty(definition.getClassname())) {
            throw new AdempiereException("@Classname@ @NotFound@");
        }
        return SetupUtil.getInstance(definition.getClassname());
    }

    private static ISetupDefinition getInstance(String className) {
        if (Util.isEmpty(className)) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (!ISetupDefinition.class.isAssignableFrom(clazz)) {
                for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null && superClazz != ISetupDefinition.class; superClazz = superClazz.getSuperclass()) {
                }
            }
            if (clazz != null) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                return (ISetupDefinition)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return null;
    }
}

