/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MColor;
import org.compiere.model.MImage;
import org.compiere.plaf.CompiereColor;

public class ColorUtil {
    public static CompiereColor getColor(Properties context, int colorId) {
        if (colorId == 0) {
            return null;
        }
        MColor mc = new MColor(context, colorId, null);
        return ColorUtil.getAdempiereColor(mc);
    }

    public static CompiereColor getAdempiereColor(MColor color) {
        if (color.get_ID() == 0) {
            return null;
        }
        String ColorType = color.getColorType();
        if (ColorType == null) {
            return null;
        }
        CompiereColor cc = null;
        if (ColorType.equals("F")) {
            cc = new CompiereColor(ColorUtil.getColor(color, true), true);
        } else if (ColorType.equals("G")) {
            int RepeatDistance = color.getRepeatDistance();
            String StartPoint = color.getStartPoint();
            int startPoint = StartPoint == null ? 0 : Integer.parseInt(StartPoint);
            cc = new CompiereColor(ColorUtil.getColor(color, true), ColorUtil.getColor(color, false), startPoint, RepeatDistance);
        } else if (ColorType.equals("L")) {
            int LineWidth = color.getLineWidth();
            int LineDistance = color.getLineDistance();
            cc = new CompiereColor(ColorUtil.getColor(color, false), ColorUtil.getColor(color, true), LineWidth, LineDistance);
        } else if (ColorType.equals("T")) {
            int AD_Image_ID = color.getAD_Image_ID();
            String url = ColorUtil.getURL(color, AD_Image_ID);
            if (url == null) {
                return null;
            }
            BigDecimal ImageAlpha = color.getImageAlpha();
            float compositeAlpha = ImageAlpha == null ? 0.7f : ImageAlpha.floatValue();
            cc = new CompiereColor(url, ColorUtil.getColor(color, true), compositeAlpha);
        }
        return cc;
    }

    private static Color getColor(MColor color, boolean primary) {
        int red = primary ? color.getRed() : color.getRed_1();
        int green = primary ? color.getGreen() : color.getGreen_1();
        int blue = primary ? color.getBlue() : color.getBlue_1();
        return new Color(red, green, blue);
    }

    private static String getURL(MColor color, int AD_Image_ID) {
        if (AD_Image_ID == 0) {
            return null;
        }
        return MImage.get(color.getCtx(), AD_Image_ID, null).getImageURL();
    }
}

