/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClientInfo;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAttachmentReference;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;
import org.spin.util.support.webdav.IWebDav;

public class AttachmentUtil {
    private static AttachmentUtil instance = null;
    private int clientId;
    private Properties context;
    private IWebDav fileHandler;
    private int fileHandlerId;
    private String fileName;
    private byte[] data;
    private String note;
    private String description;
    private int attachmentId;
    private int attachmentReferenceId;
    private int imageId;
    private int archiveId;
    private String transactionName;
    private String baseFolder;
    private String imageFolder;
    private String attachmentFolder;
    private String archiveFolder;
    private String tmpFolder;
    private final String BASE_FOLDER_PARAMETER = "BaseFolder";
    private final String IMAGE_FOLDER_PARAMETER = "ImageFolder";
    private final String ATTACHMENT_FOLDER_PARAMETER = "AttachmentFolder";
    private final String ARCHIVE_FOLDER_PARAMETER = "ArchiveFolder";
    private final String TMP_FOLDER_PARAMETER = "TmpFolder";

    private AttachmentUtil(Properties context) {
        if (context == null) {
            throw new AdempiereException("@ContextIsMandatory@");
        }
        this.context = context;
        this.clientId = Env.getAD_Client_ID(context);
    }

    public static AttachmentUtil getInstance(Properties context) {
        if (instance == null) {
            instance = new AttachmentUtil(context);
        }
        return instance;
    }

    public static AttachmentUtil getInstance() {
        return AttachmentUtil.getInstance(Env.getCtx());
    }

    public AttachmentUtil withFileHandlerId(int fileHandlerId) {
        this.fileHandlerId = fileHandlerId;
        this.fileHandler = null;
        return this;
    }

    public boolean isValidForClient(int clientId) {
        MClientInfo clientInfo = MClientInfo.get(this.context, clientId, this.transactionName);
        return clientInfo.getFileHandler_ID() > 0;
    }

    public AttachmentUtil withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getFileName() {
        return this.getValidFileName(this.fileName);
    }

    private String getValidFileName(String fileName) {
        if (Util.isEmpty(fileName)) {
            return fileName;
        }
        int index = fileName.lastIndexOf("/");
        if (index == -1) {
            index = fileName.lastIndexOf("\\");
        }
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        return fileName.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><]", "").replaceAll(" ", "-");
    }

    public AttachmentUtil withData(byte[] data) {
        this.data = data;
        return this;
    }

    public AttachmentUtil withClientId(int clientId) {
        this.clientId = clientId;
        this.fileHandlerId = 0;
        this.fileHandler = null;
        return this;
    }

    public AttachmentUtil withNote(String note) {
        this.note = note;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public AttachmentUtil withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AttachmentUtil withTansactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public AttachmentUtil withAttachmentId(int attahcmentId) {
        this.attachmentId = attahcmentId;
        this.imageId = 0;
        this.archiveId = 0;
        this.attachmentReferenceId = 0;
        return this;
    }

    public AttachmentUtil withAttachmentReferenceId(int attachmentReferenceId) {
        this.attachmentReferenceId = attachmentReferenceId;
        this.attachmentId = 0;
        this.imageId = 0;
        this.archiveId = 0;
        return this;
    }

    public AttachmentUtil withImageId(int imageId) {
        this.imageId = imageId;
        this.archiveId = 0;
        this.attachmentId = 0;
        this.attachmentReferenceId = 0;
        return this;
    }

    public AttachmentUtil withArchiveId(int archiveId) {
        this.archiveId = archiveId;
        this.imageId = 0;
        this.attachmentId = 0;
        this.attachmentReferenceId = 0;
        return this;
    }

    public AttachmentUtil clear() {
        this.archiveId = 0;
        this.imageId = 0;
        this.attachmentId = 0;
        this.attachmentReferenceId = 0;
        this.fileName = null;
        this.description = null;
        this.note = null;
        this.transactionName = null;
        this.fileHandlerId = 0;
        this.fileHandler = null;
        return this;
    }

    private MADAttachmentReference getAttachmentReference() {
        MADAttachmentReference attachmentReference = null;
        if (this.attachmentReferenceId > 0) {
            attachmentReference = MADAttachmentReference.getById(this.context, this.attachmentReferenceId, this.transactionName);
        } else if (this.attachmentId > 0) {
            attachmentReference = MADAttachmentReference.getByAttachmentId(this.context, this.fileHandlerId, this.attachmentId, this.getFileName(), this.transactionName);
        } else if (this.imageId > 0) {
            attachmentReference = MADAttachmentReference.getByImageId(this.context, this.fileHandlerId, this.imageId, this.transactionName);
        } else if (this.archiveId > 0) {
            attachmentReference = MADAttachmentReference.getByArchiveId(this.context, this.fileHandlerId, this.archiveId, this.transactionName);
        }
        return attachmentReference;
    }

    public byte[] getAttachment() throws Exception {
        IWebDav handler = this.getFileHandler();
        MADAttachmentReference attachmentReference = this.getAttachmentReference();
        if (attachmentReference == null) {
            throw new AdempiereException("@AD_AttachmentReference_ID@ @NotFound@");
        }
        this.fileName = attachmentReference.getFileName();
        this.description = attachmentReference.getDescription();
        this.note = attachmentReference.getTextMsg();
        InputStream inputStream = handler.getResource(this.getCompleteFileName(attachmentReference));
        if (inputStream == null) {
            throw new AdempiereException("@FileName@ @NotFound@");
        }
        return this.readBytesFromAttachment(inputStream);
    }

    public List<String> getFileNameListFromAttachment() {
        try {
            this.getFileHandler();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        List<MADAttachmentReference> list = MADAttachmentReference.getListByAttachmentId(this.context, this.fileHandlerId, this.attachmentId, this.transactionName);
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (list != null) {
            list.stream().forEach(attachmentReference -> fileNameList.add(attachmentReference.getFileName()));
        }
        return fileNameList;
    }

    private byte[] readBytesFromAttachment(InputStream stream) throws Exception {
        if (stream == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream attachmentToWrite = new ByteArrayOutputStream();
        boolean error = false;
        try {
            int numRead = 0;
            while ((numRead = stream.read(buffer)) > -1) {
                attachmentToWrite.write(buffer, 0, numRead);
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            block12: {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    if (error) break block12;
                    throw e;
                }
            }
        }
        attachmentToWrite.flush();
        return attachmentToWrite.toByteArray();
    }

    public void saveAttachment() throws Exception {
        IWebDav handler = this.getFileHandler();
        MADAttachmentReference attachmentReference = this.getAttachmentReference();
        if (attachmentReference == null || attachmentReference.getAD_AttachmentReference_ID() <= 0) {
            attachmentReference = new MADAttachmentReference(this.context, 0, this.transactionName);
        }
        try {
            attachmentReference.setFileHandler_ID(this.fileHandlerId);
            attachmentReference.setFileName(this.getFileName());
            if (this.attachmentId > 0) {
                attachmentReference.setAD_Attachment_ID(this.attachmentId);
            }
            if (this.imageId > 0) {
                attachmentReference.setAD_Image_ID(this.imageId);
            }
            if (this.archiveId > 0) {
                attachmentReference.setAD_Archive_ID(this.archiveId);
            }
            if (!Util.isEmpty(this.note)) {
                attachmentReference.setTextMsg(this.note);
            }
            if (!Util.isEmpty(this.description)) {
                attachmentReference.setDescription(this.description);
            }
            attachmentReference.saveEx();
            MADAttachmentReference.resetAttachmentCacheFromId(this.fileHandlerId, this.attachmentId);
            if (this.data == null) {
                return;
            }
            attachmentReference.setFileSize(new BigDecimal(this.data.length));
            attachmentReference.saveEx();
            String validForlder = this.getValidFolder(attachmentReference);
            if (!Util.isEmpty(this.baseFolder) && !handler.exists(this.baseFolder)) {
                handler.createDirectory(this.baseFolder);
            }
            if (!Util.isEmpty(validForlder) && !handler.exists(validForlder)) {
                handler.createDirectory(validForlder);
            }
            handler.putResource(this.getCompleteFileName(attachmentReference), this.data);
        }
        catch (Exception e) {
            if (attachmentReference.getAD_AttachmentReference_ID() > 0) {
                attachmentReference.deleteEx(true);
            }
            throw new AdempiereException(e);
        }
    }

    public void deleteAttachment() throws Exception {
        IWebDav handler = this.getFileHandler();
        MADAttachmentReference attachmentReference = this.getAttachmentReference();
        if (attachmentReference == null || attachmentReference.getAD_AttachmentReference_ID() <= 0) {
            return;
        }
        try {
            handler.deleteResource(this.getCompleteFileName(attachmentReference));
            MADAttachmentReference.resetAttachmentReferenceCache(this.fileHandlerId, attachmentReference);
            attachmentReference.deleteEx(true);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private String getCompleteFileName(MADAttachmentReference attachmentReference) {
        String fileName = attachmentReference.getValidFileName();
        String validForlder = this.getValidFolder(attachmentReference);
        String completePath = fileName;
        if (!Util.isEmpty(validForlder)) {
            completePath = this.addSubFolder(validForlder, fileName);
        }
        return completePath;
    }

    private String getValidFolder(MADAttachmentReference attachmentReference) {
        String validForlder = "";
        if (attachmentReference.getAD_Attachment_ID() > 0) {
            validForlder = this.addSubFolder(this.baseFolder, this.attachmentFolder);
        } else if (attachmentReference.getAD_Image_ID() > 0) {
            validForlder = this.addSubFolder(this.baseFolder, this.imageFolder);
        } else if (attachmentReference.getAD_Archive_ID() > 0) {
            validForlder = this.addSubFolder(this.baseFolder, this.archiveFolder);
        }
        if (Util.isEmpty(validForlder)) {
            validForlder = "";
        }
        return validForlder;
    }

    private String addSubFolder(String baseFolder, String subFolder) {
        Object completePath = "";
        if (!Util.isEmpty(baseFolder)) {
            completePath = baseFolder;
        }
        completePath = !Util.isEmpty((String)completePath) ? (String)completePath + "/" + subFolder : subFolder;
        return completePath;
    }

    private MADAppRegistration getFileHandlerFromClient() {
        MClientInfo clientInfo = MClientInfo.get(this.context, this.clientId, this.transactionName);
        this.fileHandlerId = clientInfo.getFileHandler_ID();
        return MADAppRegistration.getById(this.context, this.fileHandlerId, this.transactionName);
    }

    private IWebDav getFileHandler() throws Exception {
        if (this.fileHandler != null) {
            return this.fileHandler;
        }
        MADAppRegistration registration = null;
        if (this.fileHandlerId > 0) {
            registration = MADAppRegistration.getById(this.context, this.fileHandlerId, this.transactionName);
        } else if (this.clientId > 0 && this.isValidForClient(this.clientId)) {
            registration = this.getFileHandlerFromClient();
        }
        if (registration == null) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        this.processFolder(registration);
        IAppSupport supportedApi = AppSupportHandler.getInstance().getAppSupport(MADAppRegistration.getById(this.context, this.fileHandlerId, this.transactionName));
        if (supportedApi == null) {
            throw new AdempiereException("@AD_AppSupport_ID@ @NotFound@");
        }
        if (!(supportedApi instanceof IWebDav)) {
            throw new AdempiereException("@AD_AppSupport_ID@ @Unsupported@");
        }
        this.fileHandler = (IWebDav)supportedApi;
        return this.fileHandler;
    }

    private void processFolder(MADAppRegistration registration) {
        this.baseFolder = this.getValidFolder(registration.getParameterValue("BaseFolder"));
        this.imageFolder = this.getValidFolder(registration.getParameterValue("ImageFolder"));
        if (Util.isEmpty(this.imageFolder)) {
            this.imageFolder = "Images";
        }
        this.attachmentFolder = this.getValidFolder(registration.getParameterValue("AttachmentFolder"));
        if (Util.isEmpty(this.attachmentFolder)) {
            this.attachmentFolder = "Attachments";
        }
        this.archiveFolder = this.getValidFolder(registration.getParameterValue("ArchiveFolder"));
        if (Util.isEmpty(this.archiveFolder)) {
            this.archiveFolder = "Archives";
        }
        this.tmpFolder = this.getValidFolder(registration.getParameterValue("TmpFolder"));
        if (Util.isEmpty(this.tmpFolder)) {
            this.tmpFolder = "Tmp";
        }
    }

    private String getValidFolder(String folder) {
        if (Util.isEmpty(folder)) {
            folder = "";
        } else if (folder.endsWith("/")) {
            folder.substring(0, folder.length() - 1);
        }
        return folder;
    }
}

