/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tar.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_ShiftSchedule;
import org.compiere.model.Query;
import org.compiere.util.CCache;

public class MHRShiftSchedule
extends X_HR_ShiftSchedule {
    private static final long serialVersionUID = 1396860053067383823L;
    private static CCache<String, MHRShiftSchedule> shiftScheduleCache = new CCache("HR_ShiftSchedule", 1000);

    public MHRShiftSchedule(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRShiftSchedule(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MHRShiftSchedule getScheduleFromWorkGroup(Properties properties, int n, Timestamp timestamp, String string) {
        String string2 = n + "|" + new SimpleDateFormat("yyyyMMdd").format(timestamp);
        MHRShiftSchedule mHRShiftSchedule = shiftScheduleCache.get(string2);
        if (mHRShiftSchedule == null) {
            mHRShiftSchedule = (MHRShiftSchedule)new Query(properties, "HR_ShiftSchedule", "HR_WorkGroup_ID = ? AND EXISTS(SELECT 1 \t\t\t\t\tFROM HR_Period p \t\t\t\t\tWHERE p.HR_Period_ID = HR_ShiftSchedule.HR_Period_ID \t\t\t\t\tAND ? BETWEEN p.StartDate AND p.EndDate)", string).setParameters(n, timestamp).setClient_ID().setOnlyActiveRecords(true).first();
        }
        if (mHRShiftSchedule != null) {
            shiftScheduleCache.put(string2, mHRShiftSchedule);
        }
        return mHRShiftSchedule;
    }

    @Override
    public String toString() {
        return "MHRShiftSchedule [getDescription()=" + this.getDescription() + ", getHR_Period_ID()=" + this.getHR_Period_ID() + ", getHR_ShiftSchedule_ID()=" + this.getHR_ShiftSchedule_ID() + ", getHR_WorkGroup_ID()=" + this.getHR_WorkGroup_ID() + ", getHR_WorkShift_ID()=" + this.getHR_WorkShift_ID() + "]";
    }
}

