/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util.support.elasticsearch;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClientInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorage;
import org.compiere.model.MStore;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.spin.model.MADAttachmentReference;
import org.spin.store.model.MWCategory;
import org.spin.store.util.support.elasticsearch.Category;
import org.spin.store.util.support.elasticsearch.ElasticSearch;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;

public class Product
implements IPersistenceWrapper {
    Map<String, Object> map = new HashMap<String, Object>();
    private MProduct product;
    private MStore webStore;

    public static Product newInstance() {
        return new Product();
    }

    public Product withProduct(MProduct mProduct) {
        this.product = mProduct;
        return this;
    }

    private Product() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.map = new HashMap<String, Object>();
        if (Optional.ofNullable(this.product).isPresent()) {
            Serializable serializable;
            this.map.put("id", this.product.getM_Product_ID());
            this.map.put("name", this.product.getName());
            this.map.put("image", this.getImageName(this.product));
            this.map.put("sku", this.product.getSKU());
            this.map.put("url_key", this.getValidValue(this.product.getName()));
            this.map.put("type_id", this.getProductTypeFromProduct(this.product));
            this.map.put("price", this.getPrice(this.product));
            this.map.put("short_description", this.product.getDescription());
            this.map.put("description", this.product.getHelp());
            this.map.put("status", this.product.isActive() ? "1" : "2");
            this.map.put("visibility", "4");
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            List<MWCategory> list = MWCategory.getOfProduct(this.product.getCtx(), this.product.getM_Product_ID(), this.product.get_TrxName());
            StringBuffer stringBuffer = new StringBuffer();
            if (list != null && list.size() > 0) {
                list.forEach(mWCategory -> {
                    Category category = Category.newInstance().withCategoy((MWCategory)mWCategory);
                    arrayList.add(category.getMap());
                    arrayList2.add(category.getKeyValue());
                    if (stringBuffer.length() == 0) {
                        stringBuffer.append(category.getURLPath());
                    }
                });
            }
            stringBuffer.append("/").append(this.getValidValue(this.product.getName() + "-" + this.product.getM_Product_ID())).append(".html");
            this.map.put("slug", this.getValidValue(this.product.getName() + "-" + this.product.getM_Product_ID()));
            this.map.put("url_path", stringBuffer.toString());
            this.map.put("category_ids", arrayList2);
            this.map.put("category", arrayList);
            ArrayList arrayList3 = new ArrayList();
            MClientInfo mClientInfo = MClientInfo.get(this.product.getCtx());
            if (mClientInfo.getFileHandler_ID() != 0) {
                serializable = new AtomicInteger(1);
                Optional.ofNullable(this.product.getAttachment()).ifPresent(arg_0 -> this.lambda$getMap$2(mClientInfo, (AtomicInteger)serializable, arrayList3, arg_0));
            }
            this.map.put("media_gallery", arrayList3);
            if (this.product.getM_AttributeSet_ID() != 0) {
                serializable = new ArrayList();
                AtomicInteger atomicInteger = new AtomicInteger(1);
                MAttributeSet mAttributeSet = MAttributeSet.get(this.product.getCtx(), this.product.getM_AttributeSet_ID());
                Arrays.asList(mAttributeSet.getMAttributes(true)).forEach(arg_0 -> this.lambda$getMap$4(atomicInteger, (List)((Object)serializable), arg_0));
            }
            serializable = new HashMap();
            serializable.put("is_in_stock", this.product.isStocked());
            serializable.put("qty", this.getStock(this.product));
            this.map.put("stock", serializable);
            if (this.product.isBOM() && this.product.isVerified()) {
                this.map.put("configurable_children", this.getBillOfMaterial(this.product));
            }
            this.map.put("is_active", this.product.isActive());
            this.map.put("created_at", ElasticSearch.convertedDate(this.product.getCreated().getTime()));
            this.map.put("updated_at", ElasticSearch.convertedDate(this.product.getUpdated().getTime()));
        }
        return this.map;
    }

    private String getImageName(MProduct mProduct) {
        MClientInfo mClientInfo = MClientInfo.get(mProduct.getCtx());
        AtomicReference atomicReference = new AtomicReference();
        if (mClientInfo.getFileHandler_ID() != 0) {
            Optional.ofNullable(mProduct.getAttachment()).ifPresent(mAttachment -> {
                Optional optional = MADAttachmentReference.getListByAttachmentId(mProduct.getCtx(), mClientInfo.getFileHandler_ID(), mAttachment.getAD_Attachment_ID(), mProduct.get_TrxName()).stream().findFirst();
                if (optional.isPresent()) {
                    atomicReference.set("/" + ((MADAttachmentReference)optional.get()).getValidFileName());
                }
            });
        }
        return (String)atomicReference.get();
    }

    private List<Map<String, Object>> getBillOfMaterial(MProduct mProduct) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        MPPProductBOM mPPProductBOM = MPPProductBOM.getDefault(mProduct, mProduct.get_TrxName());
        if (Optional.ofNullable(mPPProductBOM).isPresent()) {
            HashMap hashMap = new HashMap();
            Arrays.asList(mPPProductBOM.getLines()).forEach(mPPProductBOMLine -> {
                MProduct mProduct2 = MProduct.get(mProduct.getCtx(), mPPProductBOMLine.getM_Product_ID());
                hashMap.put("id", mProduct2.getM_Product_ID());
                hashMap.put("sku", mProduct2.getSKU());
                hashMap.put("name", mProduct2.getName());
                hashMap.put("url_key", this.getValidValue(mProduct2.getName()));
                hashMap.put("url_path", mProduct2.getDescriptionURL());
                hashMap.put("status", this.getProductTypeFromProduct(mProduct2));
                hashMap.put("image", this.getImageName(mProduct2));
                hashMap.put("price", this.getPrice(mProduct2));
                hashMap.put("type_id", this.getProductTypeFromProduct(mProduct2));
                arrayList.add(hashMap);
            });
        }
        return arrayList;
    }

    private double getPrice(MProduct mProduct) {
        MPriceList mPriceList = MPriceList.get(mProduct.getCtx(), this.webStore.getM_PriceList_ID(), mProduct.get_TrxName());
        Timestamp timestamp = TimeUtil.getDay(System.currentTimeMillis());
        MProductPricing mProductPricing = new MProductPricing(mProduct.getM_Product_ID(), 0, Env.ZERO, true, mProduct.get_TrxName());
        mProductPricing.setM_PriceList_ID(mPriceList.getM_PriceList_ID());
        mProductPricing.setPriceDate(timestamp);
        return mProductPricing.getPriceStd().setScale(mProductPricing.getPrecision()).doubleValue();
    }

    private String getValidValue(String string) {
        return string.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    private double getStock(MProduct mProduct) {
        Optional<MStorage> optional = Arrays.asList(MStorage.getOfProduct(Env.getCtx(), mProduct.getM_Product_ID(), mProduct.get_TrxName())).stream().filter(mStorage -> mStorage.getQtyOnHand().signum() > 0).filter(mStorage -> mStorage.getM_Warehouse_ID() == this.webStore.getM_Warehouse_ID()).findFirst();
        if (optional.isPresent()) {
            BigDecimal bigDecimal = Env.ZERO;
            BigDecimal bigDecimal2 = Env.ZERO;
            if (optional.get().getQtyOnHand() != null) {
                bigDecimal = optional.get().getQtyOnHand();
            }
            if (optional.get().getQtyReserved() != null) {
                bigDecimal2 = optional.get().getQtyReserved();
            }
            if (bigDecimal2.signum() < 0) {
                return 0.0;
            }
            return bigDecimal.doubleValue();
        }
        return 0.0;
    }

    @Override
    public String getKeyValue() {
        if (this.product == null) {
            return "";
        }
        return String.valueOf(this.product.getM_Product_ID());
    }

    private String getProductTypeFromProduct(MProduct mProduct) {
        if (Util.isEmpty(mProduct.getProductType())) {
            return "simple";
        }
        if (mProduct.getProductType().equals("I") && mProduct.isStocked() && mProduct.getM_AttributeSet_ID() > 0) {
            return "configurable";
        }
        if (mProduct.getProductType().equals("I") && mProduct.isStocked() && mProduct.isBOM()) {
            return "grouped";
        }
        if (mProduct.getProductType().equals("S")) {
            return "configurable";
        }
        if (mProduct.getProductType().equals("I") && !mProduct.isStocked() && mProduct.isBOM()) {
            return "grouped";
        }
        if (mProduct.getProductType().equals("S") && mProduct.getM_Product_Category().getA_Asset_Group_ID() > 0) {
            return "downloadable";
        }
        if ((mProduct.getProductType().equals("I") || mProduct.getProductType().equals("S")) && mProduct.getR_MailText_ID() > 0) {
            return "gift";
        }
        return "simple";
    }

    @Override
    public String getCatalogName() {
        return "product";
    }

    @Override
    public boolean isValid() {
        return this.product != null && this.webStore != null;
    }

    @Override
    public IPersistenceWrapper withWebStoreId(int n) {
        if (n > 0) {
            this.webStore = MStore.get(this.product.getCtx(), n);
        }
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "date");
        hashMap.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("type", "date");
        hashMap2.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap hashMap3 = new HashMap();
        hashMap3.put("created_at", hashMap);
        hashMap3.put("updated_at", hashMap2);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("type", "keyword");
        hashMap3.put("slug", hashMap4);
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        hashMap5.put("type", "keyword");
        hashMap3.put("url_path", hashMap5);
        HashMap<String, String> hashMap6 = new HashMap<String, String>();
        hashMap6.put("type", "keyword");
        hashMap3.put("url_key", hashMap6);
        HashMap<String, String> hashMap7 = new HashMap<String, String>();
        hashMap7.put("type", "keyword");
        hashMap3.put("sku", hashMap7);
        HashMap<String, String> hashMap8 = new HashMap<String, String>();
        hashMap8.put("type", "float");
        hashMap3.put("price", hashMap8);
        HashMap<String, String> hashMap9 = new HashMap<String, String>();
        hashMap9.put("type", "float");
        hashMap3.put("final_price", hashMap9);
        HashMap<String, String> hashMap10 = new HashMap<String, String>();
        hashMap10.put("type", "integer");
        hashMap3.put("size_options", hashMap10);
        HashMap<String, Object> hashMap11 = new HashMap<String, Object>();
        hashMap11.put("properties", hashMap3);
        return hashMap11;
    }

    private /* synthetic */ void lambda$getMap$4(AtomicInteger atomicInteger, List list, MAttribute mAttribute) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", mAttribute.getM_Attribute_ID());
        hashMap.put("attribute_id", mAttribute.getM_Attribute_ID());
        hashMap.put("label", mAttribute.getName());
        hashMap.put("pos", atomicInteger.getAndIncrement());
        if (mAttribute.getAttributeValueType().equals("L")) {
            ArrayList arrayList = new ArrayList();
            Arrays.asList(mAttribute.getMAttributeValues()).forEach(mAttributeValue -> {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("value_index", mAttributeValue.getM_AttributeValue_ID());
                hashMap.put("label", mAttributeValue.getName());
                arrayList.add(hashMap);
            });
            hashMap.put("values", arrayList);
        }
        hashMap.put("product_id", this.product.getM_Product_ID());
        hashMap.put("attribute_code", mAttribute.getName().replaceAll(" ", ""));
        list.add(hashMap);
    }

    private /* synthetic */ void lambda$getMap$2(MClientInfo mClientInfo, AtomicInteger atomicInteger, List list, MAttachment mAttachment) {
        MADAttachmentReference.getListByAttachmentId(this.product.getCtx(), mClientInfo.getFileHandler_ID(), mAttachment.getAD_Attachment_ID(), this.product.get_TrxName()).forEach(mADAttachmentReference -> {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("image", "/" + mADAttachmentReference.getValidFileName());
            hashMap.put("pos", atomicInteger.getAndIncrement());
            list.add(hashMap);
        });
    }
}

