/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util.support.elasticsearch;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.apache.http.HttpHost;
import org.compiere.model.MStore;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.spin.model.MADAppRegistration;
import org.spin.store.support.IExternalCache;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;
import org.spin.util.support.IAppSupport;

public class ElasticSearch
implements IExternalCache,
IAppSupport {
    private String host = "localhost";
    private int port = 9200;
    private String schema = "http";
    private RestHighLevelClient client;
    private static CLogger log = CLogger.getCLogger(ElasticSearch.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private int registrationId = 0;
    private final String SCHEMA_KEY = "SCHEMA";
    private MStore webStore;

    public static String convertedDate(long l) {
        return new SimpleDateFormat(DATE_FORMAT).format(l);
    }

    private void validate() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration mADAppRegistration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
        this.withHost(mADAppRegistration.getHost());
        this.withPort(mADAppRegistration.getPort());
        this.withSchema(mADAppRegistration.getParameterValue("SCHEMA"));
        if (Util.isEmpty(this.getHost())) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        if (Util.isEmpty(this.getSchema())) {
            throw new AdempiereException("@Schema@ @NotFound@");
        }
        if (this.port <= 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
    }

    @Override
    public ElasticSearch connect() throws IOException {
        if (this.client != null) {
            return this;
        }
        this.validate();
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port, this.schema)}));
        return this;
    }

    @Override
    public ElasticSearch close() throws IOException {
        if (this.client == null) {
            return this;
        }
        this.client.close();
        this.client = null;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    public final ElasticSearch withHost(String string) {
        this.host = string;
        return this;
    }

    public final int getPort() {
        return this.port;
    }

    public final ElasticSearch withPort(int n) {
        this.port = n;
        return this;
    }

    public final String getSchema() {
        return this.schema;
    }

    public final ElasticSearch withSchema(String string) {
        this.schema = string;
        return this;
    }

    @Override
    public ElasticSearch index(IPersistenceWrapper iPersistenceWrapper) throws IOException {
        if (Optional.ofNullable(iPersistenceWrapper).isPresent() && iPersistenceWrapper.isValid()) {
            ReplicationResponse.ShardInfo shardInfo;
            CreateIndexRequest createIndexRequest;
            GetIndexRequest getIndexRequest;
            if (this.exist(iPersistenceWrapper)) {
                return this.update(iPersistenceWrapper);
            }
            try {
                getIndexRequest = new GetIndexRequest(new String[]{this.getCatalogName(iPersistenceWrapper.getCatalogName())});
                if (!this.client.indices().exists(getIndexRequest, RequestOptions.DEFAULT)) {
                    createIndexRequest = new CreateIndexRequest(this.getCatalogName(iPersistenceWrapper.getCatalogName()));
                    shardInfo = iPersistenceWrapper.getMapping();
                    if (Optional.ofNullable(shardInfo).isPresent()) {
                        createIndexRequest.mapping(shardInfo);
                        this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                    }
                }
            }
            catch (Exception exception) {
                throw new AdempiereException(exception);
            }
            getIndexRequest = new IndexRequest(this.getCatalogName(iPersistenceWrapper.getCatalogName())).id(iPersistenceWrapper.getKeyValue()).source(iPersistenceWrapper.getMap());
            getIndexRequest.opType(DocWriteRequest.OpType.CREATE);
            createIndexRequest = this.client.index((IndexRequest)getIndexRequest, RequestOptions.DEFAULT);
            if (createIndexRequest.getResult() == DocWriteResponse.Result.CREATED) {
                log.fine("Entity Created: " + iPersistenceWrapper.getKeyValue());
            } else if (createIndexRequest.getResult() == DocWriteResponse.Result.UPDATED) {
                log.fine("Entity Updated: " + iPersistenceWrapper.getKeyValue());
            }
            shardInfo = createIndexRequest.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                log.fine("Entity Created: " + iPersistenceWrapper.getKeyValue());
            }
            if (shardInfo.getFailed() > 0) {
                for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                    String string = failure.reason();
                    log.warning("Entity Index Error: " + iPersistenceWrapper.getKeyValue() + " - Reason: " + string);
                }
            }
        }
        return this;
    }

    @Override
    public ElasticSearch update(IPersistenceWrapper iPersistenceWrapper) throws IOException {
        if (Optional.ofNullable(iPersistenceWrapper).isPresent() && iPersistenceWrapper.isValid()) {
            if (!this.exist(iPersistenceWrapper)) {
                return this.index(iPersistenceWrapper);
            }
            UpdateRequest updateRequest = new UpdateRequest(this.getCatalogName(iPersistenceWrapper.getCatalogName()), iPersistenceWrapper.getKeyValue()).doc(iPersistenceWrapper.getMap());
            UpdateResponse updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
            if (updateResponse.getResult() == DocWriteResponse.Result.CREATED) {
                log.fine("Entity Created: " + iPersistenceWrapper.getKeyValue());
            } else if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.fine("Entity Updated: " + iPersistenceWrapper.getKeyValue());
            } else if (updateResponse.getResult() == DocWriteResponse.Result.DELETED) {
                log.fine("Entity Deleted: " + iPersistenceWrapper.getKeyValue());
            } else if (updateResponse.getResult() == DocWriteResponse.Result.NOOP) {
                log.fine("Entity Noop: " + iPersistenceWrapper.getKeyValue());
            }
        }
        return this;
    }

    @Override
    public ElasticSearch delete(IPersistenceWrapper iPersistenceWrapper) throws IOException {
        if (Optional.ofNullable(iPersistenceWrapper).isPresent() && iPersistenceWrapper.isValid() && this.exist(iPersistenceWrapper)) {
            DeleteRequest deleteRequest = new DeleteRequest(this.getCatalogName(iPersistenceWrapper.getCatalogName()), iPersistenceWrapper.getKeyValue());
            DeleteResponse deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
            ReplicationResponse.ShardInfo shardInfo = deleteResponse.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                log.fine("Entity Deleted: " + iPersistenceWrapper.getKeyValue());
            }
            if (shardInfo.getFailed() > 0) {
                for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                    String string = failure.reason();
                    log.warning("Entity Delete Error: " + iPersistenceWrapper.getKeyValue() + " - Reason: " + string);
                }
            }
        }
        return this;
    }

    @Override
    public boolean exist(IPersistenceWrapper iPersistenceWrapper) throws IOException {
        if (Optional.ofNullable(iPersistenceWrapper).isPresent() && iPersistenceWrapper.isValid()) {
            GetRequest getRequest = new GetRequest(this.getCatalogName(iPersistenceWrapper.getCatalogName()), iPersistenceWrapper.getKeyValue());
            getRequest.fetchSourceContext(new FetchSourceContext(false));
            getRequest.storedFields(new String[]{"_none_"});
            return this.client.exists(getRequest, RequestOptions.DEFAULT);
        }
        return false;
    }

    @Override
    public String testConnection() {
        this.validate();
        String string = null;
        try {
            this.connect();
            string = "Ok: " + this.exist(new IPersistenceWrapper(){

                @Override
                public Map<String, Object> getMap() {
                    return new HashMap<String, Object>();
                }

                @Override
                public String getKeyValue() {
                    return "1";
                }

                @Override
                public String getCatalogName() {
                    return "product";
                }

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public IPersistenceWrapper withWebStoreId(int n) {
                    return null;
                }

                @Override
                public Map<String, Object> getMapping() {
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getMessage());
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {
                throw new AdempiereException(exception.getMessage());
            }
        }
        return string;
    }

    private String getCatalogName(String string) {
        return (this.webStore.getWebContext() + "_" + string).trim().toLowerCase().replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    @Override
    public void setAppRegistrationId(int n) {
        this.registrationId = n;
    }

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void withWebStore(MStore mStore) {
        this.webStore = mStore;
    }

    @Override
    public int getCacheId() {
        return this.getAppRegistrationId();
    }
}

