/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.model.validator;

import org.adempiere.core.domains.models.X_W_Basket;
import org.adempiere.core.domains.models.X_W_BasketLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MProduct;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.store.model.MWCategory;
import org.spin.store.util.ElasticSearchHelper;
import org.spin.store.util.VueStoreFrontUtil;
import org.spin.store.util.support.elasticsearch.Attribute;
import org.spin.store.util.support.elasticsearch.Category;
import org.spin.store.util.support.elasticsearch.Product;
import org.spin.store.util.support.elasticsearch.TaxCategory;

public class VueStoreFront
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(VueStoreFront.class);
    private int clientId = -1;

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient mClient) {
        if (mClient != null) {
            this.clientId = mClient.getAD_Client_ID();
            log.info(mClient.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        modelValidationEngine.addModelChange("M_Product", this);
        modelValidationEngine.addModelChange("W_Category", this);
        modelValidationEngine.addModelChange("C_TaxCategory", this);
        modelValidationEngine.addModelChange("C_Tax", this);
        modelValidationEngine.addModelChange("M_Attribute", this);
        modelValidationEngine.addModelChange("M_AttributeValue", this);
        modelValidationEngine.addModelChange("AD_Attachment", this);
        modelValidationEngine.addModelChange("AD_User", this);
        modelValidationEngine.addModelChange("W_Basket", this);
        modelValidationEngine.addModelChange("W_BasketLine", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int n, int n2, int n3) {
        log.info("AD_User_ID=" + n3);
        return null;
    }

    @Override
    public String modelChange(PO pO, int n) throws Exception {
        if (n == 1) {
            MUser mUser;
            if (pO.get_TableName().equals("W_BasketLine")) {
                X_W_BasketLine x_W_BasketLine = (X_W_BasketLine)pO;
                VueStoreFrontUtil.setBasketLineDefaultValues(x_W_BasketLine);
            } else if (pO instanceof MUser && (mUser = (MUser)pO).isWebstoreUser()) {
                MStore mStore = VueStoreFrontUtil.getDefaultStore(Env.getAD_Org_ID(Env.getCtx()));
                if (mStore == null) {
                    throw new AdempiereException("@W_Store_ID@ @NotFound@");
                }
                MBPartner mBPartner = VueStoreFrontUtil.getTemplate(mUser.getCtx(), mStore.get_ValueAsInt("C_TemplateBPartner_ID"), mUser.get_TrxName());
                mBPartner.setValue(mUser.getEMail());
                mBPartner.setTaxID(mUser.getEMail());
                mBPartner.setName(mUser.getName());
                mBPartner.saveEx();
                mUser.setC_BPartner_ID(mBPartner.getC_BPartner_ID());
            }
        } else if (n == 2) {
            X_W_BasketLine x_W_BasketLine;
            if (pO.get_TableName().equals("W_BasketLine") && ((x_W_BasketLine = (X_W_BasketLine)pO).is_ValueChanged("Qty") || x_W_BasketLine.is_ValueChanged("Price"))) {
                VueStoreFrontUtil.setBasketLineDefaultValues(x_W_BasketLine);
            }
        } else if (n != 3) {
            if (n == 4) {
                MUser mUser;
                if (pO instanceof MProduct) {
                    MProduct mProduct = (MProduct)pO;
                    if (mProduct.is_ValueChanged("IsWebStoreFeatured") && !mProduct.isWebStoreFeatured()) {
                        ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(mProduct)).close();
                    } else {
                        ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(mProduct)).close();
                    }
                } else if (pO instanceof MWCategory) {
                    MWCategory mWCategory = (MWCategory)pO;
                    ElasticSearchHelper.getInstance().connect().index(Category.newInstance().withCategoy(mWCategory)).close();
                } else if (pO instanceof MTaxCategory) {
                    MTaxCategory mTaxCategory = (MTaxCategory)pO;
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(mTaxCategory)).close();
                } else if (pO instanceof MTax) {
                    MTax mTax = (MTax)pO;
                    MTaxCategory mTaxCategory = (MTaxCategory)mTax.getC_TaxCategory();
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(mTaxCategory)).close();
                } else if (pO instanceof MAttribute) {
                    MAttribute mAttribute = (MAttribute)pO;
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(mAttribute)).close();
                } else if (pO instanceof MAttributeValue) {
                    MAttributeValue mAttributeValue = (MAttributeValue)pO;
                    MAttribute mAttribute = (MAttribute)mAttributeValue.getM_Attribute();
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(mAttribute)).close();
                } else if (pO instanceof MAttachment) {
                    MAttachment mAttachment = (MAttachment)pO;
                    if (mAttachment.getAD_Table_ID() == MProduct.Table_ID) {
                        MProduct mProduct = MProduct.get(mAttachment.getCtx(), mAttachment.getRecord_ID());
                        ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(mProduct)).close();
                    }
                } else if (pO instanceof MUser && (mUser = (MUser)pO).isWebstoreUser()) {
                    MStore mStore = VueStoreFrontUtil.getDefaultStore(Env.getAD_Org_ID(Env.getCtx()));
                    if (mStore == null) {
                        throw new AdempiereException("@W_Store_ID@ @NotFound@");
                    }
                    int n2 = mStore.get_ValueAsInt("CustomerRole_ID");
                    if (n2 <= 0) {
                        throw new AdempiereException("@CustomerRole_ID@ @NotFound@");
                    }
                    new MUserRoles(mUser.getCtx(), mUser.getAD_User_ID(), n2, mUser.get_TrxName()).saveEx();
                    MBPartner mBPartner = VueStoreFrontUtil.getTemplate(mUser.getCtx(), mStore.get_ValueAsInt("C_TemplateBPartner_ID"), mUser.get_TrxName());
                    mBPartner.setValue(mUser.getEMail());
                    mBPartner.setTaxID(mUser.getEMail());
                    mBPartner.setName(mUser.getName());
                    mBPartner.saveEx();
                }
            } else if (n == 5) {
                MAttachment mAttachment;
                if (pO instanceof MProduct) {
                    MProduct mProduct = (MProduct)pO;
                    ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(mProduct)).close();
                } else if (pO instanceof MWCategory) {
                    MWCategory mWCategory = (MWCategory)pO;
                    ElasticSearchHelper.getInstance().connect().index(Category.newInstance().withCategoy(mWCategory)).close();
                } else if (pO instanceof MTaxCategory) {
                    MTaxCategory mTaxCategory = (MTaxCategory)pO;
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(mTaxCategory)).close();
                } else if (pO instanceof MTax) {
                    MTax mTax = (MTax)pO;
                    MTaxCategory mTaxCategory = (MTaxCategory)mTax.getC_TaxCategory();
                    ElasticSearchHelper.getInstance().connect().index(TaxCategory.newInstance().withTaxCategory(mTaxCategory)).close();
                } else if (pO instanceof MAttribute) {
                    MAttribute mAttribute = (MAttribute)pO;
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(mAttribute)).close();
                } else if (pO instanceof MAttributeValue) {
                    MAttributeValue mAttributeValue = (MAttributeValue)pO;
                    MAttribute mAttribute = (MAttribute)mAttributeValue.getM_Attribute();
                    ElasticSearchHelper.getInstance().connect().index(Attribute.newInstance().withAttribute(mAttribute)).close();
                } else if (pO instanceof MAttachment && (mAttachment = (MAttachment)pO).getAD_Table_ID() == MProduct.Table_ID) {
                    MProduct mProduct = MProduct.get(mAttachment.getCtx(), mAttachment.getRecord_ID());
                    ElasticSearchHelper.getInstance().connect().index(Product.newInstance().withProduct(mProduct)).close();
                }
            } else if (n == 6) {
                if (pO instanceof MProduct) {
                    MProduct mProduct = (MProduct)pO;
                    ElasticSearchHelper.getInstance().connect().delete(Product.newInstance().withProduct(mProduct)).close();
                } else if (pO instanceof MWCategory) {
                    MWCategory mWCategory = (MWCategory)pO;
                    ElasticSearchHelper.getInstance().connect().delete(Category.newInstance().withCategoy(mWCategory)).close();
                } else if (pO instanceof MTaxCategory) {
                    MTaxCategory mTaxCategory = (MTaxCategory)pO;
                    ElasticSearchHelper.getInstance().connect().delete(TaxCategory.newInstance().withTaxCategory(mTaxCategory)).close();
                } else if (pO instanceof MTax) {
                    MTax mTax = (MTax)pO;
                    MTaxCategory mTaxCategory = (MTaxCategory)mTax.getC_TaxCategory();
                    ElasticSearchHelper.getInstance().connect().delete(TaxCategory.newInstance().withTaxCategory(mTaxCategory)).close();
                } else if (pO instanceof MAttribute) {
                    MAttribute mAttribute = (MAttribute)pO;
                    ElasticSearchHelper.getInstance().connect().delete(Attribute.newInstance().withAttribute(mAttribute)).close();
                } else if (pO instanceof MAttributeValue) {
                    MAttributeValue mAttributeValue = (MAttributeValue)pO;
                    MAttribute mAttribute = (MAttribute)mAttributeValue.getM_Attribute();
                    ElasticSearchHelper.getInstance().connect().delete(Attribute.newInstance().withAttribute(mAttribute)).close();
                } else if (pO instanceof MAttachment) {
                    MAttachment mAttachment = (MAttachment)pO;
                    if (mAttachment.getAD_Table_ID() == MProduct.Table_ID) {
                        MProduct mProduct = MProduct.get(mAttachment.getCtx(), mAttachment.getRecord_ID());
                        ElasticSearchHelper.getInstance().connect().delete(Product.newInstance().withProduct(mProduct)).close();
                    }
                } else if (pO.get_TableName().equals("W_Basket")) {
                    X_W_Basket x_W_Basket = (X_W_Basket)pO;
                    VueStoreFrontUtil.deletePackageFromBasket(x_W_Basket.getCtx(), x_W_Basket.getW_Basket_ID(), x_W_Basket.get_TrxName());
                } else if (pO.get_TableName().equals("W_BasketLine")) {
                    X_W_BasketLine x_W_BasketLine = (X_W_BasketLine)pO;
                    VueStoreFrontUtil.deletePackageLineFromBasketLine(x_W_BasketLine.getCtx(), x_W_BasketLine.getW_BasketLine_ID(), x_W_BasketLine.get_TrxName());
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO pO, int n) {
        return null;
    }
}

