/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Logger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.Util;
import org.spin.queue.model.MADQueue;

public abstract class QueueManager {
    protected static final Logger logger = Logger.getLogger(QueueManager.class.getName());
    private int queueTypeId;
    private String description;
    private int tableId;
    private int recordId;
    private int organizationId;
    private Properties context;
    private String transactionName;
    private PO entity;

    public QueueManager() {
        this.clear();
    }

    public final String getDescription() {
        return this.description;
    }

    public final Properties getContext() {
        return this.context;
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final QueueManager withDescription(String description) {
        this.description = description;
        return this;
    }

    public final int getTableId() {
        return this.tableId;
    }

    private final QueueManager withTableId(int tableId) {
        this.tableId = tableId;
        return this;
    }

    public final int getRecordId() {
        return this.recordId;
    }

    private final QueueManager withRecordId(int recordId) {
        this.recordId = recordId;
        return this;
    }

    public final QueueManager withTransactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public final QueueManager withContext(Properties context) {
        this.context = context;
        return this;
    }

    public final QueueManager withOrganizationId(int organizationId) {
        if (this.getRecordId() <= 0) {
            this.organizationId = organizationId;
        }
        return this;
    }

    public final PO getEntity() {
        return this.entity;
    }

    public final int getQueueTypeId() {
        return this.queueTypeId;
    }

    public final QueueManager withQueueTypeId(int queueTypeId) {
        this.queueTypeId = queueTypeId;
        return this;
    }

    public QueueManager withEntity(PO entity) {
        this.entity = entity;
        if (entity != null) {
            this.withContext(entity.getCtx()).withTransactionName(entity.get_TrxName()).withOrganizationId(entity.getAD_Org_ID()).withTableId(entity.get_Table_ID()).withRecordId(entity.get_ID());
        } else {
            logger.config("Entity is null");
        }
        return this;
    }

    public QueueManager withEntity(int tableId, int recordId) {
        if (this.getContext() == null || this.getTransactionName() == null) {
            throw new AdempiereException("@NotFound@");
        }
        MTable tableEntity = MTable.get(this.getContext(), tableId);
        return this.withEntity(tableEntity.getPO(recordId, this.getTransactionName()));
    }

    public QueueManager clear() {
        this.queueTypeId = 0;
        this.description = null;
        this.tableId = 0;
        this.recordId = 0;
        this.organizationId = 0;
        this.context = null;
        this.transactionName = null;
        this.entity = null;
        return this;
    }

    public MADQueue addToQueue() {
        if (this.context == null) {
            throw new AdempiereException("Context is mandatory");
        }
        if (this.queueTypeId <= 0) {
            throw new AdempiereException("Queue Type is mandatory");
        }
        MADQueue queue = new MADQueue(this.context, 0, this.transactionName);
        queue.setAD_Org_ID(this.organizationId);
        queue.setAD_QueueType_ID(this.queueTypeId);
        if (!Util.isEmpty(this.getDescription())) {
            queue.setDescription(this.getDescription());
        }
        if (this.getTableId() > 0) {
            queue.setAD_Table_ID(this.getTableId());
        }
        if (this.getRecordId() > 0) {
            queue.setRecord_ID(this.getRecordId());
        }
        queue.saveEx();
        this.add(queue.getAD_Queue_ID());
        return queue;
    }

    public void process(MADQueue queueToProcess, boolean deleteAfterProcess) {
        if (queueToProcess == null) {
            throw new AdempiereException("Queue is mandatory");
        }
        if (this.context == null) {
            throw new AdempiereException("Context is mandatory");
        }
        if (this.transactionName == null) {
            throw new AdempiereException("Transaction is mandatory");
        }
        boolean processed = true;
        String error = null;
        try {
            this.process(queueToProcess.getAD_Queue_ID());
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            processed = false;
            error = e.getLocalizedMessage();
        }
        if (deleteAfterProcess) {
            queueToProcess.delete(true);
        } else {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            long mili = ts.getTime();
            int nano = ts.getNanos();
            double doublets = Double.parseDouble(Long.toString(mili) + "." + Integer.toString(nano));
            BigDecimal bdtimestamp = new BigDecimal(doublets);
            queueToProcess.setProcessedOn(bdtimestamp);
            queueToProcess.setProcessed(processed);
            queueToProcess.saveEx();
        }
        if (!processed) {
            throw new AdempiereException(error);
        }
    }

    public abstract void add(int var1);

    public abstract void process(int var1);
}

