/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.util;

import java.util.HashMap;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;
import org.spin.queue.notification.telegram.util.BaseMessage;
import org.spin.queue.notification.telegram.util.ConfirmationMessage;
import org.spin.queue.notification.telegram.util.ITelegramMessage;

public class MessageFactory {
    private Map<String, ITelegramMessage> messagesHandler = new HashMap<String, ITelegramMessage>();
    private static MessageFactory instance = new MessageFactory();

    public static MessageFactory getInstance() {
        return instance;
    }

    public ITelegramMessage getHandler(String string) {
        if (Util.isEmpty(string)) {
            throw new AdempiereException("@MessageType@ @IsMandatory@");
        }
        ITelegramMessage iTelegramMessage = this.messagesHandler.get(string);
        if (iTelegramMessage == null) {
            iTelegramMessage = this.getStaticHandler(string);
            this.messagesHandler.put(string, iTelegramMessage);
        }
        return iTelegramMessage;
    }

    private ITelegramMessage getStaticHandler(String string) {
        BaseMessage baseMessage = null;
        switch (string) {
            case "CFM": {
                baseMessage = new ConfirmationMessage();
                break;
            }
            case "PRM": {
                baseMessage = new BaseMessage();
                break;
            }
            case "SRV": {
                baseMessage = new BaseMessage();
                break;
            }
            default: {
                baseMessage = new BaseMessage();
            }
        }
        return baseMessage;
    }
}

