/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.support;

import java.util.Arrays;
import org.adempiere.core.domains.models.X_AD_UserMail;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MEMailConfig;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.support.INotification;

public class EMailSender
implements INotification {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(EMailSender.class);

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.log.fine("set Registration: " + registrationId);
    }

    @Override
    public String testConnection() {
        this.log.fine("Test connection");
        return "Ok";
    }

    @Override
    public void sendNotification(MADNotificationQueue notification) {
        StringBuffer errorMessage = new StringBuffer();
        notification.getRecipients().forEach(recipient -> {
            EMail email;
            MOrg mOrg;
            MOrgInfo mOrgInfo;
            StringBuffer recipientErrorMessage = new StringBuffer();
            MClient client = MClient.get(notification.getCtx(), notification.getAD_Client_ID());
            String eMailFrom = client.getRequestEMail();
            String eMailPsw = client.getRequestUserPW();
            int eMailConfigId = client.getAD_EMailConfig_ID();
            if (notification.getAD_Org_ID() > 0 && (mOrgInfo = (mOrg = MOrg.get(notification.getCtx(), notification.getAD_Org_ID())).getInfo()).getEMail() != null && mOrgInfo.getAD_EMailConfig_ID() > 0 && mOrgInfo.getRequestUserPW() != null) {
                eMailFrom = mOrgInfo.getEMail();
                eMailPsw = mOrgInfo.getRequestUserPW();
                eMailConfigId = mOrgInfo.getAD_EMailConfig_ID();
            }
            MUser fromUser = null;
            if (notification.getAD_User_ID() > 0) {
                fromUser = MUser.get(notification.getCtx(), notification.getAD_User_ID());
            }
            if (!(email = new EMail(client, eMailConfigId, eMailFrom, recipient.getAccountName(), notification.getDescription(), notification.getText(), false)).isValid() && !email.isValid(true)) {
                this.log.warning("NOT VALID - " + email);
                if (recipientErrorMessage.length() > 0) {
                    recipientErrorMessage.append(Env.NL);
                }
                recipientErrorMessage.append("NOT VALID - " + email);
            } else {
                boolean isSent;
                if (fromUser != null && fromUser.getAD_EMailConfig_ID() > 0) {
                    MEMailConfig emailConfig = MEMailConfig.get(notification.getCtx(), fromUser.getAD_EMailConfig_ID());
                    if (emailConfig.isSmtpAuthorization() || emailConfig.getAuthMechanism().equals("O")) {
                        email.createAuthenticator(fromUser.getEMailUser(), fromUser.getEMailUserPW());
                    }
                } else {
                    MEMailConfig eMailConfig = MEMailConfig.get(client.getCtx(), eMailConfigId);
                    if (eMailConfig.isSmtpAuthorization()) {
                        email.createAuthenticator(eMailFrom, eMailPsw);
                    }
                }
                email.setSubject(notification.getDescription());
                email.setMessageHTML(notification.getText());
                MAttachment attachment = notification.getAttachment();
                if (attachment != null && attachment.getAD_Attachment_ID() > 0) {
                    Arrays.asList(attachment.getEntries()).forEach(entry -> email.addAttachment(entry.getFile()));
                }
                if (isSent = "OK".equals(email.send())) {
                    this.log.fine("EMail Sent: " + recipient.getAccountName());
                    recipient.setProcessed(true);
                } else {
                    recipient.setIsActive(false);
                    if (recipientErrorMessage.length() > 0) {
                        recipientErrorMessage.append(Env.NL);
                    }
                    recipientErrorMessage.append("Error: Sending to: " + recipient.getAccountName());
                }
                if (recipient.getAD_User_ID() > 0) {
                    X_AD_UserMail userMail = new X_AD_UserMail(notification.getCtx(), 0, notification.get_TrxName());
                    userMail.setAD_Org_ID(notification.getAD_Org_ID());
                    userMail.setAD_User_ID(recipient.getAD_User_ID());
                    userMail.setSubject(email.getSubject());
                    userMail.setMailText(email.getMessageCRLF());
                    if (email.isSentOK()) {
                        userMail.setMessageID(email.getMessageID());
                    } else {
                        userMail.setMessageID(email.getSentMsg());
                        userMail.setIsDelivered("N");
                    }
                    userMail.saveEx();
                }
            }
            if (recipientErrorMessage.length() > 0) {
                errorMessage.append(recipientErrorMessage);
                recipient.setErrorMsg(recipientErrorMessage.toString());
            }
            recipient.set_ValueOfColumn("FromAccountName", (Object)eMailFrom);
            if (recipient.is_Changed()) {
                recipient.saveEx();
            }
        });
        if (errorMessage.length() > 0) {
            // empty if block
        }
    }
}

