/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_QueueType;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MADQueueType
extends X_AD_QueueType {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MADQueueType> queueTypeCacheIds = new CCache("AD_QueueType", 30);
    private static CCache<String, MADQueueType> queueTypeCacheValues = new CCache("AD_QueueType", 30);

    public MADQueueType(Properties ctx, int queueTypeId, String trxName) {
        super(ctx, queueTypeId, trxName);
    }

    public MADQueueType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADQueueType getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MADQueueType definition = queueTypeCacheIds.get(definitionId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADQueueType)new Query(ctx, "AD_QueueType", "AD_QueueType_ID=?", trxName).setParameters(definitionId).first();
        if (definition != null && definition.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + definition.getValue();
            queueTypeCacheValues.put(key, definition);
            queueTypeCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static MADQueueType getByQueueType(Properties ctx, String queueType, String trxName) {
        int clientId;
        String key;
        MADQueueType definition;
        if (queueType == null) {
            return null;
        }
        if (queueTypeCacheValues.size() == 0) {
            MADQueueType.getAll(ctx, true, trxName);
        }
        if ((definition = queueTypeCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + queueType)) != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADQueueType)new Query(ctx, "AD_QueueType", "QueueType=? AND AD_Client_ID IN(0, ?)", trxName).setParameters(queueType, clientId).setOrderBy("AD_Client_ID DESC").first();
        if (definition != null && definition.get_ID() > 0) {
            queueTypeCacheValues.put(key, definition);
            queueTypeCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static List<MADQueueType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || queueTypeCacheIds.size() > 0) {
            List<MADQueueType> definitionList = new Query(Env.getCtx(), "AD_QueueType", null, trxName).setClient_ID().setOrderBy("Name").list();
            definitionList.stream().forEach(definition -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + definition.getValue();
                queueTypeCacheIds.put(definition.getAD_QueueType_ID(), (MADQueueType)definition);
                queueTypeCacheValues.put(key, (MADQueueType)definition);
            });
            return definitionList;
        }
        List<MADQueueType> definitionList = queueTypeCacheIds.entrySet().stream().map(activity -> (MADQueueType)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    @Override
    public String toString() {
        return "MADQueueType [getAD_QueueType_ID()=" + this.getAD_QueueType_ID() + ", getClassname()=" + this.getClassname() + ", getName()=" + this.getName() + ", getQueueType()=" + this.getQueueType() + ", getValue()=" + this.getValue() + "]";
    }
}

