/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.model.MView;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.process.WithholdingProcessAbstract;
import org.spin.util.WithholdingEngine;

public class WithholdingProcess
extends WithholdingProcessAbstract {
    private MWHSetting mSetting = null;
    private MWHDefinition mDefinition = null;
    private HashMap<String, Object> params = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        String result = "";
        for (ProcessInfoParameter param : this.getParameter()) {
            this.params.put(param.getParameterName(), param.getParameter());
        }
        this.processWithholding();
        return result;
    }

    private String processWithholding() {
        MWHType mType = null;
        AtomicReference<String> result = new AtomicReference<String>();
        result.set("");
        if (this.getTypeId() != 0) {
            mType = new MWHType(this.getCtx(), this.getTypeId(), this.get_TrxName());
        }
        if (this.getSettingId() != 0) {
            this.mSetting = new MWHSetting(this.getCtx(), this.getSettingId(), this.get_TrxName());
        }
        if (this.getDefinitionId() != 0) {
            this.mDefinition = new MWHDefinition(this.getCtx(), this.getDefinitionId(), this.get_TrxName());
        }
        if (this.getRecord_ID() != 0 && this.getTable_ID() != 0) {
            result.set(this.processDocument(mType, this.getTable_ID(), this.getRecord_ID()));
        } else if (mType != null && mType.get_ID() > 0) {
            this.processWithHoldingType(mType);
        } else {
            MWHType.getAll(this.getCtx(), true, this.get_TrxName()).forEach(type -> result.set(this.processWithHoldingType((MWHType)type)));
        }
        return (String)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processWithHoldingType(MWHType type) {
        String result = "";
        if (type != null && type.getAD_View_ID() != 0) {
            String sql = MView.getSQLFromView(type.getAD_View_ID(), this.get_TrxName());
            CPreparedStatement st = null;
            ResultSet rs = null;
            try {
                st = DB.prepareStatement(sql, this.get_TrxName());
                rs = st.executeQuery();
                while (rs.next()) {
                    Integer AD_Table_ID = rs.getInt("AD_Table_ID");
                    Integer Record_ID = rs.getInt("Record_ID");
                    result = this.processDocument(type, AD_Table_ID, Record_ID);
                }
            }
            catch (SQLException e) {
                try {
                    result = e.getMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, st);
                    st = null;
                    rs = null;
                    throw throwable;
                }
                DB.close(rs, st);
                st = null;
                rs = null;
            }
            DB.close(rs, st);
            st = null;
            rs = null;
        }
        return result;
    }

    private String processDocument(MWHType type, int AD_Table_ID, int Record_ID) {
        String result = "";
        PO document = null;
        if (AD_Table_ID != 0 && Record_ID != 0) {
            if (AD_Table_ID == MInvoice.Table_ID) {
                document = new MInvoice(this.getCtx(), Record_ID, this.get_TrxName());
            } else if (AD_Table_ID == MInvoice.Table_ID) {
                document = new MOrder(this.getCtx(), Record_ID, this.get_TrxName());
            } else {
                return "";
            }
            result = WithholdingEngine.get().fireProcess((DocAction)((Object)document), type, this.mSetting, this.mDefinition, this.params);
        }
        return result;
    }
}

