/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.I_C_ValidCombination;
import org.adempiere.core.domains.models.X_C_ValidCombination;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MRevenueRecognition;
import org.compiere.model.MRevenueRecognitionPlan;
import org.compiere.model.MRevenueRecognitionRun;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.javatuples.Pair;
import org.javatuples.Quartet;
import org.openup.core.model.MRevenueRecognitionBatch;
import org.openup.core.utils.Utils;
import org.spin.process.RevenueRecognitionGLJournalAbstract;

public class RevenueRecognitionGLJournal
extends RevenueRecognitionGLJournalAbstract {
    private HashMap<Integer, MRevenueRecognitionBatch> revenueBatches;

    @Override
    protected String doIt() throws Exception {
        long startTime = System.currentTimeMillis();
        Timestamp processDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(new Timestamp(System.currentTimeMillis()).toString()).getTime());
        this.revenueBatches = new HashMap();
        MRevenueRecognition revenueRecognition = new MRevenueRecognition(this.getCtx(), this.getRevenueRecognitionId(), null);
        ArrayList runIDs = new ArrayList();
        AtomicInteger projAcu = new AtomicInteger(0);
        AtomicInteger projSuccess = new AtomicInteger(0);
        AtomicReference<String> sqlQuery = new AtomicReference<String>("SELECT o.C_Order_ID, ol.C_OrderLine_ID, plan.C_RevenueRecognition_Plan_ID, run.C_RevenueRecognition_Run_ID, glj.GL_Journal_ID\n, c.S_Contract_ID, c.documentNo\n, ol.AD_Client_ID, ol.AD_Org_ID, p.C_Project_ID, p.value\n, o.C_Currency_ID, run.CurrencyRate\n, plan.UnEarnedRevenue_Acct, plan.P_Revenue_Acct, plan.C_RevenueRecognition_Plan_ID, bpl.C_SalesRegion_ID\nFROM C_Order o\nJOIN C_OrderLine ol ON o.C_Order_ID=ol.C_Order_ID\nJOIN C_RevenueRecognition_Plan plan ON ol.C_OrderLine_ID=plan.C_OrderLine_ID\nJOIN C_RevenueRecognition_Run run ON plan.C_RevenueRecognition_Plan_ID=run.C_RevenueRecognition_Plan_ID\nJOIN C_Project p ON o.C_Project_ID=p.C_Project_ID\nJOIN S_Contract c ON p.S_Contract_ID=c.S_Contract_ID\nLEFT JOIN GL_Journal glj ON run.GL_Journal_ID=glj.GL_Journal_ID\nLEFT JOIN C_BPartner_Location bpl ON o.C_BPartner_Location_ID=bpl.C_BPartner_Location_ID\nWHERE run.GL_Journal_ID IS NULL\n");
        ArrayList<Integer> params = new ArrayList<Integer>();
        if (this.getRevenueRecognitionId() > 0) {
            sqlQuery.set(sqlQuery.get() + "AND C_RevenueRecognition_ID=?\n");
            params.add(this.getRevenueRecognitionId());
        }
        if (this.getOrgId() > 0) {
            sqlQuery.set(sqlQuery.get() + "AND o.AD_Org_ID=?\n");
            params.add(this.getOrgId());
        }
        if (this.getContractId() > 0) {
            sqlQuery.set(sqlQuery.get() + "AND o.S_Contract_ID=?\n");
            params.add(this.getContractId());
        }
        if (this.getProjectId() > 0) {
            sqlQuery.set(sqlQuery.get() + "AND o.C_Project_ID=?");
            params.add(this.getProjectId());
        }
        AtomicReference accountingSchema = new AtomicReference();
        AtomicInteger conversionTypeId = new AtomicInteger();
        Trx.run(trxName -> {
            accountingSchema.set(Arrays.stream(MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), trxName)).findFirst().get());
            conversionTypeId.set(MConversionType.getDefault(this.getAD_Client_ID()));
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sqlQuery.get(), trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    Dto dto = new Dto();
                    dto.run_id = rs.getInt("C_RevenueRecognition_Run_ID");
                    dto.client_id = rs.getInt("AD_Client_ID");
                    dto.org_id = rs.getInt("AD_Org_ID");
                    dto.project_id = rs.getInt("C_Project_ID");
                    dto.currency_id = rs.getInt("C_Currency_ID");
                    dto.currencyRate = rs.getBigDecimal("CurrencyRate");
                    dto.UnEarnedRevenue_A = rs.getInt("UnEarnedRevenue_Acct");
                    dto.P_Revenue_A = rs.getInt("P_Revenue_Acct");
                    dto.plan_id = rs.getInt("C_RevenueRecognition_Plan_ID");
                    dto.salesRegion_id = rs.getInt("C_SalesRegion_ID");
                    dto.contract_id = rs.getInt("S_Contract_ID");
                    dto.contractDocumentNo = rs.getBigDecimal("DocumentNo");
                    dto.project_id = rs.getInt("C_Project_ID");
                    dto.projectValue = rs.getString("Value");
                    dto.order_id = rs.getInt("C_Order_ID");
                    runIDs.add(dto);
                }
            }
            catch (Exception e) {
                try {
                    this.addLog("@C_RevenueRecognition_Run_ID@ @not.found@");
                    throw new AdempiereException(e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
        });
        long totalContracts = runIDs.stream().map(dto -> dto.contract_id).distinct().count();
        long totalProjects = runIDs.stream().map(dto -> dto.project_id).distinct().count();
        long totalPlans = runIDs.stream().map(dto -> dto.plan_id).distinct().count();
        this.addLog("@Count@ - @S_Contract_ID@ " + totalContracts + " - @C_Project_ID@ " + totalProjects + " - @C_RevenueRecognition_Plan_ID@ " + totalPlans);
        runIDs.stream().collect(Collectors.groupingBy(dto -> new Pair<Integer, BigDecimal>(Integer.valueOf(dto.contract_id), dto.contractDocumentNo))).forEach((lvl1key, lvl1dtos) -> {
            long totalProjectsByContract = lvl1dtos.stream().map(dto -> dto.project_id).distinct().count();
            long totalOrderByContract = lvl1dtos.stream().map(dto -> dto.order_id).distinct().count();
            long totalPlansByContract = lvl1dtos.stream().map(dto -> dto.plan_id).distinct().count();
            this.addLog("@S_Contract_ID@ " + lvl1key.getValue1() + " - #@C_Project_ID@ " + totalProjectsByContract + " - #@C_Order_ID@ " + totalOrderByContract + " - #@C_RevenueRecognition_Plan_ID@ " + totalPlansByContract);
            lvl1dtos.stream().collect(Collectors.groupingBy(dto -> new Quartet<Integer, Integer, Integer, String>(Integer.valueOf(dto.client_id), dto.org_id, dto.project_id, dto.projectValue))).forEach((lvl2key, lvl2dtos) -> {
                int client_id = (Integer)lvl2key.getValue0();
                int org_id = (Integer)lvl2key.getValue1();
                int project_id = (Integer)lvl2key.getValue2();
                long totalOrderByProject = lvl2dtos.stream().map(dto -> dto.order_id).distinct().count();
                long totalRunsByProject = lvl2dtos.stream().map(dto -> dto.plan_id).distinct().count();
                String msgProjectLog = " | @C_Project_ID@ " + lvl2key.getValue3() + " - @C_Order_ID@ " + totalOrderByProject + " - @C_RevenueRecognition_Run_ID@ " + totalRunsByProject + " | ";
                AtomicReference<String> journalBatchStr = new AtomicReference<String>("--");
                AtomicReference projectMsg = new AtomicReference();
                try {
                    Trx.run(projectTrxName -> {
                        try {
                            String projectValue = new MProject(this.getCtx(), project_id, projectTrxName).getValue();
                            projectMsg.set("@C_Project_ID@ " + Optional.ofNullable(projectValue).orElse("(ID " + project_id + ")") + " " + projAcu.addAndGet(1) + " / " + lvl2dtos.size());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            projectMsg.set("--");
                        }
                        MJournalBatch journalBatch = this.createJournalBatch((MAcctSchema)accountingSchema.get(), org_id, project_id, projectTrxName);
                        journalBatchStr.set(journalBatch.getDocumentNo());
                        lvl2dtos.stream().collect(Collectors.groupingBy(dto -> new Pair<Integer, BigDecimal>(Integer.valueOf(dto.currency_id), dto.currencyRate))).forEach((lvl3key, lvl3dtos) -> {
                            int currency_id = (Integer)lvl3key.getValue0();
                            BigDecimal currencyRate = (BigDecimal)lvl3key.getValue1();
                            MJournal journal = this.createJournal(journalBatch, (MAcctSchema)accountingSchema.get(), currency_id, conversionTypeId.get(), currencyRate, project_id, projectTrxName);
                            MCurrency sourceCurrency = new MCurrency(this.getCtx(), currency_id, projectTrxName);
                            AtomicInteger lineNo = new AtomicInteger(10);
                            ArrayList revenueRecognitionRuns = new ArrayList();
                            lvl3dtos.stream().collect(Collectors.groupingBy(dto -> new Quartet<Integer, Integer, Integer, Integer>(Integer.valueOf(dto.UnEarnedRevenue_A), dto.P_Revenue_A, dto.plan_id, dto.salesRegion_id))).forEach((lvl4key, lvl4dtos) -> {
                                int unearnedrevenue_a = (Integer)lvl4key.getValue0();
                                int p_revenue_a = (Integer)lvl4key.getValue1();
                                int plan_id = (Integer)lvl4key.getValue2();
                                int salesregion_id = (Integer)lvl4key.getValue3();
                                X_C_ValidCombination unEarnedRevenueCombination2 = new X_C_ValidCombination(this.getCtx(), unearnedrevenue_a, projectTrxName);
                                X_C_ValidCombination productRevenueCombination2 = new X_C_ValidCombination(this.getCtx(), p_revenue_a, projectTrxName);
                                MRevenueRecognitionPlan revenuePlan = new MRevenueRecognitionPlan(this.getCtx(), plan_id, projectTrxName);
                                MOrderLine source = new MOrderLine(this.getCtx(), revenuePlan.get_ValueAsInt("C_OrderLine_ID"), projectTrxName);
                                BigDecimal recognizedAmount = Env.ZERO;
                                for (Dto lvl3dto : lvl4dtos) {
                                    MRevenueRecognitionRun mRevenueRecognitionRun = new MRevenueRecognitionRun(this.getCtx(), lvl3dto.run_id, projectTrxName);
                                    BigDecimal rAmt = mRevenueRecognitionRun.getRecognizedAmt();
                                    if (rAmt != null && currencyRate != null) {
                                        BigDecimal runRecognizedAmtAcct = rAmt.multiply(currencyRate);
                                        mRevenueRecognitionRun.set_ValueOfColumn("CurrencyRate", (Object)currencyRate);
                                        mRevenueRecognitionRun.set_ValueOfColumn("RecognizedAmtAcct", (Object)runRecognizedAmtAcct);
                                    }
                                    if (!source.getC_Order().isSOTrx()) {
                                        rAmt = rAmt.negate();
                                    }
                                    recognizedAmount = recognizedAmount.add(rAmt);
                                    revenueRecognitionRuns.add(mRevenueRecognitionRun);
                                }
                                this.createJournalLine(journal, unEarnedRevenueCombination2, sourceCurrency, source, recognizedAmount, lineNo, salesregion_id);
                                this.createJournalLine(journal, productRevenueCombination2, sourceCurrency, source, recognizedAmount.negate(), lineNo, salesregion_id);
                            });
                            for (MRevenueRecognitionRun revenueRun : revenueRecognitionRuns) {
                                revenueRun.setGL_Journal_ID(journal.getGL_Journal_ID());
                                MRevenueRecognitionBatch mRevenueRecognitionBatch = this.getRevenueRecognitionBatch(journalBatch);
                                if (mRevenueRecognitionBatch != null && mRevenueRecognitionBatch.get_ID() > 0) {
                                    revenueRun.setC_RevenueRecognition_Batch_ID(mRevenueRecognitionBatch.get_ID());
                                    revenueRun.setGL_JournalBatch_ID(mRevenueRecognitionBatch.getGL_JournalBatch_ID());
                                }
                                revenueRun.saveEx();
                            }
                        });
                        if ("CO".equalsIgnoreCase(this.getDocAction())) {
                            journalBatch.processIt("CO");
                            journalBatch.saveEx();
                        }
                    });
                    this.addLog("OK" + msgProjectLog + " - @GL_JournalBatch_ID@ " + journalBatchStr.get() + " | @ProcessOK@");
                    projSuccess.addAndGet(1);
                }
                catch (Exception e) {
                    this.addLog("@Error@" + msgProjectLog + e.getMessage());
                    e.printStackTrace();
                }
            });
        });
        long durationTime = System.currentTimeMillis() - startTime;
        return "@C_Project_ID@ OK: " + projSuccess.get() + " / " + projAcu.get() + " | " + DurationFormatUtils.formatDuration(durationTime, "HH:mm:ss");
    }

    private MRevenueRecognitionBatch getRevenueRecognitionBatch(MJournalBatch mJournalBatch) {
        return this.revenueBatches.get(mJournalBatch.get_ID());
    }

    private MJournalBatch createJournalBatch(MAcctSchema accountingSchema, int org_id, int project_id, String projectTrxName) {
        MJournalBatch journalBatch = new MJournalBatch(this.getCtx(), 0, projectTrxName);
        journalBatch.setAD_Org_ID(org_id);
        StringBuilder journalBatchDescription = new StringBuilder();
        Optional.ofNullable(journalBatch.getDescription()).ifPresent(batchDescription -> journalBatchDescription.append((String)batchDescription).append(" "));
        journalBatchDescription.append(this.getName()).append(" @DateAcct@ ").append(this.getDateAcct());
        journalBatch.setDateAcct(this.getDateAcct());
        journalBatch.setDateDoc(this.getDateAcct());
        journalBatch.setDescription(Msg.parseTranslation(this.getCtx(), journalBatchDescription.toString()));
        journalBatch.setC_DocType_ID(this.getDocTypeTargetId());
        journalBatch.setDateDoc(this.getDateAcct());
        journalBatch.setDateAcct(this.getDateAcct());
        journalBatch.setC_Currency_ID(accountingSchema.getC_Currency_ID());
        journalBatch.saveEx();
        MProject mProject = new MProject(this.getCtx(), project_id, projectTrxName);
        MRevenueRecognitionBatch mRevenueRecognitionBatch = new MRevenueRecognitionBatch(this.getCtx(), 0, projectTrxName);
        mRevenueRecognitionBatch.setGL_JournalBatch_ID(journalBatch.get_ID());
        mRevenueRecognitionBatch.setAD_Org_ID(org_id);
        try {
            mRevenueRecognitionBatch.setC_Project_ID(mProject.get_ID());
            mRevenueRecognitionBatch.setS_Contract_ID(mProject.get_ValueAsInt("S_Contract_ID"));
            mRevenueRecognitionBatch.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        mRevenueRecognitionBatch.saveEx();
        this.revenueBatches.put(journalBatch.get_ID(), mRevenueRecognitionBatch);
        return journalBatch;
    }

    private MJournal createJournal(MJournalBatch journalBatch, MAcctSchema accountingSchema, int currencyID, int conversionTypeId, BigDecimal currencyRate, int projectID, String projectTrxName) {
        MDocType documentType = MDocType.get(this.getCtx(), this.getDocTypeTargetId());
        Integer glCategoryId = Optional.ofNullable(MGLCategory.getDefaultSystem(this.getCtx()).get_ID()).orElseGet(() -> documentType.getGL_Category_ID());
        MJournal journal = new MJournal(journalBatch);
        journal.setC_DocType_ID(documentType.getC_DocType_ID());
        journal.setDateAcct(this.getDateAcct());
        journal.setDateDoc(this.getDateAcct());
        journal.setC_AcctSchema_ID(accountingSchema.get_ID());
        journal.setC_Currency_ID(currencyID);
        journal.setC_ConversionType_ID(conversionTypeId);
        journal.setCurrencyRate(currencyRate);
        journal.setGL_Category_ID(glCategoryId);
        journal.setPostingType("A");
        MProject mProject = new MProject(this.getCtx(), projectID, projectTrxName);
        MSContract msContract = new MSContract(this.getCtx(), mProject.get_ValueAsInt("S_Contract_ID"), projectTrxName);
        String journalDescription = "@S_Contract_ID@ " + msContract.getDocumentNo() + " @M_Project_ID@ " + mProject.getName() + " (" + mProject.getValue() + ")";
        journal.setDescription(Msg.parseTranslation(Env.getCtx(), journalDescription));
        journal.saveEx();
        return journal;
    }

    private MJournalLine createJournalLine(MJournal journal, I_C_ValidCombination combination, MCurrency currency, MOrderLine source, BigDecimal recognizedAmount, AtomicInteger lineNo, int cSalesRegionID) {
        MJournalLine journalLine = new MJournalLine(journal);
        journalLine.setLine(lineNo.getAndUpdate(no -> no + 10));
        journalLine.setAccount_ID(combination.getAccount_ID());
        journalLine.setC_Currency_ID(currency.getC_Currency_ID());
        journalLine.setCurrencyRate(journal.getCurrencyRate());
        journalLine.setC_SalesRegion_ID(cSalesRegionID);
        StringBuilder journalDescriptionLine = new StringBuilder();
        try {
            MOrder mOrder = (MOrder)source.getC_Order();
            journalDescriptionLine.append(mOrder.getC_DocType().getName() + " " + mOrder.getDocumentNo());
        }
        catch (Exception mOrder) {
            // empty catch block
        }
        journalDescriptionLine.append(" @C_Currency_ID@ ").append(currency.getISO_Code());
        if (recognizedAmount.compareTo(Env.ZERO) > 0) {
            journalLine.setAmtSourceDr(recognizedAmount.abs());
            journalLine.setAmtAcctDr(recognizedAmount.multiply(journal.getCurrencyRate()).abs());
            journalLine.setAmtSourceCr(BigDecimal.ZERO);
            journalDescriptionLine.append(" @RecognizedAmt@ ").append(recognizedAmount.abs().toString());
        } else {
            journalLine.setAmtSourceDr(BigDecimal.ZERO);
            journalLine.setAmtAcctDr(BigDecimal.ZERO);
            journalLine.setAmtSourceCr(recognizedAmount.abs());
            journalDescriptionLine.append(" @RecognizedAmt@ ").append(recognizedAmount.abs().toString());
        }
        journalLine.setDescription(Msg.parseTranslation(this.getCtx(), journalDescriptionLine.toString()));
        int s_contract_id = ((MOrder)source.getC_Order()).get_ValueAsInt("S_Contract_ID");
        if (s_contract_id > 0) {
            journalLine.set_ValueOfColumn("S_Contract_ID", (Object)s_contract_id);
        }
        if (source.getC_Project_ID() != 0 || source.getC_Order().getC_Project_ID() != 0) {
            journalLine.setC_Project_ID(Utils.firstNot0(source.getC_Project_ID(), source.getC_Order().getC_Project_ID()));
        }
        if (source.getC_Activity_ID() != 0) {
            journalLine.setC_Activity_ID(source.getC_Activity_ID());
        }
        if (source.getC_Campaign_ID() != 0) {
            journalLine.setC_Campaign_ID(source.getC_Campaign_ID());
        }
        if (source.getUser1_ID() != 0 || source.getC_Order().getUser1_ID() != 0) {
            journalLine.setUser1_ID(Utils.firstNot0(source.getUser1_ID(), source.getC_Order().getUser1_ID()));
        }
        if (source.getUser2_ID() != 0) {
            journalLine.setUser2_ID(source.getUser2_ID());
        }
        if (source.getUser3_ID() != 0) {
            journalLine.setUser3_ID(source.getUser3_ID());
        }
        if (source.getUser4_ID() != 0 || source.getC_Order().getUser4_ID() != 0) {
            journalLine.setUser4_ID(Utils.firstNot0(source.getUser4_ID(), source.getC_Order().getUser4_ID()));
        }
        if (source.getC_BPartner_ID() != 0) {
            journalLine.setC_BPartner_ID(source.getC_BPartner_ID());
        }
        journalLine.saveEx();
        return journalLine;
    }

    private class Dto {
        private int run_id;
        private int client_id;
        private int org_id;
        private int contract_id;
        private BigDecimal contractDocumentNo;
        private int project_id;
        private String projectValue;
        private int currency_id;
        private BigDecimal currencyRate;
        private int UnEarnedRevenue_A;
        private int P_Revenue_A;
        private int plan_id;
        private int salesRegion_id;
        private int order_id;

        private Dto() {
        }
    }
}

