/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import com.eevolution.model.X_S_Contract;
import com.eevolution.model.X_S_ContractLine;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.spin.process.CreateInvoiceFromServiceContractAbstract;

public class CreateInvoiceFromServiceContract
extends CreateInvoiceFromServiceContractAbstract {
    private int created = 0;
    private StringBuffer generatedDocuments = new StringBuffer();
    private Hashtable<Integer, MInvoice> invoices;
    private Hashtable<Integer, Timestamp> dateLastRunHash;

    @Override
    protected String doIt() throws Exception {
        this.invoices = new Hashtable();
        this.dateLastRunHash = new Hashtable();
        for (Integer key : this.getSelectionKeys()) {
            Timestamp dateLastRun;
            int contractLineId = this.getSelectionAsInt(key, "C_S_ContractLine_ID");
            Timestamp dateNextRun = this.getSelectionAsTimestamp(key, "C_DateNextRun");
            X_S_ContractLine contractLine = new X_S_ContractLine(this.getCtx(), contractLineId, this.get_TrxName());
            X_S_Contract contract = new X_S_Contract(this.getCtx(), contractLine.getS_Contract_ID(), this.get_TrxName());
            MInvoice invoice = this.getInvoice(contract, contractLine);
            this.createInvoiceLine(contractLine, invoice, dateNextRun);
            if (dateNextRun == null || (dateLastRun = this.dateLastRunHash.get(contractLineId)) != null && dateNextRun.getTime() <= dateLastRun.getTime()) continue;
            this.dateLastRunHash.put(contractLineId, dateNextRun);
        }
        if (this.invoices.size() > 0) {
            this.invoices.entrySet().stream().forEach(invoiceSet -> {
                MInvoice invoice = (MInvoice)invoiceSet.getValue();
                invoice.processIt(this.getDocAction());
                invoice.saveEx();
            });
        }
        if (this.dateLastRunHash.size() > 0) {
            this.dateLastRunHash.entrySet().stream().forEach(dateRunningSet -> {
                Timestamp newDate = (Timestamp)dateRunningSet.getValue();
                X_S_ContractLine contractLine = new X_S_ContractLine(this.getCtx(), (Integer)dateRunningSet.getKey(), this.get_TrxName());
                contractLine.setDateLastRun(newDate);
                contractLine.saveEx();
            });
        }
        return "@Created@ " + this.created + (String)(this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private MInvoice getInvoice(X_S_Contract contract, X_S_ContractLine contractLine) {
        MInvoice invoice;
        int bPartnerId = contractLine.getC_BPartner_ID();
        if (bPartnerId == 0) {
            bPartnerId = contract.getC_BPartner_ID();
        }
        if ((invoice = this.invoices.get(bPartnerId)) != null) {
            return invoice;
        }
        invoice = new MInvoice(this.getCtx(), 0, null);
        invoice.setDateInvoiced(this.getDateInvoiced());
        invoice.setDateAcct(this.getDateInvoiced());
        invoice.setClientOrg(contractLine.getAD_Client_ID(), contractLine.getAD_Org_ID());
        invoice.set_ValueOfColumn("S_Contract_ID", (Object)contract.getS_Contract_ID());
        if (this.getDocTypeTargetId() > 0) {
            invoice.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            invoice.setC_DocTypeTarget_ID("ARI");
        }
        MBPartner businessPartner = null;
        businessPartner = contract.getBill_BPartner_ID() > 0 ? MBPartner.get(this.getCtx(), contract.getBill_BPartner_ID()) : MBPartner.get(this.getCtx(), bPartnerId);
        invoice.setBPartner(businessPartner);
        invoice.setSalesRep_ID(this.getAD_User_ID());
        MPriceList priceList = MPriceList.get(this.getCtx(), contract.getM_PriceList_ID(), this.get_TrxName());
        invoice.setC_Currency_ID(priceList.getC_Currency_ID());
        invoice.setM_PriceList_ID(contract.getM_PriceList_ID());
        if (contractLine.getC_BPartner_Location_ID() > 0) {
            invoice.setC_BPartner_Location_ID(contractLine.getC_BPartner_Location_ID());
        }
        invoice.saveEx();
        this.invoices.put(businessPartner.getC_BPartner_ID(), invoice);
        ++this.created;
        this.addToMessage(invoice.getDocumentNo());
        return invoice;
    }

    private void createInvoiceLine(X_S_ContractLine contractLine, MInvoice invoice, Timestamp serviceDate) {
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        BigDecimal qtyInvoiced = null;
        BigDecimal qtyEntered = contractLine.getQtyEntered();
        BigDecimal priceEntered = contractLine.getPriceEntered();
        int precision = 2;
        if (contractLine.getM_Product_ID() > 0) {
            int uomId = contractLine.getC_UOM_ID();
            MProduct product = MProduct.get(this.getCtx(), contractLine.getM_Product_ID());
            if (product != null) {
                invoiceLine.setM_Product_ID(product.getM_Product_ID(), uomId);
                precision = product.getUOMPrecision();
                if (product.getC_UOM_ID() != uomId) {
                    qtyEntered = qtyEntered.setScale(precision, 5);
                    qtyInvoiced = MUOMConversion.convertProductFrom(Env.getCtx(), contractLine.getM_Product_ID(), uomId, qtyEntered);
                    priceEntered = MUOMConversion.convertProductFrom(Env.getCtx(), contractLine.getM_Product_ID(), uomId, priceEntered);
                }
            }
        } else {
            invoiceLine.setC_Charge_ID(contractLine.getC_Charge_ID());
        }
        qtyEntered = qtyEntered.setScale(precision, 5);
        if (qtyInvoiced == null) {
            qtyInvoiced = qtyEntered;
        }
        invoiceLine.setQty(qtyEntered);
        invoiceLine.setQtyInvoiced(qtyInvoiced);
        invoiceLine.setPrice(priceEntered);
        invoiceLine.setDescription(contractLine.getDescription());
        invoiceLine.setTax();
        invoiceLine.set_ValueOfColumn("S_ContractLine_ID", (Object)contractLine.getS_ContractLine_ID());
        invoiceLine.set_ValueOfColumn("ServiceDate", (Object)serviceDate);
        invoiceLine.saveEx();
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }
}

