/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MCommissionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.process.CommissionOrderCreateAbstract;

public class CommissionOrderCreate
extends CommissionOrderCreateAbstract {
    private int created = 0;
    private StringBuffer generatedDocuments = new StringBuffer();
    private Hashtable<Integer, MOrder> orders;

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - C_CommissionRun_ID=" + this.getRecord_ID());
        MCommissionRun commissionRun = new MCommissionRun(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (commissionRun.getC_CommissionRun_ID() == 0) {
            throw new IllegalArgumentException("@C_CommissionRun_ID@ @NotFound@");
        }
        if (Env.ZERO.compareTo(commissionRun.getGrandTotal()) == 0) {
            throw new IllegalArgumentException("@GrandTotal@ = 0");
        }
        if (!commissionRun.getDocStatus().equals("CO")) {
            throw new IllegalArgumentException("@C_CommissionRun_ID@ @NotValid@");
        }
        MCommission commissionDefinition = new MCommission(this.getCtx(), commissionRun.getC_Commission_ID(), this.get_TrxName());
        if (commissionDefinition.getC_Commission_ID() == 0) {
            throw new IllegalArgumentException("@C_Commission_ID@ @NotFound@");
        }
        if (commissionDefinition.getC_Charge_ID() == 0 && commissionDefinition.get_ValueAsInt("M_Product_ID") == 0) {
            throw new IllegalArgumentException("@C_Commission_ID@ - (@M_Product_ID@ / @C_Charge_ID@) @NotFound@");
        }
        this.orders = new Hashtable();
        commissionRun.getCommissionAmtList().stream().filter(commissionAmt -> commissionAmt.getCommissionAmt() != null && commissionAmt.getCommissionAmt().compareTo(Env.ZERO) != 0).forEach(commissionAmt -> {
            MOrder order = this.getOrder(commissionDefinition, commissionRun, (MCommissionAmt)commissionAmt);
            this.createOrderLine((MCommissionAmt)commissionAmt, order, commissionDefinition.getC_Charge_ID(), commissionDefinition.get_ValueAsInt("M_Product_ID"));
        });
        AtomicBoolean isSplit = new AtomicBoolean();
        try {
            isSplit.set("S".equalsIgnoreCase(commissionRun.getC_Commission().getDocBasisType()));
        }
        catch (Exception e) {
            isSplit.set(false);
        }
        AtomicBoolean isSplitBillable = new AtomicBoolean();
        try {
            MCommissionType mCommissionType = new MCommissionType(this.getCtx(), commissionDefinition.get_ValueAsInt("C_CommissionType_ID"), this.get_TrxName());
            isSplitBillable.set(mCommissionType.get_ValueAsBoolean("IsSplitBillable"));
        }
        catch (Exception e) {
            isSplitBillable.set(false);
        }
        AtomicBoolean generateNegativeOrder = new AtomicBoolean(true);
        try {
            generateNegativeOrder.set(!commissionDefinition.get_ValueAsBoolean("NotGenerateNegative"));
        }
        catch (Exception e) {
            generateNegativeOrder.set(true);
        }
        if (this.orders.size() > 0) {
            this.orders.entrySet().stream().forEach(orderSet -> {
                int c_project_id;
                MOrder order = (MOrder)orderSet.getValue();
                if (isSplit.get()) {
                    boolean positive = commissionRun.getGrandTotal().compareTo(Env.ZERO) > 0;
                    MDocType mDocType = (MDocType)new Query(this.getCtx(), "C_DocType", "IsSplitDocuments=? AND IsShipConfirm=? AND IsSOTrx=?", this.get_TrxName()).setParameters(true, true, !positive).setOnlyActiveRecords(true).first();
                    order.setIsSOTrx(!positive);
                    if (mDocType != null && mDocType.get_ID() > 0) {
                        order.setC_DocType_ID(mDocType.get_ID());
                        order.setC_DocTypeTarget_ID(mDocType.get_ID());
                    }
                    order.set_ValueOfColumn("IsAllowToInvoice", (Object)isSplitBillable.get());
                }
                boolean isDirectInvoice = false;
                try {
                    MOrder originalOrder = new MOrder(this.getCtx(), commissionRun.get_ValueAsInt("C_Order_ID"), this.get_TrxName());
                    if (!originalOrder.isSOTrx()) {
                        isDirectInvoice = originalOrder.get_ValueAsBoolean("IsDirectInvoice");
                    }
                }
                catch (Exception e) {
                    isDirectInvoice = false;
                }
                if (isDirectInvoice) {
                    order.set_ValueOfColumn("IsAllowToInvoice", (Object)true);
                }
                order.processIt(this.getDocAction());
                order.saveEx();
                if (isSplit.get() && isSplitBillable.get() && generateNegativeOrder.get() && (c_project_id = commissionRun.get_ValueAsInt("C_Project_ID")) > 0) {
                    MOrderLine[] lines;
                    MProject mProject = new MProject(order.getCtx(), c_project_id, order.get_TrxName());
                    MCommissionRun originalCRun = this.getOriginalCRun(commissionRun, order.getDateOrdered(), mProject);
                    MOrder reverseOrder = new MOrder(order.getCtx(), 0, order.get_TrxName());
                    PO.copyValues(order, reverseOrder);
                    reverseOrder.setDocumentNo(null);
                    reverseOrder.setDateOrdered(order.getDateOrdered());
                    reverseOrder.setDatePromised(order.getDatePromised());
                    reverseOrder.setDateAcct(order.getDateAcct());
                    reverseOrder.setDatePrinted(order.getDatePrinted());
                    reverseOrder.setPOReference(order.getDocumentNo());
                    reverseOrder.addDescription(Msg.parseTranslation(order.getCtx(), "@Generated@ [@C_Order_ID@ " + order.getDocumentNo()) + "]");
                    reverseOrder.setDocStatus("DR");
                    reverseOrder.setDocAction("CO");
                    reverseOrder.setTotalLines(Env.ZERO);
                    reverseOrder.setGrandTotal(Env.ZERO);
                    reverseOrder.setIsSOTrx(order.isSOTrx());
                    reverseOrder.setRef_Order_ID(-1);
                    reverseOrder.setIsDropShip(false);
                    reverseOrder.setDropShip_BPartner_ID(0);
                    reverseOrder.setDropShip_Location_ID(0);
                    reverseOrder.setDropShip_User_ID(0);
                    reverseOrder.set_ValueOfColumn("IsAllowToInvoice", (Object)false);
                    reverseOrder.saveEx();
                    for (MOrderLine line : lines = order.getLines(true, null)) {
                        MOrderLine reverseOrderLine = new MOrderLine(reverseOrder);
                        reverseOrderLine.setOrder(reverseOrder);
                        reverseOrderLine.setProduct(line.getProduct());
                        reverseOrderLine.setC_Charge_ID(line.getC_Charge_ID());
                        reverseOrderLine.setLineNetAmt(Env.ZERO);
                        reverseOrderLine.setQty(Env.ONE);
                        reverseOrderLine.setPrice(line.getPriceEntered().negate());
                        reverseOrderLine.setC_UOM_ID(line.getC_UOM_ID());
                        reverseOrderLine.setTax();
                        reverseOrderLine.setUser1_ID(line.getUser1_ID());
                        reverseOrderLine.setUser3_ID(line.getUser3_ID());
                        reverseOrderLine.setUser4_ID(line.getUser4_ID());
                        reverseOrderLine.saveEx();
                    }
                    reverseOrder.set_ValueOfColumn("C_CommissionRun_ID", (Object)originalCRun.get_ID());
                    reverseOrder.processIt("CO");
                    reverseOrder.saveEx();
                }
            });
        }
        return "@Created@ " + this.created + (String)(this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private MCommissionRun getOriginalCRun(MCommissionRun commissionRun, Timestamp date, MProject mProject) {
        MPeriod currentPeriod = MPeriod.get(this.getCtx(), date);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String periodStartDate = sdf.format(currentPeriod.getStartDate());
        String periodEndDate = sdf.format(currentPeriod.getEndDate());
        String originalCRunWhere = "C_Project_ID=? AND EXISTS (   SELECT 1    FROM C_Commission c   JOIN C_CommissionType cType ON c.C_CommissionType_ID=cType.C_CommissionType_ID   WHERE C_CommissionRun.C_Commission_ID=c.C_Commission_ID   AND c.DocBasisType='S'   AND cType.IsSplitBillable='N' ) AND docStatus='CO' AND DateDoc BETWEEN '" + periodStartDate + "' AND '" + periodEndDate + "'";
        MCommissionRun originalCRun = (MCommissionRun)new Query(this.getCtx(), "C_CommissionRun", originalCRunWhere, this.get_TrxName()).setParameters(commissionRun.get_ValueAsInt("C_Project_ID")).first();
        if (originalCRun != null && originalCRun.get_ID() > 0) {
            return originalCRun;
        }
        Timestamp projectStartDate = mProject.getDateStart();
        if (projectStartDate == null) {
            throw new AdempiereException("@C_Project_ID@ (" + mProject.getValue() + ") -> @DateStart@ @not.found@");
        }
        if (date.compareTo(projectStartDate) < 0) {
            String projectName;
            try {
                projectName = new MProject(commissionRun.getCtx(), commissionRun.get_ValueAsInt("C_Project_ID"), commissionRun.get_TrxName()).getName();
            }
            catch (Exception e) {
                projectName = "--";
            }
            throw new AdempiereException("@C_Project_ID@ (" + mProject.getValue() + ") " + projectName + " -> @C_CommissionRun_ID@ @not.found@");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        Timestamp dateMinusOneMonth = new Timestamp(c.getTimeInMillis());
        return this.getOriginalCRun(commissionRun, dateMinusOneMonth, mProject);
    }

    private MOrder getOrder(MCommission commissionDefinition, MCommissionRun commissionRun, MCommissionAmt commissionAmt) {
        int currencyId;
        MOrder order;
        int bPartnerId = this.getBPartnerId();
        if (bPartnerId <= 0) {
            bPartnerId = commissionAmt.getC_BPartner_ID();
        }
        if ((order = this.orders.get(bPartnerId)) != null) {
            return order;
        }
        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setClientOrg(commissionAmt.getAD_Client_ID(), commissionAmt.getAD_Org_ID());
        order.setIsSOTrx(this.isSOTrx());
        if (this.getDocTypeId() > 0) {
            order.setC_DocTypeTarget_ID(this.getDocTypeId());
        } else {
            order.setC_DocTypeTarget_ID();
        }
        MBPartner businessPartner = MBPartner.get(this.getCtx(), bPartnerId);
        order.setBPartner(businessPartner);
        String billBPartnerWhere = "C_BPartner_ID=? AND IsBillTo='Y'";
        Object bpRelation = new Query(order.getCtx(), "C_BP_Relation", billBPartnerWhere, order.get_TrxName()).setParameters(order.getC_BPartner_ID()).setOnlyActiveRecords(true).first();
        PO billBPartner = null;
        if (bpRelation != null) {
            billBPartner = new MBPartner(order.getCtx(), ((PO)bpRelation).get_ValueAsInt("C_BPartnerRelation_ID"), order.get_TrxName());
        }
        if (billBPartner != null) {
            order.setBill_BPartner_ID(billBPartner.get_ID());
        }
        if ((currencyId = commissionRun.get_ValueAsInt("C_Currency_ID")) == 0) {
            currencyId = commissionDefinition.getC_Currency_ID();
        }
        MCurrency currency = MCurrency.get(this.getCtx(), currencyId);
        MPriceList defaultPriceList = null;
        defaultPriceList = commissionDefinition.get_ValueAsBoolean("IsTaxIncluded") ? MPriceList.get(this.getCtx(), this.isSOTrx(), currency.getISO_Code(), true) : MPriceList.getDefault(this.getCtx(), this.isSOTrx(), currency.getISO_Code());
        if (defaultPriceList == null) {
            throw new IllegalArgumentException("@DefaultPriceListCurrencyNotFound@ (@C_Currency_ID@: " + currency.getISO_Code() + ")");
        }
        order.setM_PriceList_ID(defaultPriceList.getM_PriceList_ID());
        order.setSalesRep_ID(this.getAD_User_ID());
        order.setDateOrdered(this.getDateOrdered());
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDescription(Msg.parseTranslation(this.getCtx(), "@Generate@: @C_CommissionRun_ID@ " + commissionRun.getDocumentNo()));
        if (commissionRun.get_ValueAsInt("C_Order_ID") > 0) {
            MOrder sourceOrder = new MOrder(this.getCtx(), commissionRun.get_ValueAsInt("C_Order_ID"), this.get_TrxName());
            order.addDescription(Msg.parseTranslation(this.getCtx(), "@C_Order_ID@ " + sourceOrder.getDocumentNo()));
            if (sourceOrder.getC_Project_ID() > 0) {
                order.setC_Project_ID(sourceOrder.getC_Project_ID());
            }
        }
        if (commissionRun.get_ValueAsInt("S_Contract_ID") > 0) {
            order.set_ValueOfColumn("S_Contract_ID", (Object)commissionRun.get_ValueAsInt("S_Contract_ID"));
        }
        if (order.getC_Project_ID() == 0 && commissionRun.get_ValueAsInt("C_Project_ID") > 0) {
            order.setC_Project_ID(commissionRun.get_ValueAsInt("C_Project_ID"));
        }
        order.set_ValueOfColumn("C_CommissionRun_ID", (Object)commissionRun.getC_CommissionRun_ID());
        order.saveEx();
        this.orders.put(bPartnerId, order);
        ++this.created;
        this.addToMessage(order.getDocumentNo());
        return order;
    }

    private void createOrderLine(MCommissionAmt commissionAmt, MOrder order, int chargeId, int productId) {
        MOrderLine orderLine = new MOrderLine(order);
        MCommissionLine comLine = (MCommissionLine)commissionAmt.getC_CommissionLine();
        if (productId > 0) {
            MProduct product = MProduct.get(this.getCtx(), productId);
            orderLine.setProduct(product);
        } else {
            orderLine.setC_Charge_ID(chargeId);
        }
        orderLine.setQty(Env.ONE);
        orderLine.setPrice(commissionAmt.getCommissionAmt().abs());
        orderLine.setTax();
        orderLine.setUser1_ID(order.getUser1_ID());
        orderLine.setUser3_ID(comLine.get_ValueAsInt("User3_ID"));
        orderLine.saveEx();
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }
}

