/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MSession;
import org.compiere.model.Query;
import org.spin.process.CloseExpiredSessionsAbstract;

public class CloseExpiredSessions
extends CloseExpiredSessionsAbstract {
    private AtomicInteger counter = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        long tolerance = System.currentTimeMillis() - (long)this.getTimeout();
        this.getActiveSessionList().stream().filter(session -> session.getUpdated().getTime() < tolerance).forEach(session -> {
            try {
                session.logout();
                this.counter.getAndIncrement();
            }
            catch (Exception e) {
                this.addLog(e.getMessage());
            }
        });
        return "@Closed@: " + this.counter.get();
    }

    private List<MSession> getActiveSessionList() {
        return new Query(this.getCtx(), "AD_Session", "Processed = 'N'", this.get_TrxName()).setOnlyActiveRecords(true).list();
    }
}

