/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.LUY.model.X_LUY_CFEType;
import org.spin.model.X_WH_Withholding;

public class MWHWithholding
extends X_WH_Withholding
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20190611L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MWHWithholding(Properties ctx, int WH_Allocation_ID, String trxName) {
        super(ctx, WH_Allocation_ID, trxName);
    }

    public MWHWithholding(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public void setC_DocType_ID() {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID = ? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType = ?  AND IsActive = 'Y' ORDER BY AD_Org_ID, IsDefault DESC";
        int documentTypeId = DB.getSQLValue(null, sql, this.getAD_Client_ID(), "WHH");
        if (documentTypeId <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseType=WHH");
        } else {
            this.log.fine("(APS) - WHH");
            this.setC_DocType_ID(documentTypeId);
        }
    }

    @Override
    public boolean voidIt() {
        MInvoice invoice;
        MInvoice withholdingDoc;
        MInvoice declaration;
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.getWithholdingDeclaration_ID() != 0 && !(declaration = (MInvoice)this.getWithholdingDeclaration()).getDocStatus().equals("RE") && !declaration.getDocStatus().equals("VO")) {
            throw new AdempiereException("@DeclarationReferenceError@: @WithholdingDeclaration_ID@ " + declaration.getDocumentNo());
        }
        if (this.getC_Invoice_ID() != 0 && !(withholdingDoc = (MInvoice)this.getC_Invoice()).getDocStatus().equals("RE") && !withholdingDoc.getDocStatus().equals("VO")) {
            throw new AdempiereException("@WithholdingReferenceError@: @C_Invoice_ID@ " + withholdingDoc.getDocumentNo());
        }
        if (this.getC_Invoice_ID() != 0 && (invoice = (MInvoice)this.getC_Invoice()).getDocStatus().equals("CO")) {
            if (!invoice.processIt("RC")) {
                throw new AdempiereException(invoice.getProcessMsg());
            }
            invoice.saveEx();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public static List<MWHWithholding> getWithholdingFromInvoice(Properties context, int sourceInvoiceId, String transactionName) {
        return new Query(context, "WH_Withholding", "SourceInvoice_ID = ?", transactionName).setClient_ID().setParameters(sourceInvoiceId).setOnlyActiveRecords(true).list();
    }

    public static List<MWHWithholding> getWithholdingSourceFromInvoice(Properties context, int invoiceId, String transactionName) {
        return new Query(context, "WH_Withholding", "C_Invoice_ID = ?", transactionName).setClient_ID().setParameters(invoiceId).setOnlyActiveRecords(true).list();
    }

    public static List<MWHWithholding> getWithholdingSourceFromDeclaration(Properties context, int withholdingDeclarationId, String transactionName) {
        return new Query(context, "WH_Withholding", "WithholdingDeclaration_ID = ?", transactionName).setClient_ID().setParameters(withholdingDeclarationId).setOnlyActiveRecords(true).list();
    }

    public int getWHDocType() {
        Optional<MLUYCFEType> mluycfeType = MLUYCFEType.getResguardoCFEType(this.getCtx(), this.get_TrxName(), Env.getAD_Org_ID(this.getCtx()));
        return mluycfeType.map(X_LUY_CFEType::getC_DocType_ID).orElse(0);
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            } else if (docStatus.equalsIgnoreCase("DR") || docStatus.equalsIgnoreCase("IN") || docStatus.equalsIgnoreCase("IP")) {
                options[index++] = "CO";
            }
        }
        return index;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MWHAllocation[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    @Override
    public void setWithholdingDeclaration_ID(int WithholdingDeclaration_ID) {
        this.setIsDeclared(WithholdingDeclaration_ID > 0);
        super.setWithholdingDeclaration_ID(WithholdingDeclaration_ID);
    }
}

