/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.model.X_WH_Definition;

public class MWHDefinition
extends X_WH_Definition {
    private static final long serialVersionUID = -7050562622116465459L;
    private static CCache<Integer, MWHDefinition> definitionCacheIds = new CCache("WH_Definition", 30);
    private static CCache<Integer, List<MWHDefinition>> wihholdingDefinitionFromDocumentTypeCacheValues = new CCache("WH_Definition_DocumentType", 30);

    public MWHDefinition(Properties ctx, int WH_Setting_ID, String trxName) {
        super(ctx, WH_Setting_ID, trxName);
    }

    public MWHDefinition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MWHDefinition getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MWHDefinition definition = definitionCacheIds.get(definitionId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MWHDefinition)new Query(ctx, "WH_Definition", "WH_Definition_ID=?", trxName).setClient_ID().setParameters(definitionId).first();
        if (definition != null && definition.get_ID() > 0) {
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static List<MWHDefinition> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || definitionCacheIds.size() > 0) {
            List<MWHDefinition> definitionList = new Query(Env.getCtx(), "WH_Definition", null, trxName).setClient_ID().setOrderBy("Name").list();
            definitionList.stream().forEach(setting -> definitionCacheIds.put(setting.getWH_Definition_ID(), (MWHDefinition)setting));
            return definitionList;
        }
        List<MWHDefinition> definitionList = definitionCacheIds.entrySet().stream().map(activity -> (MWHDefinition)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    public static List<MWHDefinition> getFromDocumentType(Properties ctx, int documentTypeId) {
        List<MWHDefinition> definitionList = wihholdingDefinitionFromDocumentTypeCacheValues.get(documentTypeId);
        if (definitionList != null) {
            return definitionList;
        }
        String whereClause = new String("EXISTS(SELECT 1 FROM WH_DefinitionLine WHERE C_DocType_ID = ? AND WH_Definition_ID = WH_Definition.WH_Definition_ID)");
        definitionList = new Query(ctx, "WH_Definition", whereClause, null).setClient_ID().setParameters(documentTypeId).setOnlyActiveRecords(true).list();
        wihholdingDefinitionFromDocumentTypeCacheValues.put(documentTypeId, definitionList);
        return definitionList;
    }

    public List<MWHSetting> getApplicability(String eventType) {
        MWHType withholdingType = MWHType.getById(this.getCtx(), this.getWH_Type_ID(), this.get_TrxName());
        return withholdingType.getApplicability(eventType);
    }

    public List<MWHSetting> getSettingList(String tableName, String eventModelValidator) {
        if (Util.isEmpty(tableName)) {
            return new ArrayList<MWHSetting>();
        }
        MWHType withholdingType = MWHType.getById(this.getCtx(), this.getWH_Type_ID(), this.get_TrxName());
        return withholdingType.getApplicability(tableName, eventModelValidator);
    }

    public List<MWHSetting> getSettingList(String eventType) {
        MWHType withholdingType = MWHType.getById(this.getCtx(), this.getWH_Type_ID(), this.get_TrxName());
        return withholdingType.getApplicability(eventType);
    }

    @Override
    public String toString() {
        return "MWHDefinition [getC_Charge_ID()=" + this.getC_Charge_ID() + ", getName()=" + this.getName() + ", getWH_Definition_ID()=" + this.getWH_Definition_ID() + "]";
    }
}

