/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_R_NoticeTemplate;
import org.compiere.model.MMailText;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MRNoticeTemplateEvent;

public class MRNoticeTemplate
extends X_R_NoticeTemplate {
    private static final long serialVersionUID = 572121553773316014L;
    private static CCache<Integer, MRNoticeTemplate> cache = new CCache("R_NoticeTemplate", 100);
    private static CCache<String, MRNoticeTemplate> cacheValue = new CCache("R_NoticeTemplate_Value", 100);
    private static CCache<String, MMailText> cacheMailTextValue = new CCache("R_MailText_Template", 100);

    public MRNoticeTemplate(Properties ctx, int requestTemplateId, String trxName) {
        super(ctx, requestTemplateId, trxName);
    }

    public MRNoticeTemplate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MRNoticeTemplate getById(Properties ctx, int requestTemplateId) {
        if (requestTemplateId <= 0) {
            return null;
        }
        MRNoticeTemplate requestTemplate = cache.get(requestTemplateId);
        if (requestTemplate != null) {
            return requestTemplate;
        }
        requestTemplate = new MRNoticeTemplate(ctx, requestTemplateId, null);
        if (requestTemplate.get_ID() == requestTemplateId) {
            cache.put(requestTemplateId, requestTemplate);
        } else {
            requestTemplate = null;
        }
        return requestTemplate;
    }

    public static MRNoticeTemplate getByType(Properties ctx, String templateType) {
        if (Util.isEmpty(templateType, true)) {
            return null;
        }
        int clientId = Env.getAD_Client_ID(ctx);
        String key = clientId + "#" + templateType;
        MRNoticeTemplate requestTemplate = cacheValue.get(key);
        if (requestTemplate != null) {
            return requestTemplate;
        }
        String whereClause = "TemplateType=? AND AD_Client_ID IN (?,?)";
        requestTemplate = (MRNoticeTemplate)new Query(ctx, "R_NoticeTemplate", "TemplateType=? AND AD_Client_ID IN (?,?)", null).setParameters(templateType, 0, clientId).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (requestTemplate != null) {
            cacheValue.put(key, requestTemplate);
            cache.put(requestTemplate.get_ID(), requestTemplate);
        }
        return requestTemplate;
    }

    public static MMailText getMailTemplate(Properties ctx, String templateType, String eventType) {
        if (Util.isEmpty(templateType, true) || Util.isEmpty(eventType, true)) {
            return null;
        }
        int clientId = Env.getAD_Client_ID(ctx);
        String key = clientId + "|" + templateType + "|" + eventType;
        MMailText mailTemplate = cacheMailTextValue.get(key);
        if (mailTemplate != null) {
            mailTemplate.clear();
            return mailTemplate;
        }
        String whereClause = "AD_Client_ID IN(?,?) AND EXISTS(SELECT 1 FROM R_NoticeTemplate rt INNER JOIN R_NoticeTemplateEvent rte ON(rte.R_NoticeTemplate_ID = rt.R_NoticeTemplate_ID) WHERE rte.R_MailText_ID = R_MailText.R_MailText_ID AND rte.EventType = ? AND rt.TemplateType = ? AND rt.IsActive = 'Y')";
        mailTemplate = (MMailText)new Query(ctx, "R_MailText", whereClause, null).setParameters(0, clientId, eventType, templateType).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (mailTemplate != null) {
            cacheMailTextValue.put(key, mailTemplate);
        }
        return mailTemplate;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            new Query(this.getCtx(), "AD_Ref_List", "AD_Reference_ID = ?", this.get_TrxName()).setParameters(54119).setOnlyActiveRecords(true).setOrderBy("Value").list().forEach(reference -> {
                MMailText mailText = new MMailText(this.getCtx(), 0, this.get_TrxName());
                mailText.setName(reference.getName());
                int index = reference.getName().indexOf(":");
                if (index > 0 && index < reference.getName().length()) {
                    mailText.setMailHeader("@DocumentNo@ - @Subject@ " + reference.getName().substring(index + 1));
                }
                mailText.setMailText(reference.getDescription());
                mailText.setIsHtml(true);
                mailText.saveEx();
                this.updateTranslations(mailText.getR_MailText_ID(), (MRefList)reference);
                MRNoticeTemplateEvent noticeEvent = new MRNoticeTemplateEvent(this.getCtx(), 0, this.get_TrxName());
                noticeEvent.setR_NoticeTemplate_ID(this.getR_NoticeTemplate_ID());
                noticeEvent.setEventType(reference.getValue());
                noticeEvent.setR_MailText_ID(mailText.getR_MailText_ID());
                noticeEvent.saveEx();
            });
        }
        return true;
    }

    private void updateTranslations(int mailTextId, MRefList reference) {
        String tableName = "R_MailText_Trl";
        List translationList = new Query(this.getCtx(), tableName, "R_MailText_ID = ?", this.get_TrxName()).setParameters(mailTextId).list();
        if (translationList == null || translationList.size() == 0) {
            return;
        }
        for (PO translation : translationList) {
            String language = translation.get_ValueAsString("AD_Language");
            String name = reference.get_Translation("Name", language);
            String description = reference.get_Translation("Description", language);
            if (Util.isEmpty(name) || Util.isEmpty(description)) continue;
            translation.set_ValueOfColumn("Name", (Object)name);
            int index = name.indexOf(":");
            if (index > 0 && index < name.length()) {
                translation.set_ValueOfColumn("MailHeader", (Object)("@DocumentNo@ - @Subject@ " + name.substring(index + 1)));
            }
            translation.set_ValueOfColumn("MailText", (Object)description);
            translation.saveEx();
        }
    }
}

