/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_Charge;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.util.Env;
import org.spin.investment.model.MFMRate;

public class Interest {
    private int rateId;
    private int chargeId;
    private BigDecimal interestRate;
    private BigDecimal taxRate;
    private Properties context;
    private String transactionName;
    private Timestamp runningDate;

    public final Interest withContext(Properties context) {
        this.context = context;
        return this;
    }

    public final Interest withTransactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public final int getRateId() {
        return this.rateId;
    }

    public final Interest withRateId(int rateId) {
        this.rateId = rateId;
        return this;
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final Timestamp getRunningDate() {
        return this.runningDate;
    }

    public final Interest withRunningDate(Timestamp runningDate) {
        this.runningDate = runningDate;
        return this;
    }

    public static Interest newInstance() {
        return new Interest();
    }

    public final int getChargeId() {
        return this.chargeId;
    }

    public final BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public final BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public Interest buildRate() {
        if (this.context == null) {
            throw new AdempiereException("Missing Context");
        }
        if (this.rateId <= 0) {
            throw new AdempiereException("Missing Rate ID");
        }
        if (this.rateId == 0) {
            return this;
        }
        X_C_Charge charge = null;
        if (this.rateId != 0) {
            MFMRate rate = MFMRate.getById(this.context, this.rateId);
            this.interestRate = rate.getValidRate(this.runningDate);
            charge = MCharge.get(this.context, rate.getC_Charge_ID());
        }
        if (charge != null) {
            MTaxCategory taxCategory = (MTaxCategory)charge.getC_TaxCategory();
            MTax tax = taxCategory.getDefaultTax();
            this.interestRate = this.interestRate.divide(Env.ONEHUNDRED);
            this.taxRate = tax.getRate().divide(Env.ONEHUNDRED);
            this.interestRate = this.interestRate.add(this.interestRate.multiply(this.taxRate));
        }
        return this;
    }

    public String toString() {
        return "Interest [rateId=" + this.rateId + ", chargeId=" + this.chargeId + ", interestRate=" + this.interestRate + ", taxRate=" + this.taxRate + ", runningDate=" + this.runningDate + "]";
    }
}

