/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_Charge;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.util.Env;
import org.spin.investment.model.MFMDunning;
import org.spin.investment.model.MFMDunningLevel;
import org.spin.investment.model.MFMRate;

public class Dunning {
    private int dunningId;
    private int dunningRateId;
    private int graceDay;
    private int chargeId;
    private BigDecimal interestRate;
    private BigDecimal taxRate;
    private Properties context;
    private String transactionName;
    private Timestamp runningDate;
    private MFMDunning dunning;

    public final Dunning withContext(Properties context) {
        this.context = context;
        return this;
    }

    public final Dunning withTransactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final Timestamp getRunningDate() {
        return this.runningDate;
    }

    public final Dunning withRunningDate(Timestamp runningDate) {
        this.runningDate = runningDate;
        return this;
    }

    public static Dunning newInstance() {
        return new Dunning();
    }

    public final int getDunningId() {
        return this.dunningId;
    }

    public final Dunning withDunningId(int dunningId) {
        this.dunningId = dunningId;
        return this;
    }

    public final int getDunningRateId() {
        return this.dunningRateId;
    }

    public final Dunning withDunningRateId(int dunningRateId) {
        this.dunningRateId = dunningRateId;
        return this;
    }

    public final int getGraceDay() {
        return this.graceDay;
    }

    public final int getChargeId() {
        return this.chargeId;
    }

    public final BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public final BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public Dunning buildRate() {
        if (this.context == null) {
            throw new AdempiereException("Missing Context");
        }
        if (this.dunningId <= 0) {
            throw new AdempiereException("Missing Dunning ID");
        }
        if (this.graceDay < 0) {
            throw new AdempiereException("Missing Grace Day");
        }
        if (this.runningDate == null) {
            this.runningDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.dunningRateId == 0 && this.dunningId == 0) {
            return null;
        }
        X_C_Charge charge = null;
        if (this.dunningRateId != 0) {
            MFMRate rate = MFMRate.getById(this.context, this.dunningRateId);
            this.interestRate = rate.getValidRate(this.runningDate);
            this.interestRate = this.interestRate != null ? this.interestRate.divide(Env.ONEHUNDRED) : Env.ZERO;
            charge = MCharge.get(this.context, rate.getC_Charge_ID());
        }
        if (charge != null) {
            MTaxCategory taxCategory = (MTaxCategory)charge.getC_TaxCategory();
            MTax tax = taxCategory.getDefaultTax();
            this.taxRate = tax.getRate();
            this.taxRate = this.taxRate != null ? this.taxRate.divide(Env.ONEHUNDRED) : Env.ZERO;
        }
        if (this.dunningId > 0) {
            this.dunning = MFMDunning.getById(this.context, this.dunningId);
        }
        return this;
    }

    public Dunning buildRateFromLevel(int daysDue) {
        int dunningLevelRateId;
        if (this.dunning == null) {
            return this;
        }
        MFMDunningLevel level = this.dunning.getValidLevelInstance(daysDue);
        if (level == null) {
            return this;
        }
        if (this.dunningRateId == 0 && (dunningLevelRateId = level.getFM_Rate_ID()) > 0) {
            MFMRate rate = MFMRate.getById(this.context, dunningLevelRateId);
            this.interestRate = rate.getValidRate(this.runningDate);
            MCharge charge = MCharge.get(this.context, rate.getC_Charge_ID());
            if (charge != null) {
                MTaxCategory taxCategory = (MTaxCategory)charge.getC_TaxCategory();
                MTax tax = taxCategory.getDefaultTax();
                this.interestRate = this.interestRate.divide(Env.ONEHUNDRED);
                this.taxRate = tax.getRate().divide(Env.ONEHUNDRED);
            }
        }
        if (this.interestRate == null || this.interestRate.doubleValue() == 0.0 || this.taxRate == null) {
            return this;
        }
        return this;
    }

    public final MFMDunning getDunning() {
        return this.dunning;
    }

    public String toString() {
        return "Dunning [dunningId=" + this.dunningId + ", dunningRateId=" + this.dunningRateId + ", graceDay=" + this.graceDay + ", chargeId=" + this.chargeId + ", interestRate=" + this.interestRate + ", taxRate=" + this.taxRate + ", runningDate=" + this.runningDate + "]";
    }
}

