/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.setup;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_ModelValidator;
import org.adempiere.core.domains.models.X_FM_AgreementType;
import org.adempiere.core.domains.models.X_FM_FunctionalApplicability;
import org.adempiere.core.domains.models.X_FM_FunctionalSetting;
import org.adempiere.core.domains.models.X_FM_Product;
import org.adempiere.core.domains.models.X_FM_ProductCategory;
import org.adempiere.core.domains.models.X_FM_TransactionType;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.util.ISetupDefinition;

public class InvestmentAndLoan
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";
    private final String FRENCH_LOAN_AMORTIZATION = "org.spin.util.FrenchLoanAmortization";
    private final String LOAN_MODEL_VALIDATOR = "org.spin.model.LoanManagementModelValidator";

    @Override
    public String doIt(Properties properties, String string) {
        this.createTransactionTypes(properties, string);
        this.createAgreementType(properties, string);
        X_FM_ProductCategory x_FM_ProductCategory = this.createFinancialProductCategory(properties, "ILC", "Interest Loan Category", string);
        this.createFinancialProduct(properties, x_FM_ProductCategory.getFM_ProductCategory_ID(), "AP", "Amortization Product", string);
        X_FM_FunctionalSetting x_FM_FunctionalSetting = this.createFunctionalSetting(properties, "FLA", "French Loan Amortization", "org.spin.util.FrenchLoanAmortization", string);
        this.createApplicability(properties, x_FM_FunctionalSetting.getFM_FunctionalSetting_ID(), x_FM_ProductCategory.getFM_ProductCategory_ID(), "FM_Agreement", "T", "DAPR", string);
        this.createDocumentType(properties, "FMA", "Loan", string);
        this.createModelValidator(properties, string);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private X_AD_ModelValidator createModelValidator(Properties properties, String string) {
        X_AD_ModelValidator x_AD_ModelValidator = (X_AD_ModelValidator)new Query(properties, "AD_ModelValidator", "ModelValidationClass = ?", string).setParameters("org.spin.model.LoanManagementModelValidator").setClient_ID().first();
        if (x_AD_ModelValidator != null && x_AD_ModelValidator.getAD_ModelValidator_ID() > 0) {
            return x_AD_ModelValidator;
        }
        x_AD_ModelValidator = new X_AD_ModelValidator(properties, 0, string);
        x_AD_ModelValidator.setName("Loan Management Validator");
        x_AD_ModelValidator.setEntityType("FMS");
        x_AD_ModelValidator.setDescription(SETUP_DESCRIPTION);
        x_AD_ModelValidator.setSeqNo(200);
        x_AD_ModelValidator.setModelValidationClass("org.spin.model.LoanManagementModelValidator");
        x_AD_ModelValidator.saveEx();
        return x_AD_ModelValidator;
    }

    private MDocType createDocumentType(Properties properties, String string, String string2, String string3) {
        MDocType mDocType = (MDocType)new Query(properties, "C_DocType", "Name = ?", string3).setParameters(string2).setClient_ID().first();
        if (mDocType != null && mDocType.getC_DocType_ID() > 0) {
            return mDocType;
        }
        mDocType = new MDocType(Env.getCtx(), 0, string3);
        mDocType.setName(string2);
        mDocType.setPrintName(string2);
        mDocType.setDocBaseType(string);
        mDocType.setGL_Category_ID();
        mDocType.setIsSOTrx(true);
        mDocType.setDescription(SETUP_DESCRIPTION);
        mDocType.saveEx();
        return mDocType;
    }

    private X_FM_Product createFinancialProduct(Properties properties, int n, String string, String string2, String string3) {
        X_FM_Product x_FM_Product = (X_FM_Product)new Query(properties, "FM_Product", "Value = ?", string3).setParameters(string).setClient_ID().first();
        if (x_FM_Product != null && x_FM_Product.getFM_Product_ID() > 0) {
            return x_FM_Product;
        }
        x_FM_Product = new X_FM_Product(Env.getCtx(), 0, string3);
        x_FM_Product.setValue(string);
        x_FM_Product.setName(string2);
        x_FM_Product.setFM_ProductCategory_ID(n);
        x_FM_Product.setC_Currency_ID(MCurrency.get(Env.getCtx(), "USD").getC_Currency_ID());
        MProduct mProduct = this.createProduct(properties, string, string2, string3);
        x_FM_Product.setM_Product_ID(mProduct.getM_Product_ID());
        MCharge mCharge = this.createCharge(properties, string2, string3);
        x_FM_Product.setC_Charge_ID(mCharge.getC_Charge_ID());
        x_FM_Product.setPaymentFrequency("F");
        x_FM_Product.setGraceDays(0);
        x_FM_Product.saveEx();
        return x_FM_Product;
    }

    private MProduct createProduct(Properties properties, String string, String string2, String string3) {
        MProduct mProduct = (MProduct)new Query(properties, "M_Product", "Value = ?", string3).setParameters(string).setClient_ID().first();
        if (mProduct != null && mProduct.getM_Product_ID() > 0) {
            return mProduct;
        }
        mProduct = new MProduct(Env.getCtx(), 0, string3);
        mProduct.setValue(string);
        mProduct.setName(string2);
        mProduct.setDescription(SETUP_DESCRIPTION);
        mProduct.setM_Product_Category_ID(new Query(Env.getCtx(), "M_Product_Category", "Value = ?", string3).setParameters("Standard").setClient_ID().firstId());
        mProduct.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", "Name = ?", string3).setParameters("Standard").setClient_ID().firstId());
        mProduct.setC_UOM_ID(new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", string3).setParameters("Kg").setClient_ID().firstId());
        mProduct.setProductType("S");
        mProduct.saveEx();
        this.createPriceList(mProduct.getM_Product_ID(), null, string3);
        return mProduct;
    }

    private void createPriceList(int n, BigDecimal bigDecimal, String string) {
        new Query(Env.getCtx(), "M_PriceList_Version", null, string).setOnlyActiveRecords(true).setClient_ID().list().forEach(mPriceListVersion -> {
            MProductPrice mProductPrice = new MProductPrice(Env.getCtx(), mPriceListVersion.getM_PriceList_Version_ID(), n, string);
            mProductPrice.setPriceList(Optional.ofNullable(bigDecimal).orElse(Env.ONEHUNDRED));
            mProductPrice.setPriceStd(Optional.ofNullable(bigDecimal).orElse(Env.ONEHUNDRED));
            mProductPrice.setPriceLimit(Optional.ofNullable(bigDecimal).orElse(Env.ONEHUNDRED));
            mProductPrice.saveEx();
        });
    }

    private MCharge createCharge(Properties properties, String string, String string2) {
        MCharge mCharge = (MCharge)new Query(properties, "C_Charge", "Name = ?", string2).setParameters(string).setClient_ID().first();
        if (mCharge != null && mCharge.getC_Charge_ID() > 0) {
            return mCharge;
        }
        mCharge = new MCharge(Env.getCtx(), 0, string2);
        mCharge.setName(string);
        mCharge.setDescription(SETUP_DESCRIPTION);
        mCharge.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", "Name = ?", string2).setParameters("Standard").setClient_ID().firstId());
        mCharge.saveEx();
        mCharge.saveEx();
        return mCharge;
    }

    private X_FM_ProductCategory createFinancialProductCategory(Properties properties, String string, String string2, String string3) {
        X_FM_ProductCategory x_FM_ProductCategory = (X_FM_ProductCategory)new Query(properties, "FM_ProductCategory", "Value = ?", string3).setParameters(string).setClient_ID().first();
        if (x_FM_ProductCategory != null && x_FM_ProductCategory.getFM_ProductCategory_ID() > 0) {
            return x_FM_ProductCategory;
        }
        x_FM_ProductCategory = new X_FM_ProductCategory(Env.getCtx(), 0, string3);
        x_FM_ProductCategory.setValue(string);
        x_FM_ProductCategory.setName(string2);
        x_FM_ProductCategory.setDescription(SETUP_DESCRIPTION);
        x_FM_ProductCategory.setType("L");
        x_FM_ProductCategory.saveEx();
        return x_FM_ProductCategory;
    }

    private X_FM_FunctionalSetting createFunctionalSetting(Properties properties, String string, String string2, String string3, String string4) {
        X_FM_FunctionalSetting x_FM_FunctionalSetting = (X_FM_FunctionalSetting)new Query(properties, "FM_FunctionalSetting", "Value = ?", string4).setParameters(string).setClient_ID().first();
        if (x_FM_FunctionalSetting != null && x_FM_FunctionalSetting.getFM_FunctionalSetting_ID() > 0) {
            return x_FM_FunctionalSetting;
        }
        x_FM_FunctionalSetting = new X_FM_FunctionalSetting(properties, 0, string4);
        x_FM_FunctionalSetting.setValue(string);
        x_FM_FunctionalSetting.setName(string2);
        x_FM_FunctionalSetting.setClassname(string3);
        x_FM_FunctionalSetting.setDescription(SETUP_DESCRIPTION);
        x_FM_FunctionalSetting.saveEx();
        return x_FM_FunctionalSetting;
    }

    private X_FM_FunctionalApplicability createApplicability(Properties properties, int n, int n2, String string, String string2, String string3, String string4) {
        int n3 = MTable.getTable_ID(string);
        X_FM_FunctionalApplicability x_FM_FunctionalApplicability = (X_FM_FunctionalApplicability)new Query(properties, "FM_FunctionalApplicability", "AD_Table_ID = ? AND EventType = ? AND EventModelValidator = ?", string4).setParameters(n3, string2, string3).setClient_ID().first();
        if (x_FM_FunctionalApplicability != null && x_FM_FunctionalApplicability.getFM_FunctionalApplicability_ID() > 0) {
            return x_FM_FunctionalApplicability;
        }
        x_FM_FunctionalApplicability = new X_FM_FunctionalApplicability(Env.getCtx(), 0, string4);
        x_FM_FunctionalApplicability.setFM_FunctionalSetting_ID(n);
        x_FM_FunctionalApplicability.setFM_ProductCategory_ID(n2);
        if (!Util.isEmpty(string)) {
            x_FM_FunctionalApplicability.setAD_Table_ID(MTable.getTable_ID(string));
        }
        if (!Util.isEmpty(string2)) {
            x_FM_FunctionalApplicability.setEventType(string2);
        }
        if (!Util.isEmpty(string3)) {
            x_FM_FunctionalApplicability.setEventModelValidator(string3);
        }
        x_FM_FunctionalApplicability.setSeqNo(10);
        x_FM_FunctionalApplicability.setValidFrom(TimeUtil.getDay(2020, 5, 1));
        x_FM_FunctionalApplicability.setDescription(SETUP_DESCRIPTION);
        x_FM_FunctionalApplicability.saveEx();
        return x_FM_FunctionalApplicability;
    }

    private X_FM_AgreementType createAgreementType(Properties properties, String string) {
        String string2 = "EAT";
        X_FM_AgreementType x_FM_AgreementType = (X_FM_AgreementType)new Query(properties, "FM_AgreementType", "Value = ?", string).setParameters(string2).setClient_ID().first();
        if (x_FM_AgreementType != null && x_FM_AgreementType.getFM_AgreementType_ID() > 0) {
            return x_FM_AgreementType;
        }
        x_FM_AgreementType = new X_FM_AgreementType(Env.getCtx(), 0, string);
        x_FM_AgreementType.setValue(string2);
        x_FM_AgreementType.setName("Testing Contract");
        x_FM_AgreementType.setDescription(SETUP_DESCRIPTION);
        x_FM_AgreementType.setText("This is a testing contract usinng for financial investment and loan, you can use this or create a new agreement type");
        x_FM_AgreementType.saveEx();
        return x_FM_AgreementType;
    }

    private void createTransactionTypes(Properties properties, String string) {
        Arrays.asList(MRefList.getList(properties, 54020, false)).forEach(valueNamePair -> this.createTransactionType(properties, valueNamePair.getValue(), valueNamePair.getValue(), valueNamePair.getName(), string));
    }

    private X_FM_TransactionType createTransactionType(Properties properties, String string, String string2, String string3, String string4) {
        X_FM_TransactionType x_FM_TransactionType = (X_FM_TransactionType)new Query(properties, "FM_TransactionType", "Type = ?", string4).setParameters(string).setClient_ID().first();
        if (x_FM_TransactionType != null && x_FM_TransactionType.getFM_TransactionType_ID() > 0) {
            return x_FM_TransactionType;
        }
        x_FM_TransactionType = new X_FM_TransactionType(Env.getCtx(), 0, string4);
        x_FM_TransactionType.setValue(string2);
        x_FM_TransactionType.setName(string3);
        x_FM_TransactionType.setType(string);
        x_FM_TransactionType.saveEx();
        return x_FM_TransactionType;
    }
}

