/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.core.domains.models.X_FM_Agreement;
import org.adempiere.core.domains.models.X_FM_Product;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.X_FM_Amortization;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.openup.LUY.model.MLUYCFEType;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMAmortization;
import org.spin.investment.model.MFMDunning;
import org.spin.investment.model.MFMProduct;
import org.spin.investment.model.MFMRate;
import org.spin.investment.process.GenerateInvoiceFromLoanAbstract;

public class GenerateInvoiceFromLoan
extends GenerateInvoiceFromLoanAbstract {
    private List<MInvoice> invoiceList = new ArrayList<MInvoice>();
    private MInvoice invoice;
    private int precision;

    @Override
    protected String doIt() throws Exception {
        this.precision = MCurrency.getStdPrecision(this.getCtx(), Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
        int chargeForInterestId = 0;
        int chargeForDunningId = 0;
        MFMAccount account = null;
        PO agreement = null;
        MBPartner businessPartner = null;
        MProduct product = null;
        PO financialProduct = null;
        X_FM_Amortization lastAmortization = null;
        for (int amortizationId : this.getSelectionKeys()) {
            MFMAmortization amortization = new MFMAmortization(this.getCtx(), amortizationId, this.get_TrxName());
            BigDecimal capitalAmt = this.getSelectionAsBigDecimal(amortizationId, "LA_ConvertedCapitalAmt");
            BigDecimal interestAmt = this.getSelectionAsBigDecimal(amortizationId, "LA_ConvertedInterestAmt");
            BigDecimal dunningAmt = this.getSelectionAsBigDecimal(amortizationId, "LA_ConvertedCurrentDunningAmt");
            int currencyID = this.getSelectionAsInt(amortizationId, "LA_C_Currency_ID_To");
            boolean isDue = this.getSelectionAsBoolean(amortizationId, "LA_IsDue");
            if (this.isSplitInvoices() || this.invoice == null) {
                this.invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                if (account == null) {
                    account = (MFMAccount)amortization.getFM_Account();
                    agreement = (MFMAgreement)account.getFM_Agreement();
                    if (this.getParameterAsBoolean("IsPrepayment")) {
                        List<MFMAmortization> toInvoiceList = MFMAmortization.getToInvoiceList(account.getFM_Account_ID(), this.get_TrxName());
                        if (toInvoiceList == null || toInvoiceList.isEmpty()) {
                            throw new AdempiereException("@LoanManagement.NoToInvoice@");
                        }
                        if (toInvoiceList.size() > this.getSelectionKeys().size()) {
                            throw new AdempiereException("@LoanManagement.AllFeesNotSelected@");
                        }
                    }
                    lastAmortization = MFMAmortization.getLastAmortizationFromAccount(account.getFM_Account_ID(), this.get_TrxName());
                    financialProduct = MFMProduct.getById(this.getCtx(), ((X_FM_Agreement)agreement).getFM_Product_ID());
                    product = MProduct.get(this.getCtx(), ((X_FM_Product)financialProduct).getM_Product_ID());
                    businessPartner = MBPartner.get(this.getCtx(), ((X_FM_Agreement)agreement).getC_BPartner_ID());
                    int rateForInterestId = financialProduct.get_ValueAsInt("FM_Rate_ID");
                    int rateForDunningInterestId = financialProduct.get_ValueAsInt("DunningInterest_ID");
                    int dunningId = financialProduct.get_ValueAsInt("FM_Dunning_ID");
                    if (rateForDunningInterestId == 0 && dunningId == 0) {
                        throw new AdempiereException("@FM_Dunning_ID@ @for@ @FM_Product_ID@ @NotFound@");
                    }
                    if (interestAmt != null && rateForInterestId == 0) {
                        throw new AdempiereException("@FM_Rate_ID@ @for@ @Interest@ @NotFound@");
                    }
                    if (dunningAmt != null && rateForDunningInterestId == 0 && dunningId == 0) {
                        throw new AdempiereException("@DunningInterest_ID@ @NotFound@");
                    }
                    if (rateForInterestId != 0) {
                        MFMRate interestRate = MFMRate.getById(this.getCtx(), rateForInterestId);
                        chargeForInterestId = interestRate.getC_Charge_ID();
                    }
                    if (rateForDunningInterestId != 0) {
                        MFMRate dunningunningInterest = MFMRate.getById(this.getCtx(), rateForDunningInterestId);
                        chargeForDunningId = dunningunningInterest.getC_Charge_ID();
                    } else if (dunningId != 0) {
                        MFMDunning dunning = MFMDunning.getById(this.getCtx(), dunningId);
                        chargeForDunningId = dunning.getChargeId();
                    }
                }
                this.invoice.setAD_Org_ID(agreement.getAD_Org_ID());
                if (this.getDocTypeTargetId() != 0) {
                    this.invoice.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
                } else {
                    this.invoice.setIsSOTrx(true);
                    this.invoice.setC_DocTypeTarget_ID();
                }
                this.invoice.setDateInvoiced(this.getDateInvoiced());
                this.invoice.setDateAcct(this.getDateInvoiced());
                this.invoice.setBPartner(businessPartner);
                if (this.invoice.getC_BPartner_Location_ID() <= 0) {
                    throw new AdempiereException("@C_BPartner_ID@ " + businessPartner.getName() + " @C_BPartner_Location_ID@ @not.found@");
                }
                if (agreement.get_ValueAsInt("AD_User_ID") != 0) {
                    this.invoice.setAD_User_ID(agreement.get_ValueAsInt("AD_User_ID"));
                }
                this.invoice.setDescription(Msg.parseTranslation(Env.getCtx(), "@Generate@ @from@ @Loan@") + " - " + ((X_FM_Agreement)agreement).getDocumentNo());
                this.invoice.set_ValueOfColumn("FM_Account_ID", (Object)account.getFM_Account_ID());
                MCurrency currency = MCurrency.get(this.getCtx(), currencyID);
                MPriceList priceList = MPriceList.getDefault(this.getCtx(), true, currency.getISO_Code());
                if (priceList == null) {
                    throw new AdempiereException("@M_PriceList_ID@ @NotFound@ @for@ " + currency.getISO_Code());
                }
                this.invoice.setM_PriceList_ID(priceList.getM_PriceList_ID());
                this.invoice.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
                MLUYCFEType mLuyCfeType = MLUYCFEType.getDefaultEx(this.getCtx(), this.invoice.getAD_Org_ID(), businessPartner.getC_TaxGroup_ID(), "ARI", this.get_TrxName());
                this.invoice.setC_DocType_ID(mLuyCfeType.getC_DocType_ID());
                this.invoice.setC_DocTypeTarget_ID(mLuyCfeType.getC_DocType_ID());
                this.invoice.saveEx();
                this.invoiceList.add(this.invoice);
            }
            if (product != null) {
                this.createLine(capitalAmt, product, 0, (MFMAgreement)agreement, amortization);
                Object description = this.invoice.getDescription();
                description = (String)description + Env.NL + Msg.getMsg(this.getCtx(), "Fee") + " " + amortization.getPeriodNo() + (String)(lastAmortization != null ? "/" + lastAmortization.getPeriodNo() : "");
                this.invoice.setDescription((String)description);
            }
            if (chargeForInterestId != 0) {
                if (!isDue && amortization.getStartDate().after(this.getDateInvoiced()) && this.getParameterAsBoolean("IsPrepayment")) {
                    int prepayFeeRateId = financialProduct.get_ValueAsInt("PrepayFeeRate_ID");
                    if (prepayFeeRateId > 0) {
                        BigDecimal rateVersion;
                        MFMRate rateToApply = MFMRate.getById(this.getCtx(), prepayFeeRateId);
                        if (rateToApply != null && (rateVersion = rateToApply.getValidRate(this.getDateInvoiced())) != null) {
                            interestAmt = interestAmt.multiply(rateVersion);
                            interestAmt = interestAmt.divide(Env.ONEHUNDRED);
                        }
                    } else {
                        interestAmt = Env.ZERO;
                    }
                }
                this.createLine(interestAmt, null, chargeForInterestId, (MFMAgreement)agreement, amortization);
            }
            if (chargeForDunningId == 0) continue;
            this.createLine(dunningAmt, null, chargeForDunningId, (MFMAgreement)agreement, amortization);
        }
        this.completeInvoice();
        StringBuffer msg = new StringBuffer("@Created@ (").append(this.invoiceList.size()).append(")");
        StringBuffer detail = new StringBuffer();
        for (MInvoice invoice : this.invoiceList) {
            if (detail.length() > 0) {
                detail.append(", ");
            }
            detail.append(invoice.getDocumentNo());
        }
        if (detail.length() > 0) {
            msg.append("[").append(detail).append("]");
        }
        return msg.toString();
    }

    private void createLine(BigDecimal amount, MProduct product, int chargeId, MFMAgreement loan, MFMAmortization amortization) {
        if (amount == null || amount.compareTo(Env.ZERO) == 0) {
            return;
        }
        MInvoiceLine invoiceLine = new MInvoiceLine(this.invoice);
        if (product != null) {
            invoiceLine.setProduct(product);
        } else if (chargeId != 0) {
            invoiceLine.setC_Charge_ID(chargeId);
        }
        invoiceLine.setQty(Env.ONE);
        if (this.precision > 0) {
            amount.setScale(this.precision, 4);
        }
        invoiceLine.setPrice(amount);
        invoiceLine.setDescription(Msg.parseTranslation(Env.getCtx(), "@Generate@ @from@ @FM_Amortization_ID@ " + amortization.getPeriodNo() + " @of@ @Loan@ " + loan.getDocumentNo()));
        invoiceLine.set_ValueOfColumn("FM_Amortization_ID", (Object)amortization.getFM_Amortization_ID());
        invoiceLine.saveEx();
    }

    private void completeInvoice() {
        for (MInvoice invoice : this.invoiceList) {
            invoice.setDocAction(this.getDocAction());
            if (!invoice.processIt(this.getDocAction())) {
                this.log.warning("completeInvoice - failed: " + invoice);
                this.addLog(Msg.getMsg(this.getCtx(), "Error") + invoice);
            } else {
                this.addLog("@C_Invoice_ID@ @Created@" + invoice.getDocumentNo());
            }
            invoice.saveEx();
        }
    }
}

