/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.X_FM_AmortizationSummary;

public class MFMAmortizationSummary
extends X_FM_AmortizationSummary {
    private static final long serialVersionUID = 1L;

    public MFMAmortizationSummary(Properties ctx, int FM_Amortization_ID, String trxName) {
        super(ctx, FM_Amortization_ID, trxName);
    }

    public MFMAmortizationSummary(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFMAmortizationSummary setCurrentInterest(Properties ctx, int financialAccountId, int amortizationId, Timestamp dateDoc, BigDecimal capitalAmount, BigDecimal currentInsterestAmount, BigDecimal currentInsterestTaxAmount, String trxName) {
        MFMAmortizationSummary summary = MFMAmortizationSummary.getAmortizationSummaryFromAccountAndDate(ctx, financialAccountId, amortizationId, dateDoc, trxName);
        MFMAccount account = MFMAccount.getById(ctx, financialAccountId);
        int currencyPrecision = MCurrency.getStdPrecision(ctx, account.getC_Currency_ID());
        summary.setCurrentCapitalAmt(capitalAmount.setScale(currencyPrecision, 4));
        summary.setCurrentInterestAmt(currentInsterestAmount.setScale(currencyPrecision, 4));
        summary.setCurrentTaxAmt(currentInsterestTaxAmount.setScale(currencyPrecision, 4));
        summary.saveEx();
        return summary;
    }

    public static MFMAmortizationSummary setCurrentDunning(Properties ctx, int financialAccountId, int amortizationId, Timestamp dateDoc, BigDecimal capitalAmount, BigDecimal currentDunningAmount, BigDecimal currentDunningTaxAmount, String trxName) {
        MFMAmortizationSummary summary = MFMAmortizationSummary.getAmortizationSummaryFromAccountAndDate(ctx, financialAccountId, amortizationId, dateDoc, trxName);
        MFMAccount account = MFMAccount.getById(ctx, financialAccountId);
        int currencyPrecision = MCurrency.getStdPrecision(ctx, account.getC_Currency_ID());
        summary.setCurrentCapitalAmt(capitalAmount.setScale(currencyPrecision, 4));
        summary.setCurrentDunningAmt(currentDunningAmount.setScale(currencyPrecision, 4));
        summary.setCurrentDunningTaxAmt(currentDunningTaxAmount.setScale(currencyPrecision, 4));
        summary.saveEx();
        return summary;
    }

    private static MFMAmortizationSummary getAmortizationSummaryFromAccountAndDate(Properties ctx, int financialAccountId, int amortizationId, Timestamp dateDoc, String trxName) {
        dateDoc = TimeUtil.getDay(dateDoc);
        MFMAmortizationSummary summary = (MFMAmortizationSummary)new Query(ctx, "FM_AmortizationSummary", "FM_Account_ID = ? AND FM_Amortization_ID = ? AND DateDoc = ?", trxName).setParameters(financialAccountId, amortizationId, dateDoc).setOnlyActiveRecords(true).setClient_ID().first();
        if (summary == null || summary.getFM_AmortizationSummary_ID() == 0) {
            summary = new MFMAmortizationSummary(ctx, 0, trxName);
            summary.setDateDoc(dateDoc);
            summary.setFM_Account_ID(financialAccountId);
            summary.setFM_Amortization_ID(amortizationId);
        }
        return summary;
    }

    @Override
    public BigDecimal getCurrentCapitalAmt() {
        if (super.getCurrentCapitalAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentCapitalAmt();
    }

    @Override
    public BigDecimal getCurrentInterestAmt() {
        if (super.getCurrentInterestAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentInterestAmt();
    }

    @Override
    public BigDecimal getCurrentDunningAmt() {
        if (super.getCurrentDunningAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentDunningAmt();
    }

    @Override
    public BigDecimal getCurrentDunningTaxAmt() {
        if (super.getCurrentDunningTaxAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentDunningTaxAmt();
    }

    @Override
    public BigDecimal getCurrentTaxAmt() {
        if (super.getCurrentTaxAmt() == null) {
            return Env.ZERO;
        }
        return super.getCurrentTaxAmt();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setCurrentFeeAmt(this.getCurrentCapitalAmt().add(this.getCurrentInterestAmt()).add(this.getCurrentTaxAmt()).add(this.getCurrentDunningAmt()).add(this.getCurrentDunningTaxAmt()));
        return super.beforeSave(newRecord);
    }

    @Override
    public String toString() {
        return "MFMAmortizationSummary [getCurrentDunningAmt()=" + this.getCurrentDunningAmt() + ", getCurrentDunningTaxAmt()=" + this.getCurrentDunningTaxAmt() + ", getCurrentFeeAmt()=" + this.getCurrentFeeAmt() + ", getCurrentInterestAmt()=" + this.getCurrentInterestAmt() + ", getCurrentTaxAmt()=" + this.getCurrentTaxAmt() + ", getDateDoc()=" + this.getDateDoc() + ", getFM_Account_ID()=" + this.getFM_Account_ID() + "]";
    }
}

