/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_FM_Account;
import org.compiere.model.MClient;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMProduct;

public class MFMAccount
extends X_FM_Account {
    private static final long serialVersionUID = 6954882533416850938L;
    private static CCache<Integer, List<MFMAccount>> accountsCacheValues = new CCache("FM_Account", 30);
    private static CCache<Integer, MFMAccount> financialAccountCacheIds = new CCache("FM_Account", 30);

    public MFMAccount(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MFMAccount(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MFMAccount(MFMAgreement mFMAgreement) {
        super(mFMAgreement.getCtx(), 0, mFMAgreement.get_TrxName());
        this.setFM_Agreement_ID(mFMAgreement.getFM_Agreement_ID());
        this.setAccountNo("#" + mFMAgreement.getDocumentNo());
        int n = MClient.get(mFMAgreement.getCtx()).getC_Currency_ID();
        if (mFMAgreement.getFM_Product_ID() != 0) {
            MFMProduct mFMProduct = MFMProduct.getById(this.getCtx(), mFMAgreement.getFM_Product_ID(), mFMAgreement.get_TrxName());
            if (mFMProduct.getC_Currency_ID() != 0) {
                n = mFMProduct.getC_Currency_ID();
            }
            if (mFMProduct.getPaymentFrequency() != null) {
                this.setPaymentFrequency(mFMProduct.getPaymentFrequency());
            }
            if (mFMProduct.get_ValueAsInt("FeesQty") > 0) {
                this.setFeesQty((BigDecimal)mFMProduct.get_Value("FeesQty"));
            }
            if (mFMProduct.get_Value("PayDate") != null) {
                this.setPayDate((Timestamp)mFMProduct.get_Value("PayDate"));
            }
        }
        this.setC_Currency_ID(n);
    }

    public static MFMAccount getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MFMAccount mFMAccount = financialAccountCacheIds.get(n);
        if (mFMAccount != null && mFMAccount.get_ID() > 0) {
            return mFMAccount;
        }
        mFMAccount = (MFMAccount)new Query(properties, "FM_Account", "FM_Account_ID=?", string).setClient_ID().setParameters(n).first();
        if (mFMAccount != null && mFMAccount.get_ID() > 0) {
            financialAccountCacheIds.put(mFMAccount.get_ID(), mFMAccount);
        }
        return mFMAccount;
    }

    public static MFMAccount getById(Properties properties, int n) {
        return MFMAccount.getById(properties, n, null);
    }

    public static List<MFMAccount> getAccountFromAgreement(MFMAgreement mFMAgreement) {
        List<MFMAccount> list = accountsCacheValues.get(mFMAgreement.getFM_Agreement_ID());
        if (list != null && !list.isEmpty()) {
            return list;
        }
        list = new Query(mFMAgreement.getCtx(), "FM_Account", "FM_Agreement_ID = ?", mFMAgreement.get_TrxName()).setClient_ID().setParameters(mFMAgreement.getFM_Agreement_ID()).setOnlyActiveRecords(true).list();
        accountsCacheValues.put(mFMAgreement.getFM_Agreement_ID(), list);
        return list;
    }
}

