/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.loan.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Charge;
import org.adempiere.core.domains.models.X_C_Tax;
import org.adempiere.core.domains.models.X_FM_Account;
import org.adempiere.core.domains.models.X_FM_Rate;
import org.compiere.model.MCharge;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.investment.loan.util.AmortizationValue;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMAmortization;
import org.spin.investment.model.MFMDunning;
import org.spin.investment.model.MFMDunningLevel;
import org.spin.investment.model.MFMProduct;
import org.spin.investment.model.MFMRate;

public class LoanUtil {
    private static final BigDecimal YEAR_DAY = new BigDecimal(360);
    private static CLogger log = CLogger.getCLogger(LoanUtil.class);

    public static Timestamp getEndDateFromFrequency(Timestamp timestamp, String string, int n) {
        if (timestamp == null || string == null) {
            return null;
        }
        if (string.equals("D")) {
            return TimeUtil.addDays(timestamp, n);
        }
        if (string.equals("W")) {
            return TimeUtil.addDays(timestamp, n * 7);
        }
        if (string.equals("T")) {
            return TimeUtil.addDays(timestamp, n * 15);
        }
        if (string.equals("M")) {
            return TimeUtil.addMonths(timestamp, n);
        }
        if (string.equals("Q")) {
            return TimeUtil.addMonths(timestamp, n * 3);
        }
        if (string.equals("S")) {
            return TimeUtil.addMonths(timestamp, n * 6);
        }
        if (string.equals("Y")) {
            return TimeUtil.addYears(timestamp, n);
        }
        if (string.equals("F")) {
            return timestamp;
        }
        return null;
    }

    public static int getFeesQtyFromFrequency(Timestamp timestamp, Timestamp timestamp2, String string) {
        if (timestamp == null || timestamp2 == null || string == null) {
            return 0;
        }
        if (string.equals("D")) {
            return TimeUtil.getDaysBetween(timestamp, timestamp2, new int[0]);
        }
        if (string.equals("W")) {
            return TimeUtil.getDaysBetween(timestamp, timestamp2, new int[0]) / 7;
        }
        if (string.equals("T")) {
            return TimeUtil.getDaysBetween(timestamp, timestamp2, new int[0]) / 15;
        }
        if (string.equals("M")) {
            return TimeUtil.getMonthsBetween(timestamp, timestamp2);
        }
        if (string.equals("Q")) {
            return TimeUtil.getMonthsBetween(timestamp, timestamp2) / 3;
        }
        if (string.equals("S")) {
            return TimeUtil.getMonthsBetween(timestamp, timestamp2) / 6;
        }
        if (string.equals("Y")) {
            return TimeUtil.getYearsBetween(timestamp, timestamp2);
        }
        if (string.equals("F")) {
            return 1;
        }
        return 0;
    }

    public static HashMap<String, Object> calculateFrenchAmortization(int n, BigDecimal bigDecimal, int n2, Timestamp timestamp, Timestamp timestamp2, Timestamp timestamp3, String string, Properties properties, String string2) {
        BigDecimal bigDecimal2;
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        if (timestamp3 == null || timestamp3.before(timestamp)) {
            timestamp3 = timestamp;
        }
        MFMProduct mFMProduct = MFMProduct.getById(properties, n, string2);
        int n3 = mFMProduct.get_ValueAsInt("FM_Rate_ID");
        BigDecimal bigDecimal3 = Env.ZERO;
        BigDecimal bigDecimal4 = Env.ZERO;
        BigDecimal bigDecimal5 = Env.ZERO;
        X_C_Charge x_C_Charge = null;
        if (n3 != 0) {
            cloneable2 = MFMRate.getById(properties, n3);
            bigDecimal3 = ((MFMRate)cloneable2).getValidRate(timestamp);
            x_C_Charge = MCharge.get(properties, ((X_FM_Rate)cloneable2).getC_Charge_ID());
        }
        if (x_C_Charge != null) {
            cloneable2 = (MTaxCategory)x_C_Charge.getC_TaxCategory();
            cloneable = ((MTaxCategory)cloneable2).getDefaultTax();
            bigDecimal3 = bigDecimal3.divide(Env.ONEHUNDRED);
            bigDecimal5 = ((X_C_Tax)cloneable).getRate().divide(Env.ONEHUNDRED);
            bigDecimal4 = bigDecimal3.add(bigDecimal3.multiply(bigDecimal5));
        }
        cloneable2 = new ArrayList();
        cloneable = timestamp;
        Timestamp timestamp4 = timestamp3;
        int n4 = 0;
        BigDecimal bigDecimal6 = Env.ZERO;
        BigDecimal bigDecimal7 = bigDecimal;
        for (int i = 0; i < n2; ++i) {
            object = new AmortizationValue();
            ((AmortizationValue)object).setPeriodNo(i + 1);
            ((AmortizationValue)object).setStartDate((Timestamp)cloneable);
            cloneable = !string.equals("F") ? LoanUtil.getEndDateFromFrequency((Timestamp)cloneable, string, 1) : timestamp2;
            ((AmortizationValue)object).setEndDate((Timestamp)cloneable);
            if (timestamp4.before(((AmortizationValue)object).getEndDate())) {
                timestamp4 = ((AmortizationValue)object).getEndDate();
            }
            ((AmortizationValue)object).setDueDate(timestamp4);
            if (!string.equals("F")) {
                timestamp4 = LoanUtil.getEndDateFromFrequency((Timestamp)cloneable, string, 1);
            }
            ((AmortizationValue)object).setCumulativeDays(n4 += ((AmortizationValue)object).getDayOfMonth());
            bigDecimal2 = LoanUtil.calculateMonthlyInterest(((AmortizationValue)object).getCumulativeDays(), bigDecimal4);
            BigDecimal bigDecimal8 = LoanUtil.calculateDailyInterest(((AmortizationValue)object).getDayOfMonth(), bigDecimal4);
            ((AmortizationValue)object).setMonthInterest(bigDecimal2);
            ((AmortizationValue)object).setDailyInterest(bigDecimal8);
            bigDecimal6 = bigDecimal6.add(((AmortizationValue)object).getMonthInterest());
            ((AmortizationValue)object).setCumulativeInterest(bigDecimal6);
            cloneable2.add(object);
        }
        BigDecimal bigDecimal9 = bigDecimal.divide(bigDecimal6, MathContext.DECIMAL128);
        object = Env.ZERO;
        bigDecimal2 = Env.ZERO;
        for (int i = 0; i < cloneable2.size(); ++i) {
            AmortizationValue amortizationValue = (AmortizationValue)cloneable2.get(i);
            BigDecimal bigDecimal10 = amortizationValue.getDailyInterest().multiply(bigDecimal7);
            bigDecimal10 = bigDecimal10.divide(Env.ONE.add(bigDecimal5), MathContext.DECIMAL128);
            amortizationValue.setInterestAmtFee(bigDecimal10);
            BigDecimal bigDecimal11 = bigDecimal10.multiply(bigDecimal5);
            amortizationValue.setTaxAmtFee(bigDecimal11);
            amortizationValue.setCapitalAmtFee(bigDecimal9.subtract(bigDecimal10.add(bigDecimal11)));
            bigDecimal7 = bigDecimal7.subtract(amortizationValue.getCapitalAmtFee());
            amortizationValue.setRemainingCapital(bigDecimal7);
            amortizationValue.setDailyInterestAmt(amortizationValue.getInterestAmtFee().divide(new BigDecimal(amortizationValue.getCumulativeDays()), MathContext.DECIMAL128));
            amortizationValue.setFixedFeeAmt(bigDecimal9);
            cloneable2.set(i, amortizationValue);
            object = ((BigDecimal)object).add(amortizationValue.getInterestAmtFee());
            bigDecimal2 = bigDecimal2.add(bigDecimal11);
        }
        hashMap.put("FIXED_FEE_AMT", bigDecimal9);
        hashMap.put("INTEREST_FEE_AMT", object);
        hashMap.put("TAX_FEE_AMT", bigDecimal2);
        hashMap.put("GRAND_TOTAL", ((BigDecimal)object).add(bigDecimal2).add(bigDecimal));
        hashMap.put("AMORTIZATION_LIST", cloneable2);
        return hashMap;
    }

    public static BigDecimal calculateDailyInterest(int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = Env.ONE.add(bigDecimal);
        BigDecimal bigDecimal3 = new BigDecimal(n).divide(YEAR_DAY, MathContext.DECIMAL128);
        BigDecimal bigDecimal4 = new BigDecimal(Math.pow(bigDecimal2.doubleValue(), bigDecimal3.doubleValue()));
        BigDecimal bigDecimal5 = bigDecimal4.subtract(Env.ONE);
        return bigDecimal5;
    }

    public static BigDecimal calculateMonthlyInterest(int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = Env.ONE.add(bigDecimal);
        BigDecimal bigDecimal3 = new BigDecimal(n).divide(YEAR_DAY, MathContext.DECIMAL128);
        BigDecimal bigDecimal4 = new BigDecimal(Math.pow(bigDecimal2.doubleValue(), bigDecimal3.doubleValue()));
        BigDecimal bigDecimal5 = Env.ONE.divide(bigDecimal4, MathContext.DECIMAL128);
        return bigDecimal5;
    }

    public static HashMap<String, Object> calculateLoanDunning(Properties properties, int n, Timestamp timestamp, String string) {
        Object object;
        PO pO;
        if (n <= 0) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        MFMAgreement mFMAgreement = MFMAgreement.getById(properties, n, string);
        MFMProduct mFMProduct = MFMProduct.getById(properties, mFMAgreement.getFM_Product_ID(), string);
        int n2 = mFMProduct.get_ValueAsInt("DunningInterest_ID");
        int n3 = mFMProduct.get_ValueAsInt("FM_Dunning_ID");
        int n4 = mFMProduct.get_ValueAsInt("GraceDays");
        if (n2 == 0 && n3 == 0) {
            return null;
        }
        BigDecimal bigDecimal = Env.ZERO;
        BigDecimal bigDecimal2 = Env.ZERO;
        X_C_Charge x_C_Charge = null;
        if (n2 != 0) {
            pO = MFMRate.getById(properties, n2);
            bigDecimal = ((MFMRate)pO).getValidRate(timestamp);
            bigDecimal = bigDecimal != null ? bigDecimal.divide(Env.ONEHUNDRED) : Env.ZERO;
            x_C_Charge = MCharge.get(properties, ((X_FM_Rate)pO).getC_Charge_ID());
        }
        if (x_C_Charge != null) {
            pO = (MTaxCategory)x_C_Charge.getC_TaxCategory();
            object = ((MTaxCategory)pO).getDefaultTax();
            bigDecimal2 = ((X_C_Tax)object).getRate();
            bigDecimal2 = bigDecimal2 != null ? bigDecimal2.divide(Env.ONEHUNDRED) : Env.ZERO;
        }
        pO = null;
        if (n3 > 0) {
            pO = MFMDunning.getById(properties, n3);
        }
        object = MFMAccount.getAccountFromAgreement(mFMAgreement);
        MFMAccount mFMAccount = null;
        if (object.isEmpty()) {
            mFMAccount = new MFMAccount(mFMAgreement);
            mFMAccount.saveEx();
        } else {
            mFMAccount = (MFMAccount)object.get(0);
        }
        ArrayList<AmortizationValue> arrayList = new ArrayList<AmortizationValue>();
        for (MFMAmortization mFMAmortization : MFMAmortization.getOpenFromAccount(mFMAccount.getFM_Account_ID(), string)) {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            AmortizationValue amortizationValue;
            if (mFMAmortization.isInvoiced() || mFMAmortization.isPaid() || (amortizationValue = new AmortizationValue(mFMAmortization)).getDaysDue(timestamp) - n4 <= 0) continue;
            MFMDunningLevel mFMDunningLevel = null;
            int n5 = 0;
            if (pO != null) {
                mFMDunningLevel = ((MFMDunning)pO).getValidLevelInstance(amortizationValue.getDaysDue());
                if (mFMDunningLevel == null) continue;
                if (n2 == 0 && (n5 = mFMDunningLevel.getFM_Rate_ID()) > 0) {
                    serializable3 = MFMRate.getById(properties, n5);
                    bigDecimal = ((MFMRate)serializable3).getValidRate(timestamp);
                    x_C_Charge = MCharge.get(properties, ((X_FM_Rate)serializable3).getC_Charge_ID());
                    if (x_C_Charge != null) {
                        serializable2 = (MTaxCategory)x_C_Charge.getC_TaxCategory();
                        serializable = ((MTaxCategory)serializable2).getDefaultTax();
                        bigDecimal = bigDecimal.divide(Env.ONEHUNDRED);
                        bigDecimal2 = ((X_C_Tax)serializable).getRate().divide(Env.ONEHUNDRED);
                    }
                }
                if (bigDecimal == null || bigDecimal.doubleValue() == 0.0 || bigDecimal2 == null) continue;
            }
            if ((serializable3 = LoanUtil.calculateDailyInterest(amortizationValue.getDaysDue(), bigDecimal)) != null) {
                amortizationValue.setDunningDailyInterest((BigDecimal)serializable3);
                serializable2 = amortizationValue.getCapitalAmtFee();
                serializable = ((BigDecimal)serializable2).multiply((BigDecimal)serializable3);
                amortizationValue.setDunningInterestAmount((BigDecimal)serializable);
                if (bigDecimal2 != null) {
                    amortizationValue.setDunningTaxRate(bigDecimal2);
                    amortizationValue.setDunningTaxAmt(((BigDecimal)serializable).multiply(bigDecimal2));
                }
            }
            arrayList.add(amortizationValue);
        }
        hashMap.put("AMORTIZATION_LIST", arrayList);
        return hashMap;
    }

    public static HashMap<String, Object> calculateLoanProvision(Properties properties, int n, Timestamp timestamp, String string) {
        MFMAgreement mFMAgreement;
        MFMProduct mFMProduct;
        int n2;
        if (n <= 0) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        if ((n2 = (mFMProduct = MFMProduct.getById(properties, (mFMAgreement = MFMAgreement.getById(properties, n, string)).getFM_Product_ID(), string)).get_ValueAsInt("FM_Dunning_ID")) == 0) {
            return null;
        }
        MFMDunning mFMDunning = null;
        if (n2 > 0) {
            mFMDunning = MFMDunning.getById(properties, n2);
        }
        List<MFMAccount> list = MFMAccount.getAccountFromAgreement(mFMAgreement);
        MFMAccount mFMAccount = null;
        if (list.isEmpty()) {
            mFMAccount = new MFMAccount(mFMAgreement);
            mFMAccount.saveEx();
        } else {
            mFMAccount = list.get(0);
        }
        ArrayList<AmortizationValue> arrayList = new ArrayList<AmortizationValue>();
        for (AmortizationValue amortizationValue : LoanUtil.getCurrentAmortizationList(properties, n, string)) {
            BigDecimal bigDecimal;
            if (amortizationValue.isPaid() || amortizationValue.getDaysDue(timestamp) <= 0) continue;
            MFMDunningLevel mFMDunningLevel = null;
            if (mFMDunning == null || (mFMDunningLevel = mFMDunning.getValidLevelInstance(amortizationValue.getDaysDue())) == null || !mFMDunningLevel.isAccrual() || (bigDecimal = mFMDunningLevel.getProvisionPercentage()) == null || bigDecimal.doubleValue() == 0.0) continue;
            bigDecimal = bigDecimal.divide(Env.ONEHUNDRED);
            BigDecimal bigDecimal2 = amortizationValue.getCapitalAmtFee();
            BigDecimal bigDecimal3 = amortizationValue.getInterestAmtFee();
            BigDecimal bigDecimal4 = amortizationValue.getDunningInterestAmount();
            BigDecimal bigDecimal5 = bigDecimal2.add(bigDecimal3).add(bigDecimal4).multiply(bigDecimal);
            amortizationValue.setProvisionAmt(bigDecimal5);
            arrayList.add(amortizationValue);
        }
        hashMap.put("AMORTIZATION_LIST", arrayList);
        return hashMap;
    }

    public static HashMap<String, Object> calculateLoanSuspension(Properties properties, int n, Timestamp timestamp, String string) {
        MFMAgreement mFMAgreement;
        MFMProduct mFMProduct;
        int n2;
        if (n <= 0) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        if ((n2 = (mFMProduct = MFMProduct.getById(properties, (mFMAgreement = MFMAgreement.getById(properties, n, string)).getFM_Product_ID(), string)).get_ValueAsInt("FM_Dunning_ID")) == 0) {
            return null;
        }
        MFMDunning mFMDunning = null;
        if (n2 > 0) {
            mFMDunning = MFMDunning.getById(properties, n2);
        }
        List<MFMAccount> list = MFMAccount.getAccountFromAgreement(mFMAgreement);
        MFMAccount mFMAccount = null;
        if (list.isEmpty()) {
            mFMAccount = new MFMAccount(mFMAgreement);
            mFMAccount.saveEx();
        } else {
            mFMAccount = list.get(0);
        }
        ArrayList<AmortizationValue> arrayList = new ArrayList<AmortizationValue>();
        for (AmortizationValue amortizationValue : LoanUtil.getCurrentAmortizationList(properties, n, string)) {
            if (amortizationValue.isPaid() || amortizationValue.getDaysDue(timestamp) <= 0) continue;
            MFMDunningLevel mFMDunningLevel = null;
            if (mFMDunning == null || (mFMDunningLevel = mFMDunning.getValidLevelInstance(amortizationValue.getDaysDue(), false, true)) == null || !mFMDunningLevel.isSuspend()) continue;
            arrayList.add(amortizationValue);
        }
        hashMap.put("AMORTIZATION_LIST", arrayList);
        return hashMap;
    }

    public static HashMap<String, Object> calculateLoanInterest(Properties properties, int n, Timestamp timestamp, String string) {
        PO pO;
        Object object;
        MFMAgreement mFMAgreement;
        MFMProduct mFMProduct;
        int n2;
        if (n <= 0) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        if ((n2 = (mFMProduct = MFMProduct.getById(properties, (mFMAgreement = MFMAgreement.getById(properties, n, string)).getFM_Product_ID(), string)).get_ValueAsInt("FM_Rate_ID")) == 0) {
            return null;
        }
        BigDecimal bigDecimal = Env.ZERO;
        BigDecimal bigDecimal2 = Env.ZERO;
        X_C_Charge x_C_Charge = null;
        if (n2 != 0) {
            object = MFMRate.getById(properties, n2);
            bigDecimal = ((MFMRate)object).getValidRate(mFMAgreement.getDateDoc());
            x_C_Charge = MCharge.get(properties, ((X_FM_Rate)object).getC_Charge_ID());
        }
        if (x_C_Charge != null) {
            object = (MTaxCategory)x_C_Charge.getC_TaxCategory();
            pO = ((MTaxCategory)object).getDefaultTax();
            bigDecimal = bigDecimal.divide(Env.ONEHUNDRED);
            bigDecimal2 = ((X_C_Tax)pO).getRate().divide(Env.ONEHUNDRED);
            bigDecimal = bigDecimal.add(bigDecimal.multiply(bigDecimal2));
        }
        if (bigDecimal.equals(Env.ZERO)) {
            return hashMap;
        }
        object = MFMAccount.getAccountFromAgreement(mFMAgreement);
        pO = null;
        if (object.isEmpty()) {
            pO = new MFMAccount(mFMAgreement);
            pO.saveEx();
        } else {
            pO = (MFMAccount)object.get(0);
        }
        ArrayList<AmortizationValue> arrayList = new ArrayList<AmortizationValue>();
        for (MFMAmortization mFMAmortization : MFMAmortization.getOpenFromAccount(((X_FM_Account)pO).getFM_Account_ID(), string)) {
            BigDecimal bigDecimal3;
            AmortizationValue amortizationValue;
            Timestamp timestamp2;
            if (mFMAmortization.isInvoiced() || mFMAmortization.isPaid() || (timestamp2 = timestamp).before((amortizationValue = new AmortizationValue(mFMAmortization)).getStartDate())) continue;
            if (amortizationValue.getEndDate().before(timestamp2)) {
                timestamp2 = amortizationValue.getEndDate();
            }
            int n3 = amortizationValue.getDayOfMonth();
            int n4 = amortizationValue.getDayOfMonth(timestamp);
            if (n3 == 0) continue;
            if (n4 > n3) {
                n4 = n3;
            }
            if ((bigDecimal3 = LoanUtil.getCurrentLoanInterest(amortizationValue, timestamp)) != null && !bigDecimal3.equals(Env.ZERO) && bigDecimal2 != null) {
                amortizationValue.setTaxAmtFee(amortizationValue.getInterestAmtFee().multiply(bigDecimal2));
            }
            arrayList.add(amortizationValue);
        }
        hashMap.put("AMORTIZATION_LIST", arrayList);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<AmortizationValue> getCurrentAmortizationList(Properties properties, int n, String string) {
        ArrayList<AmortizationValue> arrayList = new ArrayList<AmortizationValue>();
        String string2 = new String("SELECT * FROM RV_FM_LoanAmortization WHERE FM_Agreement_ID = ?");
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(string2, string);
            cPreparedStatement.setInt(1, n);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                AmortizationValue amortizationValue = new AmortizationValue();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string3 = resultSetMetaData.getColumnName(i);
                    if (string3.equalsIgnoreCase("FM_Amortization_ID")) {
                        amortizationValue.setAmortizationId(resultSet.getInt(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("PeriodNo")) {
                        amortizationValue.setPeriodNo(resultSet.getInt(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("CapitalAmt")) {
                        amortizationValue.setCapitalAmtFee(resultSet.getBigDecimal(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("CurrentInterestAmt")) {
                        amortizationValue.setInterestAmtFee(resultSet.getBigDecimal(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("CurrentDunningAmt")) {
                        amortizationValue.setDunningInterestAmount(resultSet.getBigDecimal(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("StartDate")) {
                        amortizationValue.setStartDate(resultSet.getTimestamp(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("EndDate")) {
                        amortizationValue.setEndDate(resultSet.getTimestamp(i));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("DueDate")) {
                        amortizationValue.setDueDate(resultSet.getTimestamp(i));
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("IsPaid")) continue;
                    String string4 = resultSet.getString(i);
                    amortizationValue.setPaid(!Util.isEmpty(string4) && string4.equals("Y"));
                }
                arrayList.add(amortizationValue);
            }
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, string2, exception);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
        }
        DB.close(resultSet, cPreparedStatement);
        return arrayList;
    }

    public static BigDecimal getDailyLoanInterest(AmortizationValue amortizationValue, Timestamp timestamp) {
        BigDecimal bigDecimal;
        Timestamp timestamp2 = timestamp;
        if (timestamp2.before(amortizationValue.getStartDate())) {
            return null;
        }
        if (amortizationValue.getEndDate().before(timestamp2)) {
            timestamp2 = amortizationValue.getEndDate();
        }
        int n = amortizationValue.getDayOfMonth();
        int n2 = amortizationValue.getDayOfMonth(timestamp);
        if (n == 0) {
            return null;
        }
        if (n2 > n) {
            n2 = n;
        }
        if ((bigDecimal = amortizationValue.getInterestAmtFee().divide(new BigDecimal(n), MathContext.DECIMAL128)) != null && !bigDecimal.equals(Env.ZERO)) {
            amortizationValue.setDailyInterest(bigDecimal);
        }
        return bigDecimal;
    }

    public static BigDecimal getCurrentLoanInterest(AmortizationValue amortizationValue, Timestamp timestamp) {
        BigDecimal bigDecimal = LoanUtil.getDailyLoanInterest(amortizationValue, timestamp);
        if (bigDecimal != null && !bigDecimal.equals(Env.ZERO)) {
            int n = amortizationValue.getDayOfMonth();
            int n2 = amortizationValue.getDayOfMonth(timestamp);
            if (n2 > n) {
                n2 = n;
            }
            amortizationValue.setInterestAmtFee(bigDecimal.multiply(new BigDecimal(n2)));
        }
        return amortizationValue.getInterestAmtFee();
    }
}

