/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.loan.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.spin.investment.loan.util.AmortizationValue;
import org.spin.investment.loan.util.LoanUtil;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMAmortization;
import org.spin.investment.model.MFMAmortizationSummary;
import org.spin.investment.model.MFMBatch;
import org.spin.investment.model.MFMFunctionalSetting;
import org.spin.investment.model.MFMTransaction;
import org.spin.investment.model.MFMTransactionType;
import org.spin.investment.util.AbstractFunctionalSetting;

public class LoanInterestProcess
extends AbstractFunctionalSetting {
    public LoanInterestProcess(MFMFunctionalSetting setting) {
        super(setting);
    }

    @Override
    public String run() {
        MFMAgreement agreement = (MFMAgreement)this.getParameter("MFMAgreement");
        MFMBatch batch = (MFMBatch)this.getParameter("MFMBatch");
        String trxName = (String)this.getParameter("TRX_NAME");
        if (agreement == null || batch == null) {
            return null;
        }
        MFMTransactionType interestType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LIN");
        MFMTransactionType interestTaxType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LIT");
        if (interestType == null) {
            throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LIN");
        }
        HashMap<String, Object> returnValues = LoanUtil.calculateLoanInterest(this.getCtx(), agreement.getFM_Agreement_ID(), new Timestamp(System.currentTimeMillis()), trxName);
        if (returnValues == null || returnValues.isEmpty()) {
            return null;
        }
        List amortizationList = (List)returnValues.get("AMORTIZATION_LIST");
        if (amortizationList == null) {
            return null;
        }
        AtomicReference<BigDecimal> capitalAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> interestAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> interestTaxAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        amortizationList.forEach(amortization -> {
            capitalAmount.updateAndGet(amount -> amount.add(amortization.getCapitalAmtFee()));
            interestAmount.updateAndGet(amount -> amount.add(amortization.getInterestAmtFee()));
            interestTaxAmount.updateAndGet(amount -> amount.add(amortization.getTaxAmtFee()));
        });
        List<MFMAccount> accounts = MFMAccount.getAccountFromAgreement(agreement);
        MFMAccount account = null;
        if (accounts.isEmpty()) {
            account = new MFMAccount(agreement);
            account.saveEx();
        } else {
            account = accounts.get(0);
        }
        for (AmortizationValue amortizationReference : amortizationList) {
            MFMTransaction transaction = batch.addTransaction(interestType.getFM_TransactionType_ID(), amortizationReference.getInterestAmtFee());
            if (transaction != null) {
                transaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationReference.getAmortizationId());
                transaction.saveEx();
            }
            if (interestTaxType != null && amortizationReference.getTaxAmtFee() != null && (transaction = batch.addTransaction(interestTaxType.getFM_TransactionType_ID(), amortizationReference.getTaxAmtFee())) != null) {
                transaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationReference.getAmortizationId());
                transaction.saveEx();
            }
            MFMAmortization amortization2 = new MFMAmortization(this.getCtx(), amortizationReference.getAmortizationId(), trxName);
            amortization2.setCurrentCapitalAmt(capitalAmount.get());
            amortization2.setCurrentInterestAmt(interestAmount.get());
            amortization2.setCurrentTaxAmt(interestTaxAmount.get());
            amortization2.saveEx();
            MFMAmortizationSummary.setCurrentInterest(this.getCtx(), account.getFM_Account_ID(), amortizationReference.getAmortizationId(), batch.getDateDoc(), capitalAmount.get(), interestAmount.get(), interestTaxAmount.get(), trxName);
        }
        return null;
    }
}

