/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.loan.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.adempiere.core.domains.models.X_FM_Rate;
import org.adempiere.core.domains.models.X_FM_TransactionType;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.investment.loan.util.AmortizationValue;
import org.spin.investment.loan.util.LoanUtil;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMAmortization;
import org.spin.investment.model.MFMBatch;
import org.spin.investment.model.MFMDunning;
import org.spin.investment.model.MFMFunctionalSetting;
import org.spin.investment.model.MFMProduct;
import org.spin.investment.model.MFMRate;
import org.spin.investment.model.MFMTransaction;
import org.spin.investment.model.MFMTransactionType;
import org.spin.investment.util.AbstractFunctionalSetting;

public class CreateBatchFromInvoice
extends AbstractFunctionalSetting {
    public CreateBatchFromInvoice(MFMFunctionalSetting mFMFunctionalSetting) {
        super(mFMFunctionalSetting);
    }

    @Override
    public String run() {
        MInvoice mInvoice = (MInvoice)this.getParameter("PO");
        if (mInvoice != null) {
            return this.generateBatch(mInvoice);
        }
        return null;
    }

    private String generateBatch(MInvoice mInvoice) {
        int n = mInvoice.getFM_Account_ID();
        if (n <= 0) {
            return null;
        }
        if (mInvoice.getReversal_ID() != 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(n);
            arrayList.add("CO");
            arrayList.add(mInvoice.getReversal_ID());
            MFMBatch mFMBatch = (MFMBatch)new Query(mInvoice.getCtx(), "FM_Batch", "FM_Account_ID=? AND DocStatus=? AND EXISTS(SELECT 1 \t\t\t\t\tFROM FM_Transaction t \t\t\t\t\tINNER JOIN C_InvoiceLine il ON(il.C_InvoiceLine_ID = t.C_InvoiceLine_ID) \t\t\t\t\tWHERE t.FM_Batch_ID = FM_Batch.FM_Batch_ID \t\t\t\t\tAND il.C_Invoice_ID = ?)", mInvoice.get_TrxName()).setParameters(arrayList).setOrderBy("DateDoc DESC").first();
            if (mFMBatch != null) {
                mFMBatch.processIt("RA");
                mFMBatch.saveEx();
            }
            return null;
        }
        MFMAccount mFMAccount = new MFMAccount(mInvoice.getCtx(), n, mInvoice.get_TrxName());
        this.setParameter("MFMAccount", mFMAccount);
        MFMAgreement mFMAgreement = (MFMAgreement)mFMAccount.getFM_Agreement();
        MFMProduct mFMProduct = MFMProduct.getById(this.getCtx(), mFMAgreement.getFM_Product_ID(), mInvoice.get_TrxName());
        MFMBatch mFMBatch = this.createBatch(mInvoice.getDateInvoiced());
        if (mFMBatch != null) {
            PO pO;
            MFMTransactionType mFMTransactionType;
            MDocType mDocType = MDocType.get(this.getCtx(), mInvoice.getC_DocType_ID());
            BigDecimal bigDecimal = Env.ONE;
            if (mDocType.getDocBaseType().endsWith("C")) {
                bigDecimal = bigDecimal.negate();
            }
            if ((mFMTransactionType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LCI")) == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LCI");
            }
            int n2 = mFMProduct.get_ValueAsInt("FM_Rate_ID");
            int n3 = mFMProduct.get_ValueAsInt("DunningInterest_ID");
            int n4 = mFMProduct.get_ValueAsInt("FM_Dunning_ID");
            int n5 = 0;
            int n6 = 0;
            if (n2 != 0) {
                pO = MFMRate.getById(this.getCtx(), n2);
                n5 = ((X_FM_Rate)pO).getC_Charge_ID();
            }
            if (n3 != 0) {
                pO = MFMRate.getById(this.getCtx(), n3);
                n6 = ((X_FM_Rate)pO).getC_Charge_ID();
            } else if (n4 != 0) {
                pO = MFMDunning.getById(this.getCtx(), n4);
                n6 = ((MFMDunning)pO).getChargeId();
            }
            pO = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LII");
            MFMTransactionType mFMTransactionType2 = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LTI");
            if (pO == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LII");
            }
            MFMTransactionType mFMTransactionType3 = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LDI");
            MFMTransactionType mFMTransactionType4 = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LTT");
            if (mFMTransactionType3 == null) {
                throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LDI");
            }
            for (MInvoiceLine mInvoiceLine : mInvoice.getLines()) {
                MFMTransaction mFMTransaction = null;
                PO pO2 = null;
                if (mInvoiceLine.getM_Product_ID() != 0 && mInvoiceLine.getM_Product_ID() == mFMProduct.getM_Product_ID()) {
                    mFMTransaction = mFMBatch.addTransaction(mFMTransactionType.getFM_TransactionType_ID(), mInvoiceLine.getLineNetAmt().multiply(bigDecimal));
                } else if (mInvoiceLine.getC_Charge_ID() != 0 && mInvoiceLine.getC_Charge_ID() == n5) {
                    int n7 = mInvoiceLine.getFM_Amortization_ID();
                    if (n7 > 0) {
                        MFMAmortization mFMAmortization = new MFMAmortization(this.getCtx(), n7, mInvoice.get_TrxName());
                        if (mFMAmortization.getEndDate().after(mInvoice.getDateInvoiced()) && mFMAmortization.getStartDate().getTime() <= mInvoice.getDateInvoiced().getTime()) {
                            BigDecimal bigDecimal2 = LoanUtil.getCurrentLoanInterest(new AmortizationValue(mFMAmortization), mInvoice.getDateInvoiced());
                            if (bigDecimal2 != null && !bigDecimal2.equals(Env.ZERO)) {
                                mFMTransaction = mFMBatch.addTransaction(((X_FM_TransactionType)pO).getFM_TransactionType_ID(), bigDecimal2.multiply(bigDecimal));
                                MTax mTax = (MTax)mInvoiceLine.getC_Tax();
                                BigDecimal bigDecimal3 = mTax.getRate().divide(Env.ONEHUNDRED);
                                if (!bigDecimal3.equals(Env.ZERO)) {
                                    pO2 = mFMBatch.addTransaction(mFMTransactionType2.getFM_TransactionType_ID(), bigDecimal2.multiply(bigDecimal3).multiply(bigDecimal));
                                }
                            }
                        } else if (mFMAmortization.getEndDate().getTime() <= mInvoice.getDateInvoiced().getTime()) {
                            mFMTransaction = mFMBatch.addTransaction(((X_FM_TransactionType)pO).getFM_TransactionType_ID(), mInvoiceLine.getLineNetAmt().multiply(bigDecimal));
                            pO2 = mFMBatch.addTransaction(mFMTransactionType2.getFM_TransactionType_ID(), mInvoiceLine.getTaxAmt().multiply(bigDecimal));
                        }
                    } else {
                        mFMTransaction = mFMBatch.addTransaction(((X_FM_TransactionType)pO).getFM_TransactionType_ID(), mInvoiceLine.getLineNetAmt().multiply(bigDecimal));
                        pO2 = mFMBatch.addTransaction(mFMTransactionType2.getFM_TransactionType_ID(), mInvoiceLine.getTaxAmt().multiply(bigDecimal));
                    }
                } else if (mInvoiceLine.getC_Charge_ID() != 0 && mInvoiceLine.getC_Charge_ID() == n6) {
                    mFMTransaction = mFMBatch.addTransaction(mFMTransactionType3.getFM_TransactionType_ID(), mInvoiceLine.getLineNetAmt().multiply(bigDecimal));
                    pO2 = mFMBatch.addTransaction(mFMTransactionType4.getFM_TransactionType_ID(), mInvoiceLine.getTaxAmt().multiply(bigDecimal));
                }
                if (mFMTransaction == null) continue;
                if (mInvoiceLine.getFM_Amortization_ID() != 0) {
                    mFMTransaction.set_ValueOfColumn("FM_Amortization_ID", (Object)mInvoiceLine.getFM_Amortization_ID());
                    mFMTransaction.set_ValueOfColumn("C_InvoiceLine_ID", (Object)mInvoiceLine.getC_InvoiceLine_ID());
                    mFMTransaction.saveEx();
                }
                if (pO2 == null || mInvoiceLine.getFM_Amortization_ID() == 0) continue;
                pO2.set_ValueOfColumn("FM_Amortization_ID", (Object)mInvoiceLine.getFM_Amortization_ID());
                pO2.set_ValueOfColumn("C_InvoiceLine_ID", (Object)mInvoiceLine.getC_InvoiceLine_ID());
                pO2.saveEx();
            }
            mFMBatch.processIt("CO");
            mFMBatch.saveEx();
        }
        return null;
    }
}

