/*
 * Decompiled with CFR 0.152.
 */
package org.spin.authentication.services.provider;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minidev.json.JSONObject;
import org.spin.authentication.services.OpenIDConnect;
import org.spin.authentication.services.OpenIDUtil;

public class GitHubAuthentication
extends OpenIDConnect {
    private static final String defaultScope = "user:email";
    private static final String authorizationEndPoint = "https://github.com/login/oauth/authorize";
    private static final String userInfoEndPoint = "https://api.github.com/user";
    private static final String tokenEndPoint = "https://github.com/login/oauth/access_token";

    public GitHubAuthentication() {
        this.setResponseType(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}));
        this.setAuthorizationEndPoint(authorizationEndPoint);
        this.setUserInfoEndpoint(userInfoEndPoint);
        this.setTokenEndpoint(tokenEndPoint);
        this.setScope(defaultScope);
    }

    @Override
    protected TokenResponse parseTokenResponse(HTTPResponse hTTPResponse) throws ParseException {
        JSONObject jSONObject = this.getContentAsJSONObject(hTTPResponse.getContent());
        if (hTTPResponse.getStatusCode() == 200 && jSONObject.get((Object)"access_token") != null) {
            return OIDCTokenResponse.parse((JSONObject)jSONObject);
        }
        return TokenErrorResponse.parse((JSONObject)jSONObject);
    }

    private JSONObject getContentAsJSONObject(String string) {
        JSONObject jSONObject = new JSONObject();
        Optional<Map<String, String>> optional = Optional.ofNullable(OpenIDUtil.getMapFromString(string, "&"));
        optional.ifPresent(map -> map.entrySet().forEach(entry -> jSONObject.put((Object)this.validData((String)entry.getKey()), (Object)this.validData((String)entry.getValue()))));
        return jSONObject;
    }

    @Override
    protected UserInfoResponse parseUserInfo(HTTPResponse hTTPResponse) throws ParseException {
        if (hTTPResponse.getStatusCode() == 200) {
            return GitHubAuthentication.parseJson(hTTPResponse.getContentAsJSONObject());
        }
        return UserInfoErrorResponse.parse((HTTPResponse)hTTPResponse);
    }

    private String validData(String string) {
        return Optional.ofNullable(string).orElse("").replace("bearer", "Bearer").replace("\n", "");
    }

    private static UserInfoSuccessResponse parseJson(JSONObject jSONObject) throws ParseException {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        Optional<JSONObject> optional = Optional.ofNullable(jSONObject);
        optional.ifPresent(jSONObject2 -> {
            boolean bl = jSONObject2.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals("sub"));
            if (!bl) {
                jSONObject2.put((Object)"sub", (Object)"");
            }
            UserInfo userInfo = new UserInfo(jSONObject);
            atomicReference.set(new UserInfoSuccessResponse(userInfo));
        });
        return atomicReference.get();
    }
}

