/*
 * Decompiled with CFR 0.152.
 */
package org.spin.authentication.services;

import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.spin.authentication.services.IOpenIDConnect;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.AppSupportHandler;

public class OpenIDUtil {
    public static final String PARAMETER_SEPARATOR = "|";
    public static final String DISPLAYNAME = "DISPLAYNAME";
    public static final String REDIRECT_URL = "REDIRECT_URL";
    public static final String CLIENT_ID = "CLIENT_ID";
    public static final String CLIENT_SECRET = "CLIENT_SECRET";
    public static final String ENDPOINT_Authorization_URI = "AUTHORIZATION_URI";
    public static final String SCOPES = "SCOPES";
    public static final String OPENID_ERROR_MESSAGE = "OPENID_ERROR_MESSAGE";
    public static final List<String> PARAMETER_TAGS = List.of("REDIRECT_URL", "CLIENT_ID", "CLIENT_SECRET");
    private static final CLogger log = CLogger.getCLogger(OpenIDUtil.class);

    public static String encodeText(String textToEncode) {
        return Base64.getEncoder().encodeToString(textToEncode.getBytes());
    }

    public static String decodeText(String textToDecode) {
        return new String(Base64.getDecoder().decode(textToDecode));
    }

    public static String getState(MADAppRegistration applicationRegistration) {
        AtomicReference<String> state = new AtomicReference<String>("");
        Optional<MADAppRegistration> maybeAppRegistration = Optional.ofNullable(applicationRegistration);
        maybeAppRegistration.ifPresent(appRegistration -> {
            StringBuffer appRegistrationKey = new StringBuffer("");
            appRegistrationKey.append("AD_AppRegistration_ID=" + appRegistration.get_ID());
            appRegistrationKey.append(PARAMETER_SEPARATOR);
            appRegistrationKey.append("ApplicationType=" + appRegistration.getApplicationType());
            state.set(OpenIDUtil.encodeText(appRegistrationKey.toString()));
        });
        return state.get();
    }

    public static Hashtable<Integer, Map<String, String>> getAuthenticationServices() {
        Hashtable<Integer, Map<String, String>> authenticationServices = new Hashtable<Integer, Map<String, String>>();
        MADAppRegistration.getAll(Env.getCtx(), false, null).stream().filter(applicationRegistration -> applicationRegistration.getApplicationType().equals("OIA") && applicationRegistration.isActive()).forEach(applicationRegistration -> {
            try {
                IOpenIDConnect authenticationService = (IOpenIDConnect)AppSupportHandler.getInstance().getAppSupport((MADAppRegistration)applicationRegistration);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(DISPLAYNAME, applicationRegistration.getName());
                data.put(ENDPOINT_Authorization_URI, authenticationService.getServiceURL());
                authenticationServices.put(authenticationService.getAppRegistrationId(), data);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
        });
        return authenticationServices;
    }

    public static Map<String, String> getMapFromString(String stringToMap, String separator) {
        Optional<String> maybeStringToMap = Optional.ofNullable(stringToMap);
        AtomicReference map = new AtomicReference(new HashMap());
        maybeStringToMap.ifPresent(StringToMap -> map.set(Arrays.stream(StringToMap.split(separator)).map(stringValue -> stringValue.split("=")).collect(Collectors.toMap(stringArray -> stringArray[0], stringArray -> stringArray[1]))));
        return map.get();
    }

    public static MUser getUserAuthenticated(String codeParameter, String stateParameter) {
        Optional<String> maybeCode = Optional.ofNullable(codeParameter);
        Optional<String> maybeState = Optional.ofNullable(stateParameter);
        AtomicReference<Object> user = new AtomicReference<Object>(null);
        maybeCode.ifPresent(code -> maybeState.ifPresent(state -> {
            Map<String, String> stateMap = OpenIDUtil.getMapFromString(OpenIDUtil.decodeText(state), Pattern.quote(PARAMETER_SEPARATOR));
            Optional<String> maybeAppRegistrationParameter = Optional.ofNullable(stateMap.get("AD_AppRegistration_ID"));
            Optional<String> maybeApplicationType = Optional.ofNullable(stateMap.get("ApplicationType"));
            maybeAppRegistrationParameter.ifPresent(appRegistrationParameter -> maybeApplicationType.ifPresent(applicationType -> {
                if (applicationType.equals("OIA")) {
                    try {
                        int appRegistrationId = Integer.parseInt(appRegistrationParameter);
                        MADAppRegistration appRegistration = MADAppRegistration.getById(Env.getCtx(), appRegistrationId, null);
                        IOpenIDConnect authenticationService = (IOpenIDConnect)AppSupportHandler.getInstance().getAppSupport(appRegistration);
                        MUser userEnvironment = null;
                        if (Env.getAD_User_ID(Env.getCtx()) > 0) {
                            userEnvironment = MUser.get(Env.getCtx());
                        }
                        authenticationService.validateAuthentication(codeParameter, userEnvironment);
                        Optional<MUser> maybeUser = Optional.ofNullable(authenticationService.getUser());
                        authenticationService.clearValues();
                        maybeUser.ifPresent(userAuthenticated -> {
                            if (userAuthenticated.isLoginUser() && userAuthenticated.isActive()) {
                                user.set(userAuthenticated);
                            }
                        });
                        maybeUser.orElseGet(() -> {
                            if (Env.getAD_User_ID(Env.getCtx()) == 0) {
                                OpenIDUtil.setErrorMessage(Env.getCtx(), Msg.getMsg(Language.getBaseAD_Language(), "UserNotVerified"));
                            }
                            return null;
                        });
                    }
                    catch (Exception e) {
                        log.severe(e.getMessage());
                    }
                }
            }));
        }));
        return user.get();
    }

    public static void setErrorMessage(Properties ctx, String message) {
        Env.setContext(ctx, OPENID_ERROR_MESSAGE, message);
    }

    public static String getErrorMessage(Properties ctx) {
        return Env.getContext(ctx, OPENID_ERROR_MESSAGE);
    }
}

