/*
 * Decompiled with CFR 0.152.
 */
package org.spin.authentication.services;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.model.MUserAuthentication;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.authentication.services.IOpenIDConnect;
import org.spin.authentication.services.OpenIDUtil;
import org.spin.model.MADAppRegistration;

public abstract class OpenIDConnect
implements IOpenIDConnect {
    private static final CLogger log = CLogger.getCLogger(OpenIDConnect.class);
    private MADAppRegistration applicationRegistration = null;
    private int registrationId = 0;
    private Boolean isValid = null;
    private String accessToken = null;
    private String refreshToken = null;
    private URI authorizationEndPoint = null;
    private URI tokenEndpoint = null;
    private URI redirectURL = null;
    private URI userInfoEndpoint = null;
    private ClientID clientID = null;
    private Scope scope = null;
    private ResponseType responseType = null;
    private Secret clientSecret = null;
    HashMap<String, String> userInfoData = new HashMap();

    @Override
    public String testConnection() {
        if (this.validateSetting()) {
            return "@OK@";
        }
        return "";
    }

    private boolean validateSetting() {
        AtomicReference<Boolean> atomicReference = new AtomicReference<Boolean>(true);
        OpenIDUtil.PARAMETER_TAGS.forEach(string -> Optional.ofNullable(this.getApplicationRegistration().getParameterValue((String)string)).orElseGet(() -> {
            atomicReference.set(false);
            return "";
        }));
        return atomicReference.get();
    }

    public MADAppRegistration getApplicationRegistration() {
        this.applicationRegistration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
        return this.applicationRegistration;
    }

    public boolean isValid() {
        return Optional.ofNullable(this.isValid).orElseGet(() -> {
            this.isValid = this.validateSetting();
            return this.isValid;
        });
    }

    @Override
    public String getServiceURL() {
        String string2 = null;
        if (this.isValid()) {
            State state = new State(OpenIDUtil.getState(this.applicationRegistration));
            Optional<String> optional = Optional.ofNullable(this.getApplicationRegistration().getParameterValue("SCOPES"));
            optional.ifPresent(string -> this.setScope(string.split(",")));
            AuthorizationRequest authorizationRequest = new AuthorizationRequest.Builder(this.getResponseType(), this.getClientID()).scope(this.getScope()).state(state).redirectionURI(this.getRedirectURL()).endpointURI(this.getAuthorizationEndPoint()).build();
            string2 = authorizationRequest.toURI().toString();
        }
        return string2;
    }

    @Override
    public void setAppRegistrationId(int n) {
        this.registrationId = n;
        this.isValid = null;
    }

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    private void accessToken(String string2) {
        Optional<String> optional = Optional.ofNullable(string2);
        optional.ifPresent(string -> {
            try {
                AuthorizationCode authorizationCode = new AuthorizationCode(string);
                AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(authorizationCode, this.getRedirectURL());
                ClientSecretBasic clientSecretBasic = new ClientSecretBasic(this.getClientID(), this.getClientSecret());
                TokenRequest tokenRequest = new TokenRequest(this.getTokenEndpoint(), (ClientAuthentication)clientSecretBasic, (AuthorizationGrant)authorizationCodeGrant);
                TokenResponse tokenResponse = this.parseTokenResponse(tokenRequest.toHTTPRequest().send());
                if (!tokenResponse.indicatesSuccess()) {
                    log.severe(tokenResponse.toErrorResponse().getErrorObject().toString());
                    return;
                }
                OIDCTokenResponse oIDCTokenResponse = (OIDCTokenResponse)tokenResponse.toSuccessResponse();
                Optional<AccessToken> optional = Optional.ofNullable(oIDCTokenResponse.getOIDCTokens().getAccessToken());
                optional.ifPresent(accessToken -> {
                    this.accessToken = accessToken.getValue();
                });
                Optional<RefreshToken> optional2 = Optional.ofNullable(oIDCTokenResponse.getOIDCTokens().getRefreshToken());
                optional2.ifPresent(refreshToken -> {
                    this.refreshToken = refreshToken.getValue();
                });
            }
            catch (ParseException parseException) {
                log.severe(parseException.getMessage());
            }
            catch (IOException iOException) {
                log.severe(iOException.getMessage());
            }
        });
    }

    @Override
    public void validateAuthentication(String string, MUser mUser2) {
        Optional<MUser> optional = Optional.ofNullable(mUser2);
        this.accessToken(string);
        optional = Optional.ofNullable(optional.orElse(this.getUser()));
        optional.ifPresent(mUser -> MUserAuthentication.createUserAuthentication().withUserId(mUser.get_ID()).withAppRegistrationId(this.getAppRegistrationId()).withAccessToken(this.accessToken).withRefreshToken(this.refreshToken).saveEx());
    }

    @Override
    public Map<String, String> getUserInfo() {
        if (this.userInfoData.isEmpty()) {
            try {
                BearerAccessToken bearerAccessToken = new BearerAccessToken(this.accessToken);
                HTTPResponse hTTPResponse = new UserInfoRequest(this.getUserInfoEndpoint(), (AccessToken)bearerAccessToken).toHTTPRequest().send();
                UserInfoResponse userInfoResponse = this.parseUserInfo(hTTPResponse);
                if (!userInfoResponse.indicatesSuccess()) {
                    log.severe(userInfoResponse.toErrorResponse().getErrorObject().toString());
                    return this.userInfoData;
                }
                UserInfo userInfo = userInfoResponse.toSuccessResponse().getUserInfo();
                this.userInfoData = userInfo.toJSONObject().entrySet().stream().collect(Collectors.toMap(entry -> Optional.ofNullable((String)entry.getKey()).orElse("").toString(), entry -> Optional.ofNullable(entry.getValue()).orElse("").toString(), (string, string2) -> string, HashMap::new));
            }
            catch (IOException iOException) {
                log.severe(iOException.getMessage());
            }
            catch (ParseException parseException) {
                log.severe(parseException.getMessage());
            }
        }
        return this.userInfoData;
    }

    protected TokenResponse parseTokenResponse(HTTPResponse hTTPResponse) throws ParseException {
        return OIDCTokenResponseParser.parse((HTTPResponse)hTTPResponse);
    }

    protected UserInfoResponse parseUserInfo(HTTPResponse hTTPResponse) throws ParseException {
        return UserInfoResponse.parse((HTTPResponse)hTTPResponse);
    }

    @Override
    public MUser getUser() {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        Optional<String> optional = Optional.ofNullable(this.getUserInfo().get("email"));
        optional.ifPresent(string -> atomicReference.set(MUser.getUsers(Env.getCtx(), string).stream().findFirst().orElse(null)));
        return atomicReference.get();
    }

    public ClientID getClientID() {
        this.clientID = Optional.ofNullable(this.clientID).orElse(new ClientID(this.applicationRegistration.getParameterValue("CLIENT_ID")));
        return this.clientID;
    }

    public Secret getClientSecret() {
        this.clientSecret = Optional.ofNullable(this.clientSecret).orElse(new Secret(this.applicationRegistration.getParameterValue("CLIENT_SECRET")));
        return this.clientSecret;
    }

    public URI getAuthorizationEndPoint() {
        return this.authorizationEndPoint;
    }

    public void setAuthorizationEndPoint(String string) {
        Optional<String> optional = Optional.ofNullable(string);
        optional.ifPresent(string2 -> {
            this.authorizationEndPoint = this.getValidURL(string);
        });
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String string) {
        Optional<String> optional = Optional.ofNullable(string);
        optional.ifPresent(string2 -> {
            this.tokenEndpoint = this.getValidURL(string);
        });
    }

    public URI getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String string) {
        Optional<String> optional = Optional.ofNullable(string);
        optional.ifPresent(string2 -> {
            this.userInfoEndpoint = this.getValidURL(string);
        });
    }

    public URI getRedirectURL() {
        this.redirectURL = Optional.ofNullable(this.redirectURL).orElse(this.getValidURL(this.applicationRegistration.getParameterValue("REDIRECT_URL")));
        return this.redirectURL;
    }

    private URI getValidURL(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            log.severe(uRISyntaxException.getMessage());
        }
        return uRI;
    }

    public void setScope(String ... stringArray) {
        this.scope = new Scope(stringArray);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    @Override
    public void clearValues() {
        this.accessToken = null;
        this.refreshToken = null;
        this.userInfoData.clear();
    }
}

