/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils.model;

import java.util.Properties;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MOrder {
    public static org.compiere.model.MOrder createNegative(org.compiere.model.MOrder mOrder) {
        MOrderLine[] lines;
        org.compiere.model.MOrder negativeMOrder = new org.compiere.model.MOrder(mOrder.getCtx(), 0, mOrder.get_TrxName());
        PO.copyValues(mOrder, negativeMOrder);
        negativeMOrder.setDocumentNo(null);
        negativeMOrder.setDateOrdered(mOrder.getDateOrdered());
        negativeMOrder.setDatePromised(mOrder.getDatePromised());
        negativeMOrder.setDateAcct(mOrder.getDateAcct());
        negativeMOrder.setDatePrinted(mOrder.getDatePrinted());
        negativeMOrder.setPOReference(mOrder.getDocumentNo());
        negativeMOrder.addDescription(Msg.parseTranslation(mOrder.getCtx(), "@Generated@ [@C_Order_ID@ " + mOrder.getDocumentNo()) + "]");
        negativeMOrder.setDocStatus("DR");
        negativeMOrder.setDocAction("CO");
        negativeMOrder.setTotalLines(Env.ZERO);
        negativeMOrder.setGrandTotal(Env.ZERO);
        negativeMOrder.setIsSOTrx(mOrder.isSOTrx());
        negativeMOrder.setRef_Order_ID(-1);
        negativeMOrder.setIsDropShip(false);
        negativeMOrder.setDropShip_BPartner_ID(0);
        negativeMOrder.setDropShip_Location_ID(0);
        negativeMOrder.setDropShip_User_ID(0);
        negativeMOrder.set_ValueOfColumn("IsAllowToInvoice", (Object)false);
        negativeMOrder.saveEx();
        for (MOrderLine line : lines = mOrder.getLines(true, null)) {
            MOrderLine negativeOrderLine = new MOrderLine(negativeMOrder);
            negativeOrderLine.setOrder(negativeMOrder);
            negativeOrderLine.setProduct(line.getProduct());
            negativeOrderLine.setC_Charge_ID(line.getC_Charge_ID());
            negativeOrderLine.setLineNetAmt(line.getLineNetAmt());
            negativeOrderLine.setQty(line.getQtyEntered());
            negativeOrderLine.setPrice(line.getPriceEntered().negate());
            negativeOrderLine.setC_UOM_ID(line.getC_UOM_ID());
            negativeOrderLine.setTax();
            negativeOrderLine.setUser1_ID(line.getUser1_ID());
            negativeOrderLine.setUser3_ID(line.getUser3_ID());
            negativeOrderLine.setUser4_ID(line.getUser4_ID());
            negativeOrderLine.saveEx();
        }
        return negativeMOrder;
    }

    public static boolean partiallyBilled(org.compiere.model.MOrder mOrder) {
        boolean ret = new Query(mOrder.getCtx(), "C_OrderLine", "C_Order_ID=?", mOrder.get_TrxName()).setParameters(mOrder.get_ID()).list().stream().mapToDouble(mOrderLine -> mOrderLine.getQtyInvoiced().doubleValue()).sum() > 0.0;
        return ret;
    }

    public static boolean isFullyRecognized(Properties ctx, String trxName, int orderId) {
        if (orderId <= 0) {
            return false;
        }
        String sqlQuery = "C_Order.docStatus IN ('CO','CL')\nAND NOT EXISTS (\n\tSELECT 1\n\tFROM C_OrderLine ol\n\tLEFT JOIN C_RevenueRecognition_Plan rrp ON ol.C_OrderLine_ID=rrp.C_OrderLine_ID\n\tWHERE C_Order.C_Order_ID=ol.C_Order_ID\n\tAND (\n\t\trrp.IsRecognized IS NULL\n\t\tOR rrp.IsRecognized <> 'Y'\n\t)\n)\nAND C_Order.C_Order_ID=?\n";
        boolean ret = new Query(ctx, "C_Order", sqlQuery, trxName).setParameters(orderId).match();
        return ret;
    }

    public static void updateFullyRecognized(org.compiere.model.MOrder mOrder) {
        boolean isFullyRecognized = MOrder.isFullyRecognized(mOrder.getCtx(), mOrder.get_TrxName(), mOrder.get_ID());
        mOrder.set_ValueOfColumn("IsRecognized", (Object)isFullyRecognized);
    }
}

