/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class SCOTIABANK_BankTransaction
extends BankTransactionAbstract {
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_Description = "Description";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    private static final char START_CHAR_VALUE = ';';
    private boolean isTransaction = false;
    public static final String DEBT = "DR";
    public static final String CREDIT = "CR";

    public void parseLine(String line) throws Exception {
        int i;
        if (Util.isEmpty(line)) {
            return;
        }
        if (Util.isEmpty(line = this.processValue(line))) {
            return;
        }
        line = line.replaceAll("\"", "");
        int startIndex = 0;
        int endIndex = 0;
        for (i = 0; i < 3; ++i) {
            startIndex = line.indexOf(59);
            line = line.substring(startIndex + 1);
        }
        this.addValue(LINE_TRANSACTION_Date, this.getDate("dd.MM.yy", this.subString(line, 0, 8)));
        for (i = 0; i < 3; ++i) {
            startIndex = line.indexOf(59);
            line = line.substring(startIndex + 1);
        }
        int initPosition = 0;
        startIndex = line.indexOf(59);
        String value = this.subString(line, initPosition, startIndex);
        for (int i2 = 0; i2 < 4; ++i2) {
            startIndex = line.indexOf(59);
            line = line.substring(startIndex + 1);
        }
        if (!Util.isEmpty(value)) {
            this.addValue(LINE_TRANSACTION_Description, value.replaceAll(";", "").trim());
        }
        line = line.replaceAll("\\+", "");
        startIndex = 0;
        endIndex = line.indexOf(59) + initPosition;
        BigDecimal amount = this.getNumber(',', "#,###,###,###,###,###.##", this.subString(line, startIndex, endIndex));
        this.addValue(LINE_TRANSACTION_Amount, amount);
        if (amount != null && amount.compareTo(Env.ZERO) < 0) {
            this.addValue(LINE_TRANSACTION_Type, DEBT);
        } else if (amount != null) {
            this.addValue(LINE_TRANSACTION_Type, CREDIT);
        }
        this.isTransaction = true;
    }

    @Override
    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    @Override
    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    @Override
    public String getPayeeAccountNo() {
        return null;
    }

    @Override
    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    @Override
    protected String processValue(String value) {
        return value;
    }

    @Override
    public boolean isEndTransactionLine(String line) {
        return true;
    }

    @Override
    public boolean isCompleteData() {
        return this.isTransaction;
    }

    @Override
    public String getCurrency() {
        return null;
    }

    @Override
    public String getBPartnerValue() {
        return null;
    }

    @Override
    public int getBPartnerID() {
        return 0;
    }

    @Override
    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    @Override
    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    @Override
    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    @Override
    public String getPayeeName() {
        return null;
    }

    @Override
    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_Description);
    }

    @Override
    public String getMemo() {
        return null;
    }

    @Override
    public String getTrxType() {
        return null;
    }

    @Override
    public String getTrxCode() {
        return null;
    }
}

