/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBank;
import org.compiere.model.MLocation;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.openup.core.utils.LUYPaymentExportList;

public class PayPro_PaymentExport
extends LUYPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(PayPro_PaymentExport.class);
    private int paymentQty = 0;
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return this.export(checks, file, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int export(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
                MBPartnerLocation[] locations;
                String mail = "";
                String bankName = "";
                String bankAccount = "";
                String taxGroup = "";
                String taxID = "";
                String address = "";
                String city = "";
                String region = "";
                MBPartner bpartner = MBPartner.get(paySelectionCheck.getCtx(), paySelectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)paySelectionCheck, true);
                List<MUser> users = Arrays.asList(MUser.getOfBPartner(paySelectionCheck.getCtx(), bpartner.getC_BPartner_ID(), paySelectionCheck.get_TrxName()));
                if (!users.isEmpty()) {
                    int userID = ((MUser)users.stream().findFirst().get()).getAD_User_ID();
                    MUser user = new MUser(paySelectionCheck.getCtx(), userID, paySelectionCheck.get_TrxName());
                    if (user.getEMail() != null) {
                        mail = user.getEMail();
                    }
                }
                String bpname = bpartner.getName();
                String currency = paySelection.getC_Currency().getISO_Code();
                String amount = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(",", "").replace(".", ",");
                String finalAmount = currency + " " + amount;
                if (bpAccount != null) {
                    MBank bpBank = MBank.get(Env.getCtx(), bpAccount.getC_Bank_ID());
                    bankName = bpBank.getName();
                    bankAccount = bpAccount.getAccountNo();
                }
                if (bpartner.getC_BP_Group_ID() > 0) {
                    taxGroup = bpartner.getC_TaxGroup().getName();
                }
                if (bpartner.getTaxID() != null && !bpartner.getTaxID().equalsIgnoreCase("")) {
                    taxID = bpartner.getTaxID();
                }
                if ((locations = MBPartnerLocation.getForBPartner(paySelectionCheck.getCtx(), bpartner.get_ID(), paySelectionCheck.get_TrxName())).length > 0) {
                    int locationID = locations[0].getC_BPartner_Location_ID();
                    MBPartnerLocation bpLocation = new MBPartnerLocation(paySelectionCheck.getCtx(), locationID, paySelectionCheck.get_TrxName());
                    MLocation location = bpLocation.getLocation(false);
                    if (location != null) {
                        address = location.getAddress1();
                        if (location.getC_City_ID() > 0) {
                            city = location.getC_City().getName();
                        } else if (location.getC_City() != null && !location.getCity().equalsIgnoreCase("")) {
                            city = location.getCity();
                        }
                        if (location.getC_Region_ID() > 0) {
                            region = location.getC_Region().getName();
                        } else if (location.getRegionName() != null && !location.getRegionName().equalsIgnoreCase("")) {
                            region = location.getRegionName();
                        }
                    }
                }
                StringBuffer line = new StringBuffer();
                line.append(CRLF).append(mail).append(";").append(bpname).append(";").append(finalAmount).append(";").append(bankName).append(";").append(bankAccount).append(";").append(taxGroup).append(";").append(taxID).append(";").append(address).append(";").append(city).append(";").append(region);
                this.writeLine(line.toString());
                this.addPaymentToCounter();
            });
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private int getPaymentQty() {
        return this.paymentQty;
    }

    private void addPaymentToCounter() {
        ++this.paymentQty;
    }
}

