/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.io.File;
import java.util.List;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.PaymentExportList;
import org.compiere.util.Util;

public abstract class LUYPaymentExportList
extends PaymentExportList {
    public int exportToFileAsVerification(MBankAccount bankAccount, List<MPayment> payments, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsEnrollmentRequest(List<MBPartner> bPartnerList, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsEnrollment(MBankAccount bankAccount, List<MBPBankAccount> bPartnerAccountList, boolean isEnroll, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsPayroll(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsAccountPayable(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return 0;
    }

    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        MPaySelectionCheck check = checks.get(0);
        int payselectionlineId = DB.getSQLValue(check.get_TrxName(), "SELECT C_PaySelectionLine_ID FROM C_PaySelectionLine WHERE C_PaySelectionCheck_ID = ?", check.getC_PaySelectionCheck_ID());
        if (payselectionlineId > 0) {
            MPaySelectionLine line = new MPaySelectionLine(check.getCtx(), payselectionlineId, check.get_TrxName());
            if (line.getHR_Movement_ID() > 0) {
                return this.exportToFileAsPayroll(checks, file, error);
            }
            return this.exportToFileAsAccountPayable(checks, file, error);
        }
        return this.exportToFileAsAccountPayable(checks, file, error);
    }

    @Override
    public void openFileWriter(File file, List<MPaySelectionCheck> checks) {
        MPaySelectionCheck check = checks.get(0);
        MPaySelection paymentSelection = check.getParent();
        MBankAccount bankAccount = MBankAccount.get(Env.getCtx(), paymentSelection.getC_BankAccount_ID());
        MBank bank = MBank.get(Env.getCtx(), bankAccount.getC_Bank_ID());
        String fileName = this.getFileName(file, bank.getName(), paymentSelection.getDocumentNo());
        this.openFileWriter(fileName);
    }

    @Override
    public void openFileWriter(File file, MBankAccount bankAccount, List<MPayment> payments, String suffix) {
        if (Util.isEmpty(suffix)) {
            suffix = "";
        }
        MPayment firstPayment = payments.get(0);
        MPaymentBatch paymentBatch = (MPaymentBatch)firstPayment.getC_PaymentBatch();
        MBank bank = MBank.get(Env.getCtx(), bankAccount.getC_Bank_ID());
        String fileName = this.getFileName(file, bank.getName(), paymentBatch.getDocumentNo() + suffix);
        this.openFileWriter(fileName);
    }

    @Override
    public void openFileWriter(File file, String bankName, String documentNo) {
        String fileName = this.getFileName(file, bankName, documentNo);
        this.openFileWriter(fileName);
    }

    @Override
    public void openFileWriter(String newName) {
        File newFile = new File(newName);
        this.deleteIfExist(newFile);
        this.openFileWriter(newFile);
    }

    @Override
    public String getParentFileName(File file) {
        StringBuffer pathName = new StringBuffer();
        if (file.isFile() || !file.exists()) {
            pathName.append(file.getParent());
        } else {
            pathName.append(file.getAbsolutePath());
        }
        return pathName.toString();
    }

    @Override
    public String getFileName(File file, String bankName, String documentNo) {
        if (file == null) {
            return null;
        }
        String extension = ".txt";
        StringBuffer pathName = new StringBuffer(this.getParentFileName(file));
        pathName.append(File.separator).append(this.processValue(bankName)).append("_").append(this.processValue(documentNo)).append(extension);
        return pathName.toString().replace(" ", "_");
    }

    public boolean isNumeric(String value) {
        if (Util.isEmpty(value)) {
            return false;
        }
        return value.matches("[+-]?\\d*(\\.\\d+)?");
    }

    public String getNumericOnly(String value) {
        if (Util.isEmpty(value)) {
            return value;
        }
        return value.replaceAll("\\D+", "");
    }

    @Override
    public String processValue(String value) {
        if (Util.isEmpty(value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7,;*./?-]", "").trim();
    }
}

