/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.util.EMail;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.openup.core.model.I_UY_EmailLog;
import org.openup.core.model.MUYEmailLog;
import org.openup.core.model.MUYEmailLogBatch;

public class EmailSender {
    private Properties ctx;
    private MUYEmailLogBatch muyEmailLogBatch;
    private List<EmailLogDTO> emailLogDTOS;

    private EmailSender(Properties ctx) {
        this.ctx = ctx;
        this.muyEmailLogBatch = new MUYEmailLogBatch(ctx, 0, null);
        this.emailLogDTOS = new ArrayList<EmailLogDTO>();
    }

    public static EmailSender newInstance(Properties ctx) {
        return new EmailSender(ctx);
    }

    public void add(MUYEmailLog muyEmailLog, File ... attachments) {
        this.emailLogDTOS.add(new EmailLogDTO(muyEmailLog, attachments));
    }

    public void save(boolean asAsync) {
        Trx.run(trxName -> {
            this.muyEmailLogBatch.saveEx(trxName);
            for (EmailLogDTO emailLogDTO : this.emailLogDTOS) {
                MUYEmailLog muyEmailLog = emailLogDTO.getMuyEmailLog();
                if (muyEmailLog.getStatus() == null || muyEmailLog.getStatus().isEmpty()) {
                    muyEmailLog.setStatus(asAsync ? "PS" : "SA");
                }
                muyEmailLog.setUY_EmailLogBatch_ID(this.muyEmailLogBatch.get_ID());
                muyEmailLog.saveEx(trxName);
                File[] attachments = emailLogDTO.getAttachments();
                if (attachments == null || attachments.length <= 0) continue;
                MAttachment mAttachment = muyEmailLog.getAttachment();
                if (mAttachment == null) {
                    mAttachment = new MAttachment(this.ctx, I_UY_EmailLog.Table_ID, muyEmailLog.get_ID(), trxName);
                }
                for (File attachment : attachments) {
                    mAttachment.addEntry(attachment);
                }
                mAttachment.saveEx();
            }
        });
    }

    public void send() {
        this.send(false);
    }

    public void send(boolean onlyAsync) {
        List<Object> toSend = new ArrayList();
        toSend = onlyAsync ? this.emailLogDTOS.stream().map(EmailLogDTO::getMuyEmailLog).filter(muyEmailLog -> "PS".equalsIgnoreCase(muyEmailLog.getStatus())).collect(Collectors.toList()) : this.emailLogDTOS.stream().map(EmailLogDTO::getMuyEmailLog).filter(muyEmailLog -> "SA".equalsIgnoreCase(muyEmailLog.getStatus()) || "PS".equalsIgnoreCase(muyEmailLog.getStatus())).collect(Collectors.toList());
        for (MUYEmailLog muyEmailLog2 : toSend) {
            Trx.run(trxName -> {
                try {
                    MClient client = MClient.get(this.ctx);
                    EMail email = client.createEMail(muyEmailLog2.getEMail_To(), null, null);
                    if (!email.isValid()) {
                        throw new AdempiereException("@EMail_To@ @invalid@ \"" + email + "\"");
                    }
                    if (muyEmailLog2.isHtml()) {
                        email.setMessageHTML(muyEmailLog2.getSubject(), muyEmailLog2.getMessage());
                    } else {
                        email.setSubject(muyEmailLog2.getSubject());
                        email.setMessageText(muyEmailLog2.getMessage());
                    }
                    MAttachment mAttachment = muyEmailLog2.getAttachment();
                    for (int i = 0; i < mAttachment.getEntryCount(); ++i) {
                        File file = mAttachment.getEntryFile(i, mAttachment.getEntryName(i));
                        email.addAttachment(file);
                    }
                    muyEmailLog2.setEMail_From(email.getFrom().getAddress());
                    muyEmailLog2.setResponseText(email.send());
                    if ("OK".equals(muyEmailLog2.getResponseText())) {
                        muyEmailLog2.setStatus("SE");
                    } else {
                        muyEmailLog2.setStatus("ER");
                    }
                }
                catch (AdempiereException e) {
                    muyEmailLog2.setStatus("ER");
                    muyEmailLog2.setResponseText(Msg.translate(this.ctx, e.getMessage()));
                }
                catch (Exception e) {
                    muyEmailLog2.setStatus("ER");
                    muyEmailLog2.setResponseText(e.getMessage());
                }
                finally {
                    muyEmailLog2.saveEx(trxName);
                }
            });
        }
    }

    public String getValue() {
        return this.muyEmailLogBatch != null ? this.muyEmailLogBatch.getValue() : null;
    }

    private class EmailLogDTO {
        private MUYEmailLog muyEmailLog;
        private File[] attachments;

        public EmailLogDTO(MUYEmailLog muyEmailLog, File ... attachments) {
            this.muyEmailLog = muyEmailLog;
            this.attachments = attachments;
        }

        public MUYEmailLog getMuyEmailLog() {
            return this.muyEmailLog;
        }

        public File[] getAttachments() {
            return this.attachments;
        }
    }
}

