/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import com.eevolution.model.MSContract;
import com.eevolution.model.X_S_ContractLine;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.core.process.UpdateSContractPricesAbstract;

public class UpdateSContractPrices
extends UpdateSContractPricesAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Object strWhere;
        int s_contract_id = this.getContractId();
        int ad_org_id = this.getOrgId();
        int calendar_id = this.getCalendarId();
        if (s_contract_id <= 0 && ad_org_id <= 0) {
            throw new AdempiereException("Seleccione Contrato u Organizaci\u00f3n");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (s_contract_id > 0) {
            strWhere = "S_Contract_ID=?";
            params.add(s_contract_id);
        } else {
            strWhere = "DocStatus NOT IN ('CL','VO') AND AD_Org_ID=?";
            params.add(ad_org_id);
        }
        if (calendar_id > 0) {
            strWhere = (String)strWhere + " AND PP_Calendar_ID=?";
            params.add(calendar_id);
        }
        List<MSContract> msContracts = new Query(this.getCtx(), "S_Contract", (String)strWhere, this.get_TrxName()).setParameters(params).list();
        AtomicInteger cont = new AtomicInteger();
        msContracts.forEach(msContract -> cont.addAndGet(this.updateSContract((MSContract)msContract) ? 1 : 0));
        return "Contratos actualizados: " + cont.get();
    }

    private boolean updateSContract(MSContract msContract) {
        MPriceList mPriceList = (MPriceList)msContract.getM_PriceList();
        if (mPriceList == null || mPriceList.get_ID() <= 0) {
            throw new AdempiereException("Lista de precios del contrato no definida");
        }
        MPriceListVersion mPriceListVersion = mPriceList.getPriceListVersion(null);
        if (mPriceListVersion == null || mPriceListVersion.get_ID() <= 0) {
            throw new AdempiereException("Versi\u00f3n de lista de precios " + mPriceList.getName() + " no encontrada");
        }
        List msContractLines = new Query(this.getCtx(), "S_ContractLine", "S_Contract_ID=?", this.get_TrxName()).setParameters(msContract.get_ID()).list();
        for (X_S_ContractLine msContractLine : msContractLines) {
            MProductPrice[] mProductPrice;
            MProduct mProduct = (MProduct)msContractLine.getM_Product();
            if (mProduct == null || mProduct.get_ID() <= 0 || (mProductPrice = mPriceListVersion.getProductPrice(" AND M_Product_ID=" + mProduct.getM_Product_ID())).length <= 0) continue;
            BigDecimal priceList = mProductPrice[0].getPriceList();
            msContractLine.setPriceList(priceList);
            BigDecimal discount = msContractLine.getDiscount();
            msContractLine.setPriceEntered(priceList.multiply(Env.ONE.subtract(discount.divide(Env.ONEHUNDRED))));
            msContractLine.saveEx();
        }
        return true;
    }
}

