/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.util.List;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.openup.core.process.UpdateOrderCommissionRunAbstract;
import org.spin.model.AgencyValidator;

public class UpdateOrderCommissionRun
extends UpdateOrderCommissionRunAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getTable_ID() == 259) {
            PO mOrder;
            try {
                mOrder = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            }
            catch (Exception e) {
                mOrder = null;
            }
            if (mOrder == null || mOrder.get_ID() <= 0) {
                throw new AdempiereException("@C_Order_ID@ @not.found@");
            }
            AgencyValidator.updateCommissionRunForOrder((MOrder)mOrder);
            return "@C_CommissionRun_ID@ @Updated@";
        }
        if (this.getTable_ID() == 318) {
            MDocType documentType;
            PO mInvoice;
            try {
                mInvoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            }
            catch (Exception e) {
                mInvoice = null;
            }
            if (mInvoice == null || mInvoice.get_ID() <= 0) {
                throw new AdempiereException("@C_Invoice_ID@ @not.found@");
            }
            if (!((MInvoice)mInvoice).isReversal() && (documentType = MDocType.get(mInvoice.getCtx(), ((X_C_Invoice)mInvoice).getC_DocTypeTarget_ID())).get_ValueAsInt("C_CommissionType_ID") > 0) {
                AgencyValidator.createCommissionForInvoice((MInvoice)mInvoice, documentType.get_ValueAsInt("C_CommissionType_ID"), true);
                if (((X_C_Invoice)mInvoice).getC_DocType().getDocBaseType().endsWith("I")) {
                    List<MInvoice> referencedInvoices = MAllocationHdr.getAllocatedInvoices(this.getCtx(), mInvoice.get_ID(), this.get_TrxName());
                    for (MInvoice refInvoice : referencedInvoices) {
                        AgencyValidator.createCommissionForInvoice(refInvoice, documentType.get_ValueAsInt("C_CommissionType_ID"), true);
                    }
                }
            }
            return "@C_CommissionRun_ID@ @Updated@";
        }
        throw new AdempiereException("@AD_Table_ID@ @not.found@");
    }
}

